/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.lucene.grouping.TopFieldGroups;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreContext;

public class RescorePhase {
    private RescorePhase() {
    }

    public static void execute(SearchContext context) {
        if (context.size() == 0 || context.rescore() == null || context.rescore().isEmpty()) {
            return;
        }
        TopDocs topDocs = context.queryResult().topDocs().topDocs;
        if (topDocs.scoreDocs.length == 0) {
            return;
        }
        TopFieldGroups topGroups = null;
        if (topDocs instanceof TopFieldGroups) {
            TopFieldGroups topFieldGroups = (TopFieldGroups)topDocs;
            assert (context.collapse() != null);
            topGroups = topFieldGroups;
        }
        try {
            for (RescoreContext ctx : context.rescore()) {
                topDocs = ctx.rescorer().rescore(topDocs, context.searcher(), ctx);
                assert (context.sort() == null && RescorePhase.topDocsSortedByScore(topDocs)) : "topdocs should be sorted after rescore";
            }
            if (topGroups != null) {
                assert (context.collapse() != null);
                topDocs = RescorePhase.rewriteTopGroups(topGroups, topDocs);
            }
            context.queryResult().topDocs(new TopDocsAndMaxScore(topDocs, topDocs.scoreDocs[0].score), context.queryResult().sortValueFormats());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Rescore Phase Failed", (Throwable)e, new Object[0]);
        }
    }

    private static TopFieldGroups rewriteTopGroups(TopFieldGroups originalTopGroups, TopDocs rescoredTopDocs) {
        assert (originalTopGroups.fields.length == 1 && SortField.FIELD_SCORE.equals(originalTopGroups.fields[0])) : "rescore must always sort by score descending";
        Map<Integer, Object> docIdToGroupValue = Maps.newMapWithExpectedSize(originalTopGroups.scoreDocs.length);
        for (int i = 0; i < originalTopGroups.scoreDocs.length; ++i) {
            docIdToGroupValue.put(originalTopGroups.scoreDocs[i].doc, originalTopGroups.groupValues[i]);
        }
        ScoreDoc[] newScoreDocs = new FieldDoc[rescoredTopDocs.scoreDocs.length];
        Object[] newGroupValues = new Object[originalTopGroups.groupValues.length];
        int pos = 0;
        for (ScoreDoc doc : rescoredTopDocs.scoreDocs) {
            newScoreDocs[pos] = new FieldDoc(doc.doc, doc.score, new Object[]{Float.valueOf(doc.score)});
            newGroupValues[pos++] = docIdToGroupValue.get(doc.doc);
        }
        return new TopFieldGroups(originalTopGroups.field, originalTopGroups.totalHits, newScoreDocs, originalTopGroups.fields, newGroupValues);
    }

    private static boolean topDocsSortedByScore(TopDocs topDocs) {
        if (topDocs == null || topDocs.scoreDocs == null || topDocs.scoreDocs.length < 2) {
            return true;
        }
        float lastScore = topDocs.scoreDocs[0].score;
        for (int i = 1; i < topDocs.scoreDocs.length; ++i) {
            ScoreDoc doc = topDocs.scoreDocs[i];
            if (Float.compare(doc.score, lastScore) > 0) {
                return false;
            }
            lastScore = doc.score;
        }
        return true;
    }
}

