/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.feature;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankShardResult;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;

public class RankFeatureShardResult
implements RankShardResult {
    public static final String NAME = "rank_feature_shard";
    public final RankFeatureDoc[] rankFeatureDocs;

    public RankFeatureShardResult(RankFeatureDoc[] rankFeatureDocs) {
        this.rankFeatureDocs = Objects.requireNonNull(rankFeatureDocs);
    }

    public RankFeatureShardResult(StreamInput in) throws IOException {
        this.rankFeatureDocs = in.readArray(RankFeatureDoc::new, RankFeatureDoc[]::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.RANK_FEATURE_PHASE_ADDED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.rankFeatureDocs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankFeatureShardResult that = (RankFeatureShardResult)o;
        return Arrays.equals(this.rankFeatureDocs, that.rankFeatureDocs);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.rankFeatureDocs);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{rankFeatureDocs=" + Arrays.toString(this.rankFeatureDocs) + "}";
    }
}

