/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.rescore.RescoreContext;

public final class ExplainPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(final FetchContext context) {
        if (!context.explain()) {
            return null;
        }
        return new FetchSubPhaseProcessor(){
            private final List<String> queryNames;
            {
                this.queryNames = context.queryNames();
            }

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                int topLevelDocId = hitContext.hit().docId();
                Explanation explanation = context.searcher().explain(context.rewrittenQuery(), topLevelDocId);
                for (RescoreContext rescore : context.rescore()) {
                    explanation = rescore.rescorer().explain(topLevelDocId, context.searcher(), rescore, explanation);
                }
                if (context.rankBuilder() != null) {
                    explanation = context.rankBuilder().explainHit(explanation, hitContext.rankDoc(), this.queryNames);
                }
                hitContext.hit().explanation(explanation);
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }
        };
    }
}

