/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.SamplingContext;

class SignificanceLookup {
    private final AggregationContext context;
    private final MappedFieldType fieldType;
    private final DocValueFormat format;
    private final Query backgroundFilter;
    private final int supersetNumDocs;
    private TermsEnum termsEnum;

    SignificanceLookup(AggregationContext context, SamplingContext samplingContext, MappedFieldType fieldType, DocValueFormat format, QueryBuilder backgroundFilter) throws IOException {
        Query contextFiltered;
        MatchAllDocsQuery matchAllDocsQuery;
        Query contextFiltered2;
        Query backgroundQuery;
        this.context = context;
        this.fieldType = fieldType;
        this.format = format;
        Query query = backgroundQuery = backgroundFilter == null ? (Query)samplingContext.buildSamplingQueryIfNecessary(context).orElse(null) : samplingContext.buildQueryWithSampler(backgroundFilter, context);
        this.backgroundFilter = backgroundQuery == null ? ((contextFiltered2 = context.filterQuery(matchAllDocsQuery = new MatchAllDocsQuery())) != matchAllDocsQuery ? contextFiltered2 : null) : (contextFiltered = context.filterQuery(backgroundQuery));
        IndexSearcher searcher = context.searcher();
        this.supersetNumDocs = this.backgroundFilter == null ? searcher.getIndexReader().maxDoc() : searcher.count(this.backgroundFilter);
    }

    long supersetSize() {
        return this.supersetNumDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundFrequencyForBytes bytesLookup(final BigArrays bigArrays, CardinalityUpperBound cardinality) {
        if (cardinality == CardinalityUpperBound.ONE) {
            return new BackgroundFrequencyForBytes(){

                @Override
                public long freq(BytesRef term) throws IOException {
                    return SignificanceLookup.this.getBackgroundFrequency(term);
                }

                @Override
                public void close() {
                }
            };
        }
        final BytesRefHash termToPosition = new BytesRefHash(1L, bigArrays);
        boolean success = false;
        try {
            BackgroundFrequencyForBytes b = new BackgroundFrequencyForBytes(){
                private LongArray positionToFreq;
                {
                    this.positionToFreq = bigArrays.newLongArray(1L, false);
                }

                @Override
                public long freq(BytesRef term) throws IOException {
                    long position = termToPosition.add(term);
                    if (position < 0L) {
                        return this.positionToFreq.get(-1L - position);
                    }
                    long freq = SignificanceLookup.this.getBackgroundFrequency(term);
                    this.positionToFreq = bigArrays.grow(this.positionToFreq, position + 1L);
                    this.positionToFreq.set(position, freq);
                    return freq;
                }

                @Override
                public void close() {
                    Releasables.close(termToPosition, this.positionToFreq);
                }
            };
            success = true;
            BackgroundFrequencyForBytes backgroundFrequencyForBytes = b;
            return backgroundFrequencyForBytes;
        }
        finally {
            if (!success) {
                termToPosition.close();
            }
        }
    }

    private long getBackgroundFrequency(BytesRef term) throws IOException {
        return this.getBackgroundFrequency(this.context.buildQuery(new TermQueryBuilder(this.fieldType.name(), this.format.format(term).toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundFrequencyForLong longLookup(final BigArrays bigArrays, CardinalityUpperBound cardinality) {
        if (cardinality == CardinalityUpperBound.ONE) {
            return new BackgroundFrequencyForLong(){

                @Override
                public long freq(long term) throws IOException {
                    return SignificanceLookup.this.getBackgroundFrequency(term);
                }

                @Override
                public void close() {
                }
            };
        }
        final LongHash termToPosition = new LongHash(1L, bigArrays);
        boolean success = false;
        try {
            BackgroundFrequencyForLong b = new BackgroundFrequencyForLong(){
                private LongArray positionToFreq;
                {
                    this.positionToFreq = bigArrays.newLongArray(1L, false);
                }

                @Override
                public long freq(long term) throws IOException {
                    long position = termToPosition.add(term);
                    if (position < 0L) {
                        return this.positionToFreq.get(-1L - position);
                    }
                    long freq = SignificanceLookup.this.getBackgroundFrequency(term);
                    this.positionToFreq = bigArrays.grow(this.positionToFreq, position + 1L);
                    this.positionToFreq.set(position, freq);
                    return freq;
                }

                @Override
                public void close() {
                    Releasables.close(termToPosition, this.positionToFreq);
                }
            };
            success = true;
            BackgroundFrequencyForLong backgroundFrequencyForLong = b;
            return backgroundFrequencyForLong;
        }
        finally {
            if (!success) {
                termToPosition.close();
            }
        }
    }

    private long getBackgroundFrequency(long term) throws IOException {
        return this.getBackgroundFrequency(this.context.buildQuery(new TermQueryBuilder(this.fieldType.name(), this.format.format(term).toString())));
    }

    private long getBackgroundFrequency(Query query) throws IOException {
        if (query instanceof TermQuery) {
            Term term = ((TermQuery)query).getTerm();
            TermsEnum termsEnum = this.getTermsEnum();
            if (termsEnum.seekExact(term.bytes())) {
                return termsEnum.docFreq();
            }
            return 0L;
        }
        if (this.backgroundFilter != null) {
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.backgroundFilter, BooleanClause.Occur.FILTER).build();
        }
        return new IndexSearcher(this.context.searcher().getIndexReader()).count(query);
    }

    private TermsEnum getTermsEnum() throws IOException {
        if (this.termsEnum != null) {
            return this.termsEnum;
        }
        IndexReader reader = this.context.searcher().getIndexReader();
        this.termsEnum = new FilterableTermsEnum(reader, this.fieldType.name(), 0, this.backgroundFilter);
        return this.termsEnum;
    }

    static interface BackgroundFrequencyForLong
    extends Releasable {
        public long freq(long var1) throws IOException;
    }

    static interface BackgroundFrequencyForBytes
    extends Releasable {
        public long freq(BytesRef var1) throws IOException;
    }
}

