/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplingQuery;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.SamplingContext;

public class RandomSamplerAggregatorFactory
extends AggregatorFactory {
    private final int seed;
    private final Integer shardSeed;
    private final double probability;
    private final SamplingContext samplingContext;
    private Weight weight;

    RandomSamplerAggregatorFactory(String name, int seed, Integer shardSeed, double probability, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.probability = probability;
        this.seed = seed;
        this.samplingContext = new SamplingContext(probability, seed, shardSeed);
        this.shardSeed = shardSeed;
    }

    @Override
    public Optional<SamplingContext> getSamplingContext() {
        return Optional.of(this.samplingContext);
    }

    @Override
    public Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new RandomSamplerAggregator(this.name, this.seed, this.shardSeed, this.probability, this::getWeight, this.factories, this.context, parent, cardinality, metadata);
    }

    private Weight getWeight() throws IOException {
        if (this.weight == null) {
            RandomSamplingQuery query = new RandomSamplingQuery(this.probability, this.seed, this.shardSeed == null ? this.context.shardRandomSeed() : this.shardSeed.intValue());
            BooleanQuery booleanQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.context.query(), BooleanClause.Occur.FILTER).build();
            this.weight = this.context.searcher().createWeight(this.context.searcher().rewrite(booleanQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return this.weight;
    }
}

