/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

abstract class LongKeyedMultiBucketsAggregatorReducer<B extends MultiBucketsAggregation.Bucket>
implements Releasable {
    private final AggregationReduceContext reduceContext;
    private final int size;
    private final long minDocCount;
    private final LongObjectPagedHashMap<BucketReducer<B>> bucketsReducer;
    int consumeBucketCount = 0;

    LongKeyedMultiBucketsAggregatorReducer(AggregationReduceContext reduceContext, int size, long minDocCount) {
        this.reduceContext = reduceContext;
        this.size = size;
        this.minDocCount = minDocCount;
        this.bucketsReducer = new LongObjectPagedHashMap(size, reduceContext.bigArrays());
    }

    public final void accept(long key, B bucket) {
        BucketReducer<B> reducer = this.bucketsReducer.get(key);
        if (reducer == null) {
            reducer = new BucketReducer<B>(bucket, this.reduceContext, this.size);
            this.bucketsReducer.put(key, reducer);
        }
        this.consumeBucketsAndMaybeBreak(reducer, bucket);
        reducer.accept(bucket);
    }

    private void consumeBucketsAndMaybeBreak(BucketReducer<B> reducer, B bucket) {
        if (!this.reduceContext.isFinalReduce() || this.minDocCount == 0L) {
            if (reducer.getDocCount() == 0L && bucket.getDocCount() > 0L) {
                this.consumeBucketsAndMaybeBreak();
            }
        } else if (reducer.getDocCount() < this.minDocCount && reducer.getDocCount() + bucket.getDocCount() >= this.minDocCount) {
            this.consumeBucketsAndMaybeBreak();
        }
    }

    private void consumeBucketsAndMaybeBreak() {
        if (this.consumeBucketCount++ >= 10000) {
            this.reduceContext.consumeBucketsAndMaybeBreak(this.consumeBucketCount);
            this.consumeBucketCount = 0;
        }
    }

    public final List<B> get() {
        this.reduceContext.consumeBucketsAndMaybeBreak(this.consumeBucketCount);
        ArrayList reducedBuckets = new ArrayList((int)this.bucketsReducer.size());
        this.bucketsReducer.forEach(entry -> {
            if (!this.reduceContext.isFinalReduce() || ((BucketReducer)entry.value).getDocCount() >= this.minDocCount) {
                reducedBuckets.add(this.createBucket(entry.key, ((BucketReducer)entry.value).getDocCount(), ((BucketReducer)entry.value).getAggregations()));
            }
        });
        return reducedBuckets;
    }

    protected abstract B createBucket(long var1, long var3, InternalAggregations var5);

    @Override
    public final void close() {
        this.bucketsReducer.forEach(r -> Releasables.close((Releasable)r.value));
        Releasables.close(this.bucketsReducer);
    }
}

