/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.sort.SortValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalAggregation
implements Aggregation,
NamedWriteable {
    protected final String name;
    protected final Map<String, Object> metadata;

    protected InternalAggregation(String name, Map<String, Object> metadata) {
        this.name = name;
        this.metadata = metadata;
    }

    protected InternalAggregation(StreamInput in) throws IOException {
        this.name = in.readString();
        this.metadata = in.readGenericMap();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeGenericValue(this.metadata);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public String getName() {
        return this.name;
    }

    public InternalAggregation copyWithRewritenBuckets(Function<InternalAggregations, InternalAggregations> rewriter) {
        throw new IllegalStateException("Aggregation [" + this.getName() + "] must be a bucket aggregation but was [" + this.getWriteableName() + "]");
    }

    public void forEachBucket(Consumer<InternalAggregations> consumer) {
    }

    public InternalAggregation reducePipelines(InternalAggregation reducedAggs, AggregationReduceContext reduceContext, PipelineAggregator.PipelineTree pipelinesForThisAgg) {
        assert (reduceContext.isFinalReduce());
        for (PipelineAggregator pipelineAggregator : pipelinesForThisAgg.aggregators()) {
            reducedAggs = pipelineAggregator.reduce(reducedAggs, reduceContext);
        }
        return reducedAggs;
    }

    public final AggregatorReducer getReducer(final AggregationReduceContext reduceContext, final int size) {
        if (this.canLeadReduction()) {
            return this.getLeaderReducer(reduceContext, size);
        }
        final InternalAggregation current = this;
        return new AggregatorReducer(){
            AggregatorReducer aggregatorReducer = null;

            @Override
            public void accept(InternalAggregation aggregation) {
                if (this.aggregatorReducer != null) {
                    this.aggregatorReducer.accept(aggregation);
                } else if (aggregation.canLeadReduction()) {
                    this.aggregatorReducer = aggregation.getReducer(reduceContext, size);
                    this.aggregatorReducer.accept(aggregation);
                }
            }

            @Override
            public InternalAggregation get() {
                return this.aggregatorReducer == null ? current : this.aggregatorReducer.get();
            }

            @Override
            public void close() {
                Releasables.close((Releasable)this.aggregatorReducer);
            }
        };
    }

    protected abstract AggregatorReducer getLeaderReducer(AggregationReduceContext var1, int var2);

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        throw new UnsupportedOperationException(this.getWriteableName() + " aggregation [" + this.getName() + "] does not support sampling");
    }

    protected abstract boolean mustReduceOnSingleInternalAgg();

    public boolean canLeadReduction() {
        return true;
    }

    public Object getProperty(String path) {
        AggregationPath aggPath = AggregationPath.parse(path);
        return this.getProperty(aggPath.getPathElementsAsStringList());
    }

    public abstract Object getProperty(List<String> var1);

    protected static int readSize(StreamInput in) throws IOException {
        int size = in.readVInt();
        return size == 0 ? Integer.MAX_VALUE : size;
    }

    protected static void writeSize(int size, StreamOutput out) throws IOException {
        if (size == Integer.MAX_VALUE) {
            size = 0;
        }
        out.writeVInt(size);
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getType() {
        return this.getWriteableName();
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params.paramAsBoolean("typed_keys", false)) {
            builder.startObject(String.join((CharSequence)"#", this.getType(), this.getName()));
        } else {
            builder.startObject(this.getName());
        }
        if (this.metadata != null) {
            builder.field(Aggregation.CommonFields.META.getPreferredName());
            builder.map(this.metadata);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.name, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        InternalAggregation other = (InternalAggregation)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public SortValue sortValue(String key) {
        throw new IllegalArgumentException("Can't sort a [" + this.getType() + "] aggregation [" + this.getName() + "]");
    }

    public SortValue sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        throw new IllegalArgumentException("Can't sort by a descendant of a [" + this.getType() + "] aggregation [" + head + "]");
    }
}

