/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.List;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.VectorUtil;

public interface DenseVector {
    public static final DenseVector EMPTY = new DenseVector(){
        public static final String MISSING_VECTOR_FIELD_MESSAGE = "Dense vector value missing for a field, use isEmpty() to check for a missing vector value";

        @Override
        public float getMagnitude() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public int dotProduct(byte[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double dotProduct(float[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double dotProduct(List<Number> queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public int l1Norm(byte[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double l1Norm(float[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double l1Norm(List<Number> queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public int hamming(byte[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public int hamming(List<Number> queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double l2Norm(byte[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double l2Norm(List<Number> queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double l2Norm(float[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double cosineSimilarity(byte[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double cosineSimilarity(byte[] queryVector, float qvMagnitude) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double cosineSimilarity(float[] queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public double cosineSimilarity(List<Number> queryVector) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public float[] getVector() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getDims() {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }

        @Override
        public int size() {
            return 0;
        }
    };

    default public void checkDimensions(int qvDims) {
        DenseVector.checkDimensions(this.getDims(), qvDims);
    }

    public float[] getVector();

    public float getMagnitude();

    public int dotProduct(byte[] var1);

    public double dotProduct(float[] var1);

    public double dotProduct(List<Number> var1);

    default public double dotProduct(Object queryVector) {
        if (queryVector instanceof float[]) {
            float[] floats = (float[])queryVector;
            this.checkDimensions(floats.length);
            return this.dotProduct(floats);
        }
        if (queryVector instanceof List) {
            List list = (List)queryVector;
            this.checkDimensions(list.size());
            return this.dotProduct(list);
        }
        if (queryVector instanceof byte[]) {
            byte[] bytes = (byte[])queryVector;
            this.checkDimensions(bytes.length);
            return this.dotProduct(bytes);
        }
        throw new IllegalArgumentException(DenseVector.badQueryVectorType(queryVector));
    }

    public int l1Norm(byte[] var1);

    public double l1Norm(float[] var1);

    public double l1Norm(List<Number> var1);

    default public double l1Norm(Object queryVector) {
        if (queryVector instanceof float[]) {
            float[] floats = (float[])queryVector;
            this.checkDimensions(floats.length);
            return this.l1Norm(floats);
        }
        if (queryVector instanceof List) {
            List list = (List)queryVector;
            this.checkDimensions(list.size());
            return this.l1Norm(list);
        }
        if (queryVector instanceof byte[]) {
            byte[] bytes = (byte[])queryVector;
            this.checkDimensions(bytes.length);
            return this.l1Norm(bytes);
        }
        throw new IllegalArgumentException(DenseVector.badQueryVectorType(queryVector));
    }

    public int hamming(byte[] var1);

    public int hamming(List<Number> var1);

    default public int hamming(Object queryVector) {
        if (queryVector instanceof List) {
            List list = (List)queryVector;
            this.checkDimensions(list.size());
            return this.hamming(list);
        }
        if (queryVector instanceof byte[]) {
            byte[] bytes = (byte[])queryVector;
            this.checkDimensions(bytes.length);
            return this.hamming(bytes);
        }
        throw new IllegalArgumentException(DenseVector.badQueryVectorType(queryVector));
    }

    public double l2Norm(byte[] var1);

    public double l2Norm(float[] var1);

    public double l2Norm(List<Number> var1);

    default public double l2Norm(Object queryVector) {
        if (queryVector instanceof float[]) {
            float[] floats = (float[])queryVector;
            this.checkDimensions(floats.length);
            return this.l2Norm(floats);
        }
        if (queryVector instanceof List) {
            List list = (List)queryVector;
            this.checkDimensions(list.size());
            return this.l2Norm(list);
        }
        if (queryVector instanceof byte[]) {
            byte[] bytes = (byte[])queryVector;
            this.checkDimensions(bytes.length);
            return this.l2Norm(bytes);
        }
        throw new IllegalArgumentException(DenseVector.badQueryVectorType(queryVector));
    }

    default public double cosineSimilarity(byte[] queryVector) {
        return this.cosineSimilarity(queryVector, DenseVector.getMagnitude(queryVector));
    }

    public double cosineSimilarity(byte[] var1, float var2);

    default public double cosineSimilarity(float[] queryVector) {
        return this.cosineSimilarity(queryVector, true);
    }

    public double cosineSimilarity(float[] var1, boolean var2);

    public double cosineSimilarity(List<Number> var1);

    default public double cosineSimilarity(Object queryVector) {
        if (queryVector instanceof float[]) {
            float[] floats = (float[])queryVector;
            this.checkDimensions(floats.length);
            return this.cosineSimilarity(floats);
        }
        if (queryVector instanceof List) {
            List list = (List)queryVector;
            this.checkDimensions(list.size());
            return this.cosineSimilarity(list);
        }
        if (queryVector instanceof byte[]) {
            byte[] bytes = (byte[])queryVector;
            this.checkDimensions(bytes.length);
            return this.cosineSimilarity(bytes);
        }
        throw new IllegalArgumentException(DenseVector.badQueryVectorType(queryVector));
    }

    public boolean isEmpty();

    public int getDims();

    public int size();

    public static float getMagnitude(byte[] vector) {
        return (float)Math.sqrt(VectorUtil.dotProduct(vector, vector));
    }

    public static float getMagnitude(byte[] vector, int dims) {
        int mag = 0;
        for (int i = 0; i < dims; ++i) {
            byte elem = vector[i];
            mag += elem * elem;
        }
        return (float)Math.sqrt(mag);
    }

    public static float getBitMagnitude(byte[] vector, int dims) {
        int i;
        int count = 0;
        int upperBound = dims & 0xFFFFFFF8;
        for (i = 0; i < upperBound; i += 8) {
            count += Long.bitCount(BitUtil.VH_NATIVE_LONG.get(vector, i));
        }
        while (i < dims) {
            count += Integer.bitCount(vector[i] & 0xFF);
            ++i;
        }
        return (float)Math.sqrt(count);
    }

    public static float getMagnitude(float[] vector) {
        return (float)Math.sqrt(VectorUtil.dotProduct(vector, vector));
    }

    public static float getMagnitude(List<Number> vector) {
        double mag = 0.0;
        for (Number number : vector) {
            float elem = number.floatValue();
            mag += (double)(elem * elem);
        }
        return (float)Math.sqrt(mag);
    }

    public static void checkDimensions(int dvDims, int qvDims) {
        if (dvDims != qvDims) {
            throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims + "] than the document vectors [" + dvDims + "].");
        }
    }

    private static String badQueryVectorType(Object queryVector) {
        return "Cannot use vector [" + queryVector + "] with class [" + queryVector.getClass().getName() + "] as query vector";
    }
}

