/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.action.admin.cluster.desirednodes.UpdateDesiredNodesAction;
import org.elasticsearch.action.admin.cluster.desirednodes.UpdateDesiredNodesRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class RestUpdateDesiredNodesAction
extends BaseRestHandler {
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestUpdateDesiredNodesAction.class);
    private static final String VERSION_DEPRECATION_MESSAGE = "[version removal] Specifying node_version in desired nodes requests is deprecated.";
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public RestUpdateDesiredNodesAction(Predicate<NodeFeature> clusterSupportsFeature) {
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    @Override
    public String getName() {
        return "update_desired_nodes";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "_internal/desired_nodes/{history_id}/{version}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateDesiredNodesRequest updateDesiredNodesRequest;
        String historyId = request.param("history_id");
        long version = request.paramAsLong("version", Long.MIN_VALUE);
        boolean dryRun = request.paramAsBoolean("dry_run", false);
        try (XContentParser parser = request.contentParser();){
            updateDesiredNodesRequest = UpdateDesiredNodesRequest.fromXContent(historyId, version, dryRun, parser);
        }
        if (this.clusterSupportsFeature.test(DesiredNode.DESIRED_NODE_VERSION_DEPRECATED)) {
            if (updateDesiredNodesRequest.getNodes().stream().anyMatch(DesiredNode::hasVersion)) {
                this.deprecationLogger.compatibleCritical("desired_nodes_version", VERSION_DEPRECATION_MESSAGE, new Object[0]);
            }
        } else if (updateDesiredNodesRequest.getNodes().stream().anyMatch(n -> !n.hasVersion())) {
            throw new XContentParseException("[node_version] field is required and must have a valid value");
        }
        updateDesiredNodesRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        return restChannel -> client.execute(UpdateDesiredNodesAction.INSTANCE, updateDesiredNodesRequest, new RestToXContentListener((RestChannel)restChannel));
    }
}

