/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateNodeRemovalAction;
import org.elasticsearch.action.admin.cluster.node.shutdown.PrevalidateNodeRemovalRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestPrevalidateNodeRemovalAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_internal/prevalidate_node_removal"));
    }

    @Override
    public String getName() {
        return "prevalidate_node_removal";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] ids = request.paramAsStringArray("ids", Strings.EMPTY_ARRAY);
        String[] names = request.paramAsStringArray("names", Strings.EMPTY_ARRAY);
        String[] externalIds = request.paramAsStringArray("external_ids", Strings.EMPTY_ARRAY);
        PrevalidateNodeRemovalRequest prevalidationRequest = PrevalidateNodeRemovalRequest.builder().setNames(names).setIds(ids).setExternalIds(externalIds).build();
        prevalidationRequest.timeout(request.paramAsTime("timeout", prevalidationRequest.timeout()));
        if (request.hasParam("master_timeout")) {
            prevalidationRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        } else {
            prevalidationRequest.masterNodeTimeout(prevalidationRequest.timeout());
        }
        return channel -> client.execute(PrevalidateNodeRemovalAction.INSTANCE, prevalidationRequest, new RestToXContentListener((RestChannel)channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

