/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesRequest;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActions;

@ServerlessScope(value=Scope.INTERNAL)
public class RestNodesCapabilitiesAction
extends BaseRestHandler {
    public static final NodeFeature CAPABILITIES_ACTION = new NodeFeature("rest.capabilities_action");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_capabilities"));
    }

    @Override
    public Set<String> supportedQueryParameters() {
        return Set.of("timeout", "method", "path", "parameters", "capabilities");
    }

    @Override
    public String getName() {
        return "nodes_capabilities_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        NodesCapabilitiesRequest r = ((NodesCapabilitiesRequest)new NodesCapabilitiesRequest().timeout(RestUtils.getTimeout(request))).method(RestRequest.Method.valueOf(request.param("method", "GET"))).path(URLDecoder.decode(request.param("path"), StandardCharsets.UTF_8)).parameters(request.paramAsStringArray("parameters", Strings.EMPTY_ARRAY)).capabilities(request.paramAsStringArray("capabilities", Strings.EMPTY_ARRAY)).restApiVersion(request.getRestApiVersion());
        return channel -> client.admin().cluster().nodesCapabilities(r, new RestActions.NodesResponseRestListener<NodesCapabilitiesResponse>((RestChannel)channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

