/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestCancellableNodeClient;

@ServerlessScope(value=Scope.INTERNAL)
public class RestClusterStatsAction
extends BaseRestHandler {
    private static final Set<String> SUPPORTED_CAPABILITIES = Set.of("human-readable-total-docs-size");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/stats"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/stats/nodes/{nodeId}"));
    }

    @Override
    public String getName() {
        return "cluster_stats_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClusterStatsRequest clusterStatsRequest = new ClusterStatsRequest(request.paramAsStringArray("nodeId", null));
        clusterStatsRequest.timeout(RestUtils.getTimeout(request));
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().cluster().clusterStats(clusterStatsRequest, new RestActions.NodesResponseRestListener<ClusterStatsResponse>((RestChannel)channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    public Set<String> supportedCapabilities() {
        return SUPPORTED_CAPABILITIES;
    }
}

