/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.util.function.Function;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestToXContentListener<Response extends ToXContentObject>
extends RestBuilderListener<Response> {
    protected final Function<Response, RestStatus> statusFunction;
    private final Function<Response, String> locationFunction;

    public RestToXContentListener(RestChannel channel) {
        this(channel, r -> RestStatus.OK);
    }

    public RestToXContentListener(RestChannel channel, Function<Response, RestStatus> statusFunction) {
        this(channel, statusFunction, r -> {
            assert (false) : "Returned a 201 CREATED but not set up to support a Location header from " + r.getClass();
            return null;
        });
    }

    public RestToXContentListener(RestChannel channel, Function<Response, RestStatus> statusFunction, Function<Response, String> locationFunction) {
        super(channel);
        this.statusFunction = statusFunction;
        this.locationFunction = locationFunction;
    }

    @Override
    public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
        String location;
        assert (!response.isFragment());
        response.toXContent(builder, this.channel.request());
        RestStatus restStatus = this.statusFunction.apply(response);
        RestResponse r = new RestResponse(restStatus, builder);
        if (RestStatus.CREATED == restStatus && (location = this.locationFunction.apply(response)) != null) {
            r.addHeader("Location", location);
        }
        return r;
    }
}

