/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.elasticsearch.core.Strings;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.api.Augmentation;
import org.elasticsearch.painless.api.ValueIterator;
import org.elasticsearch.painless.ir.BinaryImplNode;
import org.elasticsearch.painless.ir.BinaryMathNode;
import org.elasticsearch.painless.ir.BlockNode;
import org.elasticsearch.painless.ir.BooleanNode;
import org.elasticsearch.painless.ir.BreakNode;
import org.elasticsearch.painless.ir.CastNode;
import org.elasticsearch.painless.ir.CatchNode;
import org.elasticsearch.painless.ir.ClassNode;
import org.elasticsearch.painless.ir.ComparisonNode;
import org.elasticsearch.painless.ir.ConditionalNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.ContinueNode;
import org.elasticsearch.painless.ir.DeclarationBlockNode;
import org.elasticsearch.painless.ir.DeclarationNode;
import org.elasticsearch.painless.ir.DefInterfaceReferenceNode;
import org.elasticsearch.painless.ir.DoWhileLoopNode;
import org.elasticsearch.painless.ir.DupNode;
import org.elasticsearch.painless.ir.ElvisNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.ir.FlipArrayIndexNode;
import org.elasticsearch.painless.ir.FlipCollectionIndexNode;
import org.elasticsearch.painless.ir.FlipDefIndexNode;
import org.elasticsearch.painless.ir.ForEachLoopNode;
import org.elasticsearch.painless.ir.ForEachSubArrayNode;
import org.elasticsearch.painless.ir.ForEachSubIterableNode;
import org.elasticsearch.painless.ir.ForLoopNode;
import org.elasticsearch.painless.ir.FunctionNode;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.ir.IfElseNode;
import org.elasticsearch.painless.ir.IfNode;
import org.elasticsearch.painless.ir.InstanceofNode;
import org.elasticsearch.painless.ir.InvokeCallDefNode;
import org.elasticsearch.painless.ir.InvokeCallMemberNode;
import org.elasticsearch.painless.ir.InvokeCallNode;
import org.elasticsearch.painless.ir.ListInitializationNode;
import org.elasticsearch.painless.ir.LoadBraceDefNode;
import org.elasticsearch.painless.ir.LoadBraceNode;
import org.elasticsearch.painless.ir.LoadDotArrayLengthNode;
import org.elasticsearch.painless.ir.LoadDotDefNode;
import org.elasticsearch.painless.ir.LoadDotNode;
import org.elasticsearch.painless.ir.LoadDotShortcutNode;
import org.elasticsearch.painless.ir.LoadFieldMemberNode;
import org.elasticsearch.painless.ir.LoadListShortcutNode;
import org.elasticsearch.painless.ir.LoadMapShortcutNode;
import org.elasticsearch.painless.ir.LoadVariableNode;
import org.elasticsearch.painless.ir.MapInitializationNode;
import org.elasticsearch.painless.ir.NewArrayNode;
import org.elasticsearch.painless.ir.NewObjectNode;
import org.elasticsearch.painless.ir.NullNode;
import org.elasticsearch.painless.ir.NullSafeSubNode;
import org.elasticsearch.painless.ir.ReturnNode;
import org.elasticsearch.painless.ir.StatementExpressionNode;
import org.elasticsearch.painless.ir.StatementNode;
import org.elasticsearch.painless.ir.StaticNode;
import org.elasticsearch.painless.ir.StoreBraceDefNode;
import org.elasticsearch.painless.ir.StoreBraceNode;
import org.elasticsearch.painless.ir.StoreDotDefNode;
import org.elasticsearch.painless.ir.StoreDotNode;
import org.elasticsearch.painless.ir.StoreDotShortcutNode;
import org.elasticsearch.painless.ir.StoreFieldMemberNode;
import org.elasticsearch.painless.ir.StoreListShortcutNode;
import org.elasticsearch.painless.ir.StoreMapShortcutNode;
import org.elasticsearch.painless.ir.StoreVariableNode;
import org.elasticsearch.painless.ir.StringConcatenationNode;
import org.elasticsearch.painless.ir.ThrowNode;
import org.elasticsearch.painless.ir.TryNode;
import org.elasticsearch.painless.ir.TypedCaptureReferenceNode;
import org.elasticsearch.painless.ir.TypedInterfaceReferenceNode;
import org.elasticsearch.painless.ir.UnaryMathNode;
import org.elasticsearch.painless.ir.WhileLoopNode;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.IRDecorations;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;

public class DefaultIRTreeToASMBytesPhase
implements IRTreeVisitor<WriteScope> {
    protected void visit(IRNode irNode, WriteScope writeScope) {
        irNode.visit(this, writeScope);
    }

    public void visitScript(ClassNode irClassNode) {
        WriteScope writeScope = WriteScope.newScriptScope();
        this.visitClass(irClassNode, writeScope);
    }

    @Override
    public void visitClass(ClassNode irClassNode, WriteScope writeScope) {
        ScriptScope scriptScope = irClassNode.getScriptScope();
        ScriptClassInfo scriptClassInfo = scriptScope.getScriptClassInfo();
        BitSet statements = new BitSet(scriptScope.getScriptSource().length());
        scriptScope.addStaticConstant("$STATEMENTS", statements);
        Printer debugStream = irClassNode.getDebugStream();
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = WriterConstants.BASE_INTERFACE_TYPE.getInternalName();
        String className = WriterConstants.CLASS_TYPE.getInternalName();
        String[] classInterfaces = new String[]{interfaceBase};
        ClassWriter classWriter = new ClassWriter(scriptScope.getCompilerSettings(), statements, debugStream, scriptClassInfo.getBaseClass(), classFrames, classAccess, className, classInterfaces);
        ClassVisitor classVisitor = classWriter.getClassVisitor();
        classVisitor.visitSource(Location.computeSourceName(scriptScope.getScriptName()), null);
        writeScope = writeScope.newClassScope(classWriter);
        Method init = scriptClassInfo.getBaseClass().getConstructors().length == 0 ? new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString()) : new Method("<init>", MethodType.methodType(Void.TYPE, scriptClassInfo.getBaseClass().getConstructors()[0].getParameterTypes()).toMethodDescriptorString());
        MethodWriter constructor = classWriter.newMethodWriter(1, init);
        constructor.visitCode();
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(Type.getType(scriptClassInfo.getBaseClass()), init);
        constructor.returnValue();
        constructor.endMethod();
        BlockNode irClinitBlockNode = irClassNode.getClinitBlockNode();
        if (!irClinitBlockNode.getStatementsNodes().isEmpty()) {
            MethodWriter methodWriter = classWriter.newMethodWriter(9, new Method("<clinit>", Type.getType(Void.TYPE), new Type[0]));
            this.visit(irClinitBlockNode, writeScope.newMethodScope(methodWriter).newBlockScope());
            methodWriter.returnValue();
            methodWriter.endMethod();
        }
        for (FieldNode irFieldNode : irClassNode.getFieldsNodes()) {
            this.visit(irFieldNode, writeScope);
        }
        for (FunctionNode irFunctionNode : irClassNode.getFunctionsNodes()) {
            this.visit(irFunctionNode, writeScope);
        }
        classVisitor.visitEnd();
        irClassNode.setBytes(classWriter.getClassBytes());
    }

    @Override
    public void visitFunction(FunctionNode irFunctionNode, WriteScope writeScope) {
        int access = 1;
        if (irFunctionNode.hasCondition(IRDecorations.IRCStatic.class)) {
            access |= 8;
        }
        if (irFunctionNode.hasCondition(IRDecorations.IRCVarArgs.class)) {
            access |= 0x80;
        }
        if (irFunctionNode.hasCondition(IRDecorations.IRCSynthetic.class)) {
            access |= 0x1000;
        }
        Type asmReturnType = MethodWriter.getType((Class)irFunctionNode.getDecorationValue(IRDecorations.IRDReturnType.class));
        List typeParameters = (List)irFunctionNode.getDecorationValue(IRDecorations.IRDTypeParameters.class);
        Type[] asmParameterTypes = new Type[typeParameters.size()];
        for (int index = 0; index < asmParameterTypes.length; ++index) {
            asmParameterTypes[index] = MethodWriter.getType((Class)typeParameters.get(index));
        }
        Method method = new Method((String)irFunctionNode.getDecorationValue(IRDecorations.IRDName.class), asmReturnType, asmParameterTypes);
        ClassWriter classWriter = writeScope.getClassWriter();
        MethodWriter methodWriter = classWriter.newMethodWriter(access, method);
        writeScope = writeScope.newMethodScope(methodWriter);
        if (!irFunctionNode.hasCondition(IRDecorations.IRCStatic.class)) {
            writeScope.defineInternalVariable(Object.class, "this");
        }
        List parameterNames = (List)irFunctionNode.getDecorationValue(IRDecorations.IRDParameterNames.class);
        for (int index = 0; index < typeParameters.size(); ++index) {
            writeScope.defineVariable((Class)typeParameters.get(index), (String)parameterNames.get(index));
        }
        methodWriter.visitCode();
        if ((Integer)irFunctionNode.getDecorationValue(IRDecorations.IRDMaxLoopCounter.class) > 0) {
            WriteScope.Variable loop = writeScope.defineInternalVariable(Integer.TYPE, "loop");
            methodWriter.push((Integer)irFunctionNode.getDecorationValue(IRDecorations.IRDMaxLoopCounter.class));
            methodWriter.visitVarInsn(54, loop.getSlot());
        }
        this.visit(irFunctionNode.getBlockNode(), writeScope.newBlockScope());
        methodWriter.endMethod();
    }

    @Override
    public void visitField(FieldNode irFieldNode, WriteScope writeScope) {
        int access = ClassWriter.buildAccess((Integer)irFieldNode.getDecorationValue(IRDecorations.IRDModifiers.class), true);
        String name = (String)irFieldNode.getDecorationValue(IRDecorations.IRDName.class);
        String descriptor = Type.getType((Class)irFieldNode.getDecorationValue(IRDecorations.IRDFieldType.class)).getDescriptor();
        ClassWriter classWriter = writeScope.getClassWriter();
        classWriter.getClassVisitor().visitField(access, name, descriptor, null, null).visitEnd();
    }

    @Override
    public void visitBlock(BlockNode irBlockNode, WriteScope writeScope) {
        for (StatementNode statementNode : irBlockNode.getStatementsNodes()) {
            this.visit(statementNode, writeScope);
        }
    }

    @Override
    public void visitIf(IfNode irIfNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irIfNode.getLocation());
        Label fals = new Label();
        this.visit(irIfNode.getConditionNode(), writeScope);
        methodWriter.ifZCmp(153, fals);
        this.visit(irIfNode.getBlockNode(), writeScope.newBlockScope());
        methodWriter.mark(fals);
    }

    @Override
    public void visitIfElse(IfElseNode irIfElseNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irIfElseNode.getLocation());
        Label fals = new Label();
        Label end = new Label();
        this.visit(irIfElseNode.getConditionNode(), writeScope);
        methodWriter.ifZCmp(153, fals);
        this.visit(irIfElseNode.getBlockNode(), writeScope.newBlockScope());
        if (!irIfElseNode.getBlockNode().hasCondition(IRDecorations.IRCAllEscape.class)) {
            methodWriter.goTo(end);
        }
        methodWriter.mark(fals);
        this.visit(irIfElseNode.getElseBlockNode(), writeScope.newBlockScope());
        methodWriter.mark(end);
    }

    @Override
    public void visitWhileLoop(WhileLoopNode irWhileLoopNode, WriteScope writeScope) {
        BlockNode irBlockNode;
        WriteScope.Variable loop;
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irWhileLoopNode.getLocation());
        writeScope = writeScope.newBlockScope();
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        if (!irWhileLoopNode.hasCondition(IRDecorations.IRCContinuous.class)) {
            this.visit(irWhileLoopNode.getConditionNode(), writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), irWhileLoopNode.getLocation());
        }
        if ((irBlockNode = irWhileLoopNode.getBlockNode()) != null) {
            this.visit(irBlockNode, writeScope.newLoopScope(begin, end));
        }
        if (irBlockNode == null || !irBlockNode.hasCondition(IRDecorations.IRCAllEscape.class)) {
            methodWriter.goTo(begin);
        }
        methodWriter.mark(end);
    }

    @Override
    public void visitDoWhileLoop(DoWhileLoopNode irDoWhileLoopNode, WriteScope writeScope) {
        WriteScope.Variable loop;
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irDoWhileLoopNode.getLocation());
        writeScope = writeScope.newBlockScope();
        Label start = new Label();
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(start);
        this.visit(irDoWhileLoopNode.getBlockNode(), writeScope.newLoopScope(begin, end));
        methodWriter.mark(begin);
        if (!irDoWhileLoopNode.hasCondition(IRDecorations.IRCContinuous.class)) {
            this.visit(irDoWhileLoopNode.getConditionNode(), writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), irDoWhileLoopNode.getLocation());
        }
        methodWriter.goTo(start);
        methodWriter.mark(end);
    }

    @Override
    public void visitForLoop(ForLoopNode irForLoopNode, WriteScope writeScope) {
        WriteScope.Variable loop;
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irForLoopNode.getLocation());
        IRNode irInitializerNode = irForLoopNode.getInitializerNode();
        ExpressionNode irConditionNode = irForLoopNode.getConditionNode();
        ExpressionNode irAfterthoughtNode = irForLoopNode.getAfterthoughtNode();
        BlockNode irBlockNode = irForLoopNode.getBlockNode();
        writeScope = writeScope.newBlockScope();
        Label start = new Label();
        Label begin = irAfterthoughtNode == null ? start : new Label();
        Label end = new Label();
        if (irInitializerNode instanceof DeclarationBlockNode) {
            this.visit(irInitializerNode, writeScope);
        } else if (irInitializerNode instanceof ExpressionNode) {
            ExpressionNode irExpressionNode = (ExpressionNode)irInitializerNode;
            this.visit(irExpressionNode, writeScope);
            methodWriter.writePop(MethodWriter.getType((Class)irExpressionNode.getDecorationValue(IRDecorations.IRDExpressionType.class)).getSize());
        }
        methodWriter.mark(start);
        if (irConditionNode != null && !irForLoopNode.hasCondition(IRDecorations.IRCContinuous.class)) {
            this.visit(irConditionNode, writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), irForLoopNode.getLocation());
        }
        boolean allEscape = false;
        if (irBlockNode != null) {
            allEscape = irBlockNode.hasCondition(IRDecorations.IRCAllEscape.class);
            this.visit(irBlockNode, writeScope.newLoopScope(begin, end));
        }
        if (irAfterthoughtNode != null) {
            methodWriter.mark(begin);
            this.visit(irAfterthoughtNode, writeScope);
            methodWriter.writePop(MethodWriter.getType((Class)irAfterthoughtNode.getDecorationValue(IRDecorations.IRDExpressionType.class)).getSize());
        }
        if (irAfterthoughtNode != null || !allEscape) {
            methodWriter.goTo(start);
        }
        methodWriter.mark(end);
    }

    @Override
    public void visitForEachLoop(ForEachLoopNode irForEachLoopNode, WriteScope writeScope) {
        this.visit(irForEachLoopNode.getConditionNode(), writeScope.newBlockScope());
    }

    @Override
    public void visitForEachSubArrayLoop(ForEachSubArrayNode irForEachSubArrayNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irForEachSubArrayNode.getLocation());
        WriteScope.Variable variable = writeScope.defineVariable((Class)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDVariableType.class), (String)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDVariableName.class));
        WriteScope.Variable array = writeScope.defineInternalVariable((Class)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDArrayType.class), (String)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDArrayName.class));
        WriteScope.Variable index = writeScope.defineInternalVariable((Class)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDIndexType.class), (String)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDIndexName.class));
        this.visit(irForEachSubArrayNode.getConditionNode(), writeScope);
        methodWriter.visitVarInsn(array.getAsmType().getOpcode(54), array.getSlot());
        methodWriter.push(-1);
        methodWriter.visitVarInsn(index.getAsmType().getOpcode(54), index.getSlot());
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        methodWriter.visitIincInsn(index.getSlot(), 1);
        methodWriter.visitVarInsn(index.getAsmType().getOpcode(21), index.getSlot());
        methodWriter.visitVarInsn(array.getAsmType().getOpcode(21), array.getSlot());
        methodWriter.arrayLength();
        methodWriter.ifICmp(156, end);
        methodWriter.visitVarInsn(array.getAsmType().getOpcode(21), array.getSlot());
        methodWriter.visitVarInsn(index.getAsmType().getOpcode(21), index.getSlot());
        methodWriter.arrayLoad(MethodWriter.getType((Class)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDIndexedType.class)));
        methodWriter.writeCast((PainlessCast)irForEachSubArrayNode.getDecorationValue(IRDecorations.IRDCast.class));
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
        this.visit(irForEachSubArrayNode.getBlockNode(), writeScope.newLoopScope(begin, end));
        methodWriter.goTo(begin);
        methodWriter.mark(end);
    }

    @Override
    public void visitForEachSubIterableLoop(ForEachSubIterableNode irForEachSubIterableNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irForEachSubIterableNode.getLocation());
        PainlessMethod painlessMethod = (PainlessMethod)irForEachSubIterableNode.getDecorationValue(IRDecorations.IRDMethod.class);
        WriteScope.Variable variable = writeScope.defineVariable((Class)irForEachSubIterableNode.getDecorationValue(IRDecorations.IRDVariableType.class), (String)irForEachSubIterableNode.getDecorationValue(IRDecorations.IRDVariableName.class));
        WriteScope.Variable iterator = writeScope.defineInternalVariable((Class)irForEachSubIterableNode.getDecorationValue(IRDecorations.IRDIterableType.class), (String)irForEachSubIterableNode.getDecorationValue(IRDecorations.IRDIterableName.class));
        this.visit(irForEachSubIterableNode.getConditionNode(), writeScope);
        if (painlessMethod == null) {
            Type methodType = Type.getMethodType(Type.getType(ValueIterator.class), Type.getType(Object.class));
            methodWriter.invokeDefCall("iterator", methodType, 5, new Object[0]);
        } else {
            methodWriter.invokeMethodCall(painlessMethod);
        }
        methodWriter.visitVarInsn(iterator.getAsmType().getOpcode(54), iterator.getSlot());
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        methodWriter.visitVarInsn(iterator.getAsmType().getOpcode(21), iterator.getSlot());
        methodWriter.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_HASNEXT);
        methodWriter.ifZCmp(153, end);
        methodWriter.visitVarInsn(iterator.getAsmType().getOpcode(21), iterator.getSlot());
        if (painlessMethod != null || !variable.getType().isPrimitive()) {
            methodWriter.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_NEXT);
            methodWriter.writeCast((PainlessCast)irForEachSubIterableNode.getDecorationValue(IRDecorations.IRDCast.class));
        } else {
            switch (variable.getAsmType().getSort()) {
                case 1: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_BOOLEAN);
                    break;
                }
                case 3: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_BYTE);
                    break;
                }
                case 4: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_SHORT);
                    break;
                }
                case 2: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_CHAR);
                    break;
                }
                case 5: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_INT);
                    break;
                }
                case 7: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_LONG);
                    break;
                }
                case 6: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_FLOAT);
                    break;
                }
                case 8: {
                    methodWriter.invokeInterface(WriterConstants.VALUE_ITERATOR_TYPE, WriterConstants.VALUE_ITERATOR_NEXT_DOUBLE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive iteration variable type " + variable.getAsmType());
                }
            }
        }
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
        this.visit(irForEachSubIterableNode.getBlockNode(), writeScope.newLoopScope(begin, end));
        methodWriter.goTo(begin);
        methodWriter.mark(end);
    }

    @Override
    public void visitDeclarationBlock(DeclarationBlockNode irDeclarationBlockNode, WriteScope writeScope) {
        for (DeclarationNode declarationNode : irDeclarationBlockNode.getDeclarationsNodes()) {
            this.visit(declarationNode, writeScope);
        }
    }

    @Override
    public void visitDeclaration(DeclarationNode irDeclarationNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irDeclarationNode.getLocation());
        Class variableType = (Class)irDeclarationNode.getDecorationValue(IRDecorations.IRDDeclarationType.class);
        String variableName = (String)irDeclarationNode.getDecorationValue(IRDecorations.IRDName.class);
        WriteScope.Variable variable = writeScope.defineVariable(variableType, variableName);
        if (irDeclarationNode.getExpressionNode() == null) {
            Class<?> sort = variable.getType();
            if (sort == Void.TYPE || sort == Boolean.TYPE || sort == Byte.TYPE || sort == Short.TYPE || sort == Character.TYPE || sort == Integer.TYPE) {
                methodWriter.push(0);
            } else if (sort == Long.TYPE) {
                methodWriter.push(0L);
            } else if (sort == Float.TYPE) {
                methodWriter.push(0.0f);
            } else if (sort == Double.TYPE) {
                methodWriter.push(0.0);
            } else {
                methodWriter.visitInsn(1);
            }
        } else {
            this.visit(irDeclarationNode.getExpressionNode(), writeScope);
        }
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
    }

    @Override
    public void visitReturn(ReturnNode irReturnNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irReturnNode.getLocation());
        if (irReturnNode.getExpressionNode() != null) {
            this.visit(irReturnNode.getExpressionNode(), writeScope);
        }
        methodWriter.returnValue();
    }

    @Override
    public void visitStatementExpression(StatementExpressionNode irStatementExpressionNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irStatementExpressionNode.getLocation());
        this.visit(irStatementExpressionNode.getExpressionNode(), writeScope);
        Class expressionType = (Class)irStatementExpressionNode.getExpressionNode().getDecorationValue(IRDecorations.IRDExpressionType.class);
        Type asmExpressionType = MethodWriter.getType(expressionType);
        methodWriter.writePop(asmExpressionType.getSize());
    }

    @Override
    public void visitTry(TryNode irTryNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irTryNode.getLocation());
        Label tryBeginLabel = new Label();
        Label tryEndLabel = new Label();
        Label catchesEndLabel = new Label();
        methodWriter.mark(tryBeginLabel);
        this.visit(irTryNode.getBlockNode(), writeScope.newBlockScope());
        if (!irTryNode.getBlockNode().hasCondition(IRDecorations.IRCAllEscape.class)) {
            methodWriter.goTo(catchesEndLabel);
        }
        methodWriter.mark(tryEndLabel);
        List<CatchNode> catchNodes = irTryNode.getCatchNodes();
        for (int i = 0; i < catchNodes.size(); ++i) {
            CatchNode irCatchNode = catchNodes.get(i);
            boolean innerCatch = catchNodes.size() > 1 && i < catchNodes.size() - 1;
            Label catchJumpLabel = innerCatch ? catchesEndLabel : null;
            this.visit(irCatchNode, writeScope.newTryScope(tryBeginLabel, tryEndLabel, catchJumpLabel));
        }
        if (!irTryNode.getBlockNode().hasCondition(IRDecorations.IRCAllEscape.class) || catchNodes.size() > 1) {
            methodWriter.mark(catchesEndLabel);
        }
    }

    @Override
    public void visitCatch(CatchNode irCatchNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irCatchNode.getLocation());
        Class exceptionType = (Class)irCatchNode.getDecorationValue(IRDecorations.IRDExceptionType.class);
        String exceptionName = (String)irCatchNode.getDecorationValue(IRDecorations.IRDSymbol.class);
        WriteScope.Variable variable = writeScope.defineVariable(exceptionType, exceptionName);
        Label jump = new Label();
        methodWriter.mark(jump);
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
        BlockNode irBlockNode = irCatchNode.getBlockNode();
        if (irBlockNode != null) {
            this.visit(irBlockNode, writeScope.newBlockScope(true));
        }
        methodWriter.visitTryCatchBlock(writeScope.getTryBeginLabel(), writeScope.getTryEndLabel(), jump, variable.getAsmType().getInternalName());
        if (!(writeScope.getCatchesEndLabel() == null || irBlockNode != null && irBlockNode.hasCondition(IRDecorations.IRCAllEscape.class))) {
            methodWriter.goTo(writeScope.getCatchesEndLabel());
        }
    }

    @Override
    public void visitThrow(ThrowNode irThrowNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeStatementOffset(irThrowNode.getLocation());
        this.visit(irThrowNode.getExpressionNode(), writeScope);
        methodWriter.throwException();
    }

    @Override
    public void visitContinue(ContinueNode irContinueNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.goTo(writeScope.getContinueLabel());
    }

    @Override
    public void visitBreak(BreakNode irBreakNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.goTo(writeScope.getBreakLabel());
    }

    @Override
    public void visitBinaryImpl(BinaryImplNode irBinaryImplNode, WriteScope writeScope) {
        this.visit(irBinaryImplNode.getLeftNode(), writeScope);
        this.visit(irBinaryImplNode.getRightNode(), writeScope);
    }

    @Override
    public void visitUnaryMath(UnaryMathNode irUnaryMathNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irUnaryMathNode.getLocation());
        Operation operation = (Operation)((Object)irUnaryMathNode.getDecorationValue(IRDecorations.IRDOperation.class));
        if (operation == Operation.NOT) {
            Label fals = new Label();
            Label end = new Label();
            this.visit(irUnaryMathNode.getChildNode(), writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.push(false);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(true);
            methodWriter.mark(end);
        } else {
            this.visit(irUnaryMathNode.getChildNode(), writeScope);
            Type actualType = MethodWriter.getType((Class)irUnaryMathNode.getDecorationValue(IRDecorations.IRDExpressionType.class));
            Type childType = MethodWriter.getType((Class)irUnaryMathNode.getChildNode().getDecorationValue(IRDecorations.IRDExpressionType.class));
            Class unaryType = (Class)irUnaryMathNode.getDecorationValue(IRDecorations.IRDUnaryType.class);
            int flags = irUnaryMathNode.getDecorationValueOrDefault(IRDecorations.IRDFlags.class, 0);
            if (operation == Operation.BWNOT) {
                if (unaryType == def.class) {
                    Type descriptor = Type.getMethodType(actualType, childType);
                    methodWriter.invokeDefCall("not", descriptor, 7, flags);
                } else {
                    if (unaryType == Integer.TYPE) {
                        methodWriter.push(-1);
                    } else if (unaryType == Long.TYPE) {
                        methodWriter.push(-1L);
                    } else {
                        throw new IllegalStateException(Strings.format("unexpected unary math operation [%s] for type [%s]", new Object[]{operation, irUnaryMathNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
                    }
                    methodWriter.math(130, actualType);
                }
            } else if (operation == Operation.SUB) {
                if (unaryType == def.class) {
                    Type descriptor = Type.getMethodType(actualType, childType);
                    methodWriter.invokeDefCall("neg", descriptor, 7, flags);
                } else {
                    methodWriter.math(116, actualType);
                }
            } else if (operation == Operation.ADD) {
                if (unaryType == def.class) {
                    Type descriptor = Type.getMethodType(actualType, childType);
                    methodWriter.invokeDefCall("plus", descriptor, 7, flags);
                }
            } else {
                throw new IllegalStateException(Strings.format("unexpected unary math operation [%s] for type [%s]", new Object[]{operation, irUnaryMathNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitBinaryMath(BinaryMathNode irBinaryMathNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irBinaryMathNode.getLocation());
        Operation operation = (Operation)((Object)irBinaryMathNode.getDecorationValue(IRDecorations.IRDOperation.class));
        ExpressionNode irLeftNode = irBinaryMathNode.getLeftNode();
        ExpressionNode irRightNode = irBinaryMathNode.getRightNode();
        if (operation == Operation.FIND || operation == Operation.MATCH) {
            this.visit(irRightNode, writeScope);
            methodWriter.push((Integer)irBinaryMathNode.getDecorationValue(IRDecorations.IRDRegexLimit.class));
            this.visit(irLeftNode, writeScope);
            methodWriter.invokeStatic(Type.getType(Augmentation.class), WriterConstants.PATTERN_MATCHER);
            if (operation == Operation.FIND) {
                methodWriter.invokeVirtual(Type.getType(Matcher.class), WriterConstants.MATCHER_FIND);
                return;
            } else {
                if (operation != Operation.MATCH) throw new IllegalStateException(Strings.format("unexpected binary math operation [%s] for type [%s]", new Object[]{operation, irBinaryMathNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
                methodWriter.invokeVirtual(Type.getType(Matcher.class), WriterConstants.MATCHER_MATCHES);
            }
            return;
        } else {
            this.visit(irLeftNode, writeScope);
            this.visit(irRightNode, writeScope);
            Class expressionType = (Class)irBinaryMathNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            if (irBinaryMathNode.getDecorationValue(IRDecorations.IRDBinaryType.class) == def.class || irBinaryMathNode.getDecoration(IRDecorations.IRDShiftType.class) != null && irBinaryMathNode.getDecorationValue(IRDecorations.IRDShiftType.class) == def.class) {
                methodWriter.writeDynamicBinaryInstruction(irBinaryMathNode.getLocation(), expressionType, (Class)irLeftNode.getDecorationValue(IRDecorations.IRDExpressionType.class), (Class)irRightNode.getDecorationValue(IRDecorations.IRDExpressionType.class), operation, irBinaryMathNode.getDecorationValueOrDefault(IRDecorations.IRDFlags.class, 0));
                return;
            } else {
                methodWriter.writeBinaryInstruction(irBinaryMathNode.getLocation(), expressionType, operation);
            }
        }
    }

    @Override
    public void visitStringConcatenation(StringConcatenationNode irStringConcatenationNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irStringConcatenationNode.getLocation());
        methodWriter.writeNewStrings();
        for (ExpressionNode argumentNode : irStringConcatenationNode.getArgumentNodes()) {
            this.visit(argumentNode, writeScope);
            methodWriter.writeAppendStrings((Class)argumentNode.getDecorationValue(IRDecorations.IRDExpressionType.class));
        }
        methodWriter.writeToStrings();
    }

    @Override
    public void visitBoolean(BooleanNode irBooleanNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irBooleanNode.getLocation());
        Operation operation = (Operation)((Object)irBooleanNode.getDecorationValue(IRDecorations.IRDOperation.class));
        ExpressionNode irLeftNode = irBooleanNode.getLeftNode();
        ExpressionNode irRightNode = irBooleanNode.getRightNode();
        if (operation == Operation.AND) {
            Label fals = new Label();
            Label end = new Label();
            this.visit(irLeftNode, writeScope);
            methodWriter.ifZCmp(153, fals);
            this.visit(irRightNode, writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else if (operation == Operation.OR) {
            Label tru = new Label();
            Label fals = new Label();
            Label end = new Label();
            this.visit(irLeftNode, writeScope);
            methodWriter.ifZCmp(154, tru);
            this.visit(irRightNode, writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.mark(tru);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else {
            throw new IllegalStateException("unexpected boolean operation [" + operation + "] for type [" + irBooleanNode.getDecorationString(IRDecorations.IRDExpressionType.class) + "]");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void visitComparison(ComparisonNode irComparisonNode, WriteScope writeScope) {
        boolean writejump;
        Label end;
        Label jump;
        MethodWriter methodWriter;
        block31: {
            Type type;
            boolean ne;
            boolean eq;
            ExpressionNode irRightNode;
            Operation operation;
            block37: {
                Type descriptor;
                boolean gte;
                boolean gt;
                boolean lte;
                boolean lt;
                block39: {
                    ExpressionNode irLeftNode;
                    block38: {
                        Class comparisonType;
                        block33: {
                            block36: {
                                block35: {
                                    block34: {
                                        block32: {
                                            methodWriter = writeScope.getMethodWriter();
                                            methodWriter.writeDebugInfo(irComparisonNode.getLocation());
                                            operation = (Operation)((Object)irComparisonNode.getDecorationValue(IRDecorations.IRDOperation.class));
                                            irLeftNode = irComparisonNode.getLeftNode();
                                            irRightNode = irComparisonNode.getRightNode();
                                            this.visit(irLeftNode, writeScope);
                                            if (!(irRightNode instanceof NullNode)) {
                                                this.visit(irRightNode, writeScope);
                                            }
                                            jump = new Label();
                                            end = new Label();
                                            eq = operation == Operation.EQ || operation == Operation.EQR;
                                            ne = operation == Operation.NE || operation == Operation.NER;
                                            lt = operation == Operation.LT;
                                            lte = operation == Operation.LTE;
                                            gt = operation == Operation.GT;
                                            gte = operation == Operation.GTE;
                                            writejump = true;
                                            comparisonType = (Class)irComparisonNode.getDecorationValue(IRDecorations.IRDComparisonType.class);
                                            type = MethodWriter.getType(comparisonType);
                                            if (comparisonType == Void.TYPE || comparisonType == Byte.TYPE || comparisonType == Short.TYPE || comparisonType == Character.TYPE) {
                                                throw new IllegalStateException(Strings.format("unexpected comparison operation [%s] for type [%s]", new Object[]{operation, irComparisonNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
                                            }
                                            if (comparisonType != Boolean.TYPE) break block32;
                                            if (eq) {
                                                methodWriter.ifCmp(type, 153, jump);
                                                break block31;
                                            } else {
                                                if (!ne) {
                                                    throw new IllegalStateException(Strings.format("unexpected comparison operation [%s] for type [%s]", new Object[]{operation, irComparisonNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
                                                }
                                                methodWriter.ifCmp(type, 154, jump);
                                            }
                                            break block31;
                                        }
                                        if (comparisonType != Integer.TYPE && comparisonType != Long.TYPE && comparisonType != Float.TYPE && comparisonType != Double.TYPE) break block33;
                                        if (!eq) break block34;
                                        methodWriter.ifCmp(type, 153, jump);
                                        break block31;
                                    }
                                    if (!ne) break block35;
                                    methodWriter.ifCmp(type, 154, jump);
                                    break block31;
                                }
                                if (!lt) break block36;
                                methodWriter.ifCmp(type, 155, jump);
                                break block31;
                            }
                            if (lte) {
                                methodWriter.ifCmp(type, 158, jump);
                                break block31;
                            } else if (gt) {
                                methodWriter.ifCmp(type, 157, jump);
                                break block31;
                            } else {
                                if (!gte) {
                                    throw new IllegalStateException(Strings.format("unexpected comparison operation [%s] for type [%s]", new Object[]{operation, irComparisonNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
                                }
                                methodWriter.ifCmp(type, 156, jump);
                            }
                            break block31;
                        }
                        if (comparisonType != def.class) break block37;
                        Type booleanType = Type.getType(Boolean.TYPE);
                        descriptor = Type.getMethodType(booleanType, MethodWriter.getType((Class)irLeftNode.getDecorationValue(IRDecorations.IRDExpressionType.class)), MethodWriter.getType((Class)irRightNode.getDecorationValue(IRDecorations.IRDExpressionType.class)));
                        if (!eq) break block38;
                        if (irRightNode instanceof NullNode) {
                            methodWriter.ifNull(jump);
                            break block31;
                        } else {
                            if (!(irLeftNode instanceof NullNode) && operation == Operation.EQ) {
                                methodWriter.invokeDefCall("eq", descriptor, 8, 1);
                                return;
                            }
                            methodWriter.ifCmp(type, 153, jump);
                        }
                        break block31;
                    }
                    if (!ne) break block39;
                    if (irRightNode instanceof NullNode) {
                        methodWriter.ifNonNull(jump);
                        break block31;
                    } else if (!(irLeftNode instanceof NullNode) && operation == Operation.NE) {
                        methodWriter.invokeDefCall("eq", descriptor, 8, 1);
                        methodWriter.ifZCmp(153, jump);
                        break block31;
                    } else {
                        methodWriter.ifCmp(type, 154, jump);
                    }
                    break block31;
                }
                if (lt) {
                    methodWriter.invokeDefCall("lt", descriptor, 8, 0);
                    return;
                }
                if (lte) {
                    methodWriter.invokeDefCall("lte", descriptor, 8, 0);
                    return;
                }
                if (gt) {
                    methodWriter.invokeDefCall("gt", descriptor, 8, 0);
                    return;
                }
                if (!gte) {
                    throw new IllegalStateException(Strings.format("unexpected comparison operation [%s] for type [%s]", new Object[]{operation, irComparisonNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
                }
                methodWriter.invokeDefCall("gte", descriptor, 8, 0);
                return;
            }
            if (eq) {
                if (irRightNode instanceof NullNode) {
                    methodWriter.ifNull(jump);
                } else {
                    if (operation == Operation.EQ) {
                        methodWriter.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                        return;
                    }
                    methodWriter.ifCmp(type, 153, jump);
                }
            } else {
                if (!ne) {
                    throw new IllegalStateException(Strings.format("unexpected comparison operation [%s] for type [%s]", new Object[]{operation, irComparisonNode.getDecorationString(IRDecorations.IRDExpressionType.class)}));
                }
                if (irRightNode instanceof NullNode) {
                    methodWriter.ifNonNull(jump);
                } else if (operation == Operation.NE) {
                    methodWriter.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                    methodWriter.ifZCmp(153, jump);
                } else {
                    methodWriter.ifCmp(type, 154, jump);
                }
            }
        }
        if (!writejump) return;
        methodWriter.push(false);
        methodWriter.goTo(end);
        methodWriter.mark(jump);
        methodWriter.push(true);
        methodWriter.mark(end);
    }

    @Override
    public void visitCast(CastNode irCastNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irCastNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irCastNode.getLocation());
        methodWriter.writeCast((PainlessCast)irCastNode.getDecorationValue(IRDecorations.IRDCast.class));
    }

    @Override
    public void visitInstanceof(InstanceofNode irInstanceofNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        ExpressionNode irChildNode = irInstanceofNode.getChildNode();
        this.visit(irChildNode, writeScope);
        Class instanceType = (Class)irInstanceofNode.getDecorationValue(IRDecorations.IRDInstanceType.class);
        Class expressionType = (Class)irInstanceofNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
        if (instanceType == def.class) {
            methodWriter.writePop(MethodWriter.getType(expressionType).getSize());
            methodWriter.push(true);
        } else if (((Class)irChildNode.getDecorationValue(IRDecorations.IRDExpressionType.class)).isPrimitive()) {
            Class<?> boxedInstanceType = PainlessLookupUtility.typeToBoxedType(instanceType);
            Class childExpressionType = (Class)irChildNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
            Class<?> boxedExpressionType = PainlessLookupUtility.typeToBoxedType(childExpressionType);
            methodWriter.writePop(MethodWriter.getType(expressionType).getSize());
            methodWriter.push(boxedInstanceType.isAssignableFrom(boxedExpressionType));
        } else {
            methodWriter.instanceOf(MethodWriter.getType(PainlessLookupUtility.typeToBoxedType(instanceType)));
        }
    }

    @Override
    public void visitConditional(ConditionalNode irConditionalNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irConditionalNode.getLocation());
        Label fals = new Label();
        Label end = new Label();
        this.visit(irConditionalNode.getConditionNode(), writeScope);
        methodWriter.ifZCmp(153, fals);
        this.visit(irConditionalNode.getLeftNode(), writeScope);
        methodWriter.goTo(end);
        methodWriter.mark(fals);
        this.visit(irConditionalNode.getRightNode(), writeScope);
        methodWriter.mark(end);
    }

    @Override
    public void visitElvis(ElvisNode irElvisNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irElvisNode.getLocation());
        Label end = new Label();
        this.visit(irElvisNode.getLeftNode(), writeScope);
        methodWriter.dup();
        methodWriter.ifNonNull(end);
        methodWriter.pop();
        this.visit(irElvisNode.getRightNode(), writeScope);
        methodWriter.mark(end);
    }

    @Override
    public void visitListInitialization(ListInitializationNode irListInitializationNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irListInitializationNode.getLocation());
        PainlessConstructor painlessConstructor = (PainlessConstructor)irListInitializationNode.getDecorationValue(IRDecorations.IRDConstructor.class);
        methodWriter.newInstance(MethodWriter.getType((Class)irListInitializationNode.getDecorationValue(IRDecorations.IRDExpressionType.class)));
        methodWriter.dup();
        methodWriter.invokeConstructor(Type.getType(painlessConstructor.javaConstructor().getDeclaringClass()), Method.getMethod(painlessConstructor.javaConstructor()));
        for (ExpressionNode irArgumentNode : irListInitializationNode.getArgumentNodes()) {
            methodWriter.dup();
            this.visit(irArgumentNode, writeScope);
            methodWriter.invokeMethodCall((PainlessMethod)irListInitializationNode.getDecorationValue(IRDecorations.IRDMethod.class));
            methodWriter.pop();
        }
    }

    @Override
    public void visitMapInitialization(MapInitializationNode irMapInitializationNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irMapInitializationNode.getLocation());
        PainlessConstructor painlessConstructor = (PainlessConstructor)irMapInitializationNode.getDecorationValue(IRDecorations.IRDConstructor.class);
        methodWriter.newInstance(MethodWriter.getType((Class)irMapInitializationNode.getDecorationValue(IRDecorations.IRDExpressionType.class)));
        methodWriter.dup();
        methodWriter.invokeConstructor(Type.getType(painlessConstructor.javaConstructor().getDeclaringClass()), Method.getMethod(painlessConstructor.javaConstructor()));
        for (int index = 0; index < irMapInitializationNode.getArgumentsSize(); ++index) {
            methodWriter.dup();
            this.visit(irMapInitializationNode.getKeyNode(index), writeScope);
            this.visit(irMapInitializationNode.getValueNode(index), writeScope);
            methodWriter.invokeMethodCall((PainlessMethod)irMapInitializationNode.getDecorationValue(IRDecorations.IRDMethod.class));
            methodWriter.pop();
        }
    }

    @Override
    public void visitNewArray(NewArrayNode irNewArrayNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irNewArrayNode.getLocation());
        List<ExpressionNode> irArgumentNodes = irNewArrayNode.getArgumentNodes();
        Class expressionType = (Class)irNewArrayNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
        if (irNewArrayNode.hasCondition(IRDecorations.IRCInitialize.class)) {
            methodWriter.push(irNewArrayNode.getArgumentNodes().size());
            methodWriter.newArray(MethodWriter.getType(expressionType.getComponentType()));
            for (int index = 0; index < irArgumentNodes.size(); ++index) {
                ExpressionNode irArgumentNode = irArgumentNodes.get(index);
                methodWriter.dup();
                methodWriter.push(index);
                this.visit(irArgumentNode, writeScope);
                methodWriter.arrayStore(MethodWriter.getType(expressionType.getComponentType()));
            }
        } else {
            for (ExpressionNode irArgumentNode : irArgumentNodes) {
                this.visit(irArgumentNode, writeScope);
            }
            if (irArgumentNodes.size() > 1) {
                methodWriter.visitMultiANewArrayInsn(MethodWriter.getType(expressionType).getDescriptor(), irArgumentNodes.size());
            } else {
                methodWriter.newArray(MethodWriter.getType(expressionType.getComponentType()));
            }
        }
    }

    @Override
    public void visitNewObject(NewObjectNode irNewObjectNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irNewObjectNode.getLocation());
        methodWriter.newInstance(MethodWriter.getType((Class)irNewObjectNode.getDecorationValue(IRDecorations.IRDExpressionType.class)));
        methodWriter.dup();
        for (ExpressionNode irArgumentNode : irNewObjectNode.getArgumentNodes()) {
            this.visit(irArgumentNode, writeScope);
        }
        PainlessConstructor painlessConstructor = (PainlessConstructor)irNewObjectNode.getDecorationValue(IRDecorations.IRDConstructor.class);
        methodWriter.invokeConstructor(Type.getType(painlessConstructor.javaConstructor().getDeclaringClass()), Method.getMethod(painlessConstructor.javaConstructor()));
    }

    @Override
    public void visitConstant(ConstantNode irConstantNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        Object constant = irConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
        if (constant instanceof String) {
            methodWriter.push((String)constant);
        } else if (constant instanceof Double) {
            methodWriter.push((Double)constant);
        } else if (constant instanceof Float) {
            methodWriter.push(((Float)constant).floatValue());
        } else if (constant instanceof Long) {
            methodWriter.push((Long)constant);
        } else if (constant instanceof Integer) {
            methodWriter.push((Integer)constant);
        } else if (constant instanceof Character) {
            methodWriter.push(((Character)constant).charValue());
        } else if (constant instanceof Short) {
            methodWriter.push(((Short)constant).shortValue());
        } else if (constant instanceof Byte) {
            methodWriter.push(((Byte)constant).byteValue());
        } else if (constant instanceof Boolean) {
            methodWriter.push((Boolean)constant);
        } else {
            String fieldName = (String)irConstantNode.getDecorationValue(IRDecorations.IRDConstantFieldName.class);
            Type asmFieldType = MethodWriter.getType((Class)irConstantNode.getDecorationValue(IRDecorations.IRDExpressionType.class));
            if (asmFieldType == null) {
                throw irConstantNode.getLocation().createError(new IllegalStateException("Didn't attach constant to [" + irConstantNode + "]"));
            }
            methodWriter.getStatic(WriterConstants.CLASS_TYPE, fieldName, asmFieldType);
        }
    }

    @Override
    public void visitNull(NullNode irNullNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.visitInsn(1);
    }

    @Override
    public void visitDefInterfaceReference(DefInterfaceReferenceNode irDefInterfaceReferenceNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irDefInterfaceReferenceNode.getLocation());
        methodWriter.push((String)null);
        if (irDefInterfaceReferenceNode.hasCondition(IRDecorations.IRCInstanceCapture.class)) {
            WriteScope.Variable capturedThis = writeScope.getInternalVariable("this");
            methodWriter.visitVarInsn(WriterConstants.CLASS_TYPE.getOpcode(21), capturedThis.getSlot());
        }
        List captureNames = (List)irDefInterfaceReferenceNode.getDecorationValue(IRDecorations.IRDCaptureNames.class);
        boolean captureBox = irDefInterfaceReferenceNode.hasCondition(IRDecorations.IRCCaptureBox.class);
        if (captureNames != null) {
            for (String captureName : captureNames) {
                WriteScope.Variable captureVariable = writeScope.getVariable(captureName);
                methodWriter.visitVarInsn(captureVariable.getAsmType().getOpcode(21), captureVariable.getSlot());
                if (!captureBox) continue;
                methodWriter.box(captureVariable.getAsmType());
                captureBox = false;
            }
        }
    }

    @Override
    public void visitTypedInterfaceReference(TypedInterfaceReferenceNode irTypedInterfaceReferenceNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irTypedInterfaceReferenceNode.getLocation());
        if (irTypedInterfaceReferenceNode.hasCondition(IRDecorations.IRCInstanceCapture.class)) {
            WriteScope.Variable capturedThis = writeScope.getInternalVariable("this");
            methodWriter.visitVarInsn(WriterConstants.CLASS_TYPE.getOpcode(21), capturedThis.getSlot());
        }
        List captureNames = (List)irTypedInterfaceReferenceNode.getDecorationValue(IRDecorations.IRDCaptureNames.class);
        boolean captureBox = irTypedInterfaceReferenceNode.hasCondition(IRDecorations.IRCCaptureBox.class);
        if (captureNames != null) {
            for (String captureName : captureNames) {
                WriteScope.Variable captureVariable = writeScope.getVariable(captureName);
                methodWriter.visitVarInsn(captureVariable.getAsmType().getOpcode(21), captureVariable.getSlot());
                if (!captureBox) continue;
                methodWriter.box(captureVariable.getAsmType());
                captureBox = false;
            }
        }
        methodWriter.invokeLambdaCall((FunctionRef)irTypedInterfaceReferenceNode.getDecorationValue(IRDecorations.IRDReference.class));
    }

    @Override
    public void visitTypedCaptureReference(TypedCaptureReferenceNode irTypedCaptureReferenceNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irTypedCaptureReferenceNode.getLocation());
        String methodName = (String)irTypedCaptureReferenceNode.getDecorationValue(IRDecorations.IRDName.class);
        WriteScope.Variable captured = writeScope.getVariable((String)((List)irTypedCaptureReferenceNode.getDecorationValue(IRDecorations.IRDCaptureNames.class)).get(0));
        Class expressionType = (Class)irTypedCaptureReferenceNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
        String expressionCanonicalTypeName = irTypedCaptureReferenceNode.getDecorationString(IRDecorations.IRDExpressionType.class);
        methodWriter.visitVarInsn(captured.getAsmType().getOpcode(21), captured.getSlot());
        if (irTypedCaptureReferenceNode.hasCondition(IRDecorations.IRCCaptureBox.class)) {
            methodWriter.box(captured.getAsmType());
        }
        Type methodType = Type.getMethodType(MethodWriter.getType(expressionType), captured.getAsmType());
        methodWriter.invokeDefCall(methodName, methodType, 6, expressionCanonicalTypeName);
    }

    @Override
    public void visitStatic(StaticNode irStaticNode, WriteScope writeScope) {
    }

    @Override
    public void visitLoadVariable(LoadVariableNode irLoadVariableNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        WriteScope.Variable variable = writeScope.getVariable((String)irLoadVariableNode.getDecorationValue(IRDecorations.IRDName.class));
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(21), variable.getSlot());
    }

    @Override
    public void visitNullSafeSub(NullSafeSubNode irNullSafeSubNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irNullSafeSubNode.getLocation());
        Label end = new Label();
        methodWriter.dup();
        methodWriter.ifNull(end);
        this.visit(irNullSafeSubNode.getChildNode(), writeScope);
        methodWriter.mark(end);
    }

    @Override
    public void visitLoadDotArrayLengthNode(LoadDotArrayLengthNode irLoadDotArrayLengthNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadDotArrayLengthNode.getLocation());
        methodWriter.arrayLength();
    }

    @Override
    public void visitLoadDotDef(LoadDotDefNode irLoadDotDefNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadDotDefNode.getLocation());
        Type methodType = Type.getMethodType(MethodWriter.getType((Class)irLoadDotDefNode.getDecorationValue(IRDecorations.IRDExpressionType.class)), MethodWriter.getType(def.class));
        methodWriter.invokeDefCall((String)irLoadDotDefNode.getDecorationValue(IRDecorations.IRDValue.class), methodType, 1, new Object[0]);
    }

    @Override
    public void visitLoadDot(LoadDotNode irLoadDotNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadDotNode.getLocation());
        PainlessField painlessField = (PainlessField)irLoadDotNode.getDecorationValue(IRDecorations.IRDField.class);
        boolean isStatic = Modifier.isStatic(painlessField.javaField().getModifiers());
        Type asmOwnerType = Type.getType(painlessField.javaField().getDeclaringClass());
        String fieldName = painlessField.javaField().getName();
        Type asmFieldType = MethodWriter.getType(painlessField.typeParameter());
        if (isStatic) {
            methodWriter.getStatic(asmOwnerType, fieldName, asmFieldType);
        } else {
            methodWriter.getField(asmOwnerType, fieldName, asmFieldType);
        }
    }

    @Override
    public void visitLoadDotShortcut(LoadDotShortcutNode irDotSubShortcutNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irDotSubShortcutNode.getLocation());
        PainlessMethod getterPainlessMethod = (PainlessMethod)irDotSubShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class);
        methodWriter.invokeMethodCall(getterPainlessMethod);
        if (!getterPainlessMethod.returnType().equals(getterPainlessMethod.javaMethod().getReturnType())) {
            methodWriter.checkCast(MethodWriter.getType(getterPainlessMethod.returnType()));
        }
    }

    @Override
    public void visitLoadListShortcut(LoadListShortcutNode irLoadListShortcutNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadListShortcutNode.getLocation());
        PainlessMethod getterPainlessMethod = (PainlessMethod)irLoadListShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class);
        methodWriter.invokeMethodCall(getterPainlessMethod);
        if (getterPainlessMethod.returnType() == getterPainlessMethod.javaMethod().getReturnType()) {
            methodWriter.checkCast(MethodWriter.getType(getterPainlessMethod.returnType()));
        }
    }

    @Override
    public void visitLoadMapShortcut(LoadMapShortcutNode irLoadMapShortcutNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadMapShortcutNode.getLocation());
        PainlessMethod getterPainlessMethod = (PainlessMethod)irLoadMapShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class);
        methodWriter.invokeMethodCall(getterPainlessMethod);
        if (getterPainlessMethod.returnType() != getterPainlessMethod.javaMethod().getReturnType()) {
            methodWriter.checkCast(MethodWriter.getType(getterPainlessMethod.returnType()));
        }
    }

    @Override
    public void visitLoadFieldMember(LoadFieldMemberNode irLoadFieldMemberNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadFieldMemberNode.getLocation());
        boolean isStatic = irLoadFieldMemberNode.hasCondition(IRDecorations.IRCStatic.class);
        String memberFieldName = (String)irLoadFieldMemberNode.getDecorationValue(IRDecorations.IRDName.class);
        Type asmMemberFieldType = MethodWriter.getType((Class)irLoadFieldMemberNode.getDecorationValue(IRDecorations.IRDExpressionType.class));
        if (isStatic) {
            methodWriter.getStatic(WriterConstants.CLASS_TYPE, memberFieldName, asmMemberFieldType);
        } else {
            methodWriter.loadThis();
            methodWriter.getField(WriterConstants.CLASS_TYPE, memberFieldName, asmMemberFieldType);
        }
    }

    @Override
    public void visitLoadBraceDef(LoadBraceDefNode irLoadBraceDefNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadBraceDefNode.getLocation());
        Type methodType = Type.getMethodType(MethodWriter.getType((Class)irLoadBraceDefNode.getDecorationValue(IRDecorations.IRDExpressionType.class)), MethodWriter.getType(def.class), MethodWriter.getType((Class)irLoadBraceDefNode.getDecorationValue(IRDecorations.IRDIndexType.class)));
        methodWriter.invokeDefCall("arrayLoad", methodType, 3, new Object[0]);
    }

    @Override
    public void visitLoadBrace(LoadBraceNode irLoadBraceNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irLoadBraceNode.getLocation());
        methodWriter.arrayLoad(MethodWriter.getType((Class)irLoadBraceNode.getDecorationValue(IRDecorations.IRDExpressionType.class)));
    }

    @Override
    public void visitStoreVariable(StoreVariableNode irStoreVariableNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irStoreVariableNode.getChildNode(), writeScope);
        WriteScope.Variable variable = writeScope.getVariable((String)irStoreVariableNode.getDecorationValue(IRDecorations.IRDName.class));
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
    }

    @Override
    public void visitStoreDotDef(StoreDotDefNode irStoreDotDefNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irStoreDotDefNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irStoreDotDefNode.getLocation());
        Type methodType = Type.getMethodType(MethodWriter.getType(Void.TYPE), MethodWriter.getType(def.class), MethodWriter.getType((Class)irStoreDotDefNode.getDecorationValue(IRDecorations.IRDStoreType.class)));
        methodWriter.invokeDefCall((String)irStoreDotDefNode.getDecorationValue(IRDecorations.IRDValue.class), methodType, 2, new Object[0]);
    }

    @Override
    public void visitStoreDot(StoreDotNode irStoreDotNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irStoreDotNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irStoreDotNode.getLocation());
        PainlessField painlessField = (PainlessField)irStoreDotNode.getDecorationValue(IRDecorations.IRDField.class);
        boolean isStatic = Modifier.isStatic(painlessField.javaField().getModifiers());
        Type asmOwnerType = Type.getType(painlessField.javaField().getDeclaringClass());
        String fieldName = painlessField.javaField().getName();
        Type asmFieldType = MethodWriter.getType(painlessField.typeParameter());
        if (isStatic) {
            methodWriter.putStatic(asmOwnerType, fieldName, asmFieldType);
        } else {
            methodWriter.putField(asmOwnerType, fieldName, asmFieldType);
        }
    }

    @Override
    public void visitStoreDotShortcut(StoreDotShortcutNode irDotSubShortcutNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irDotSubShortcutNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irDotSubShortcutNode.getLocation());
        methodWriter.invokeMethodCall((PainlessMethod)irDotSubShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class));
        methodWriter.writePop(MethodWriter.getType(((PainlessMethod)irDotSubShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class)).returnType()).getSize());
    }

    @Override
    public void visitStoreListShortcut(StoreListShortcutNode irStoreListShortcutNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irStoreListShortcutNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irStoreListShortcutNode.getLocation());
        methodWriter.invokeMethodCall((PainlessMethod)irStoreListShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class));
        methodWriter.writePop(MethodWriter.getType(((PainlessMethod)irStoreListShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class)).returnType()).getSize());
    }

    @Override
    public void visitStoreMapShortcut(StoreMapShortcutNode irStoreMapShortcutNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irStoreMapShortcutNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irStoreMapShortcutNode.getLocation());
        methodWriter.invokeMethodCall((PainlessMethod)irStoreMapShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class));
        methodWriter.writePop(MethodWriter.getType(((PainlessMethod)irStoreMapShortcutNode.getDecorationValue(IRDecorations.IRDMethod.class)).returnType()).getSize());
    }

    @Override
    public void visitStoreFieldMember(StoreFieldMemberNode irStoreFieldMemberNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        if (!irStoreFieldMemberNode.hasCondition(IRDecorations.IRCStatic.class)) {
            methodWriter.loadThis();
        }
        this.visit(irStoreFieldMemberNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irStoreFieldMemberNode.getLocation());
        boolean isStatic = irStoreFieldMemberNode.hasCondition(IRDecorations.IRCStatic.class);
        String memberFieldName = (String)irStoreFieldMemberNode.getDecorationValue(IRDecorations.IRDName.class);
        Type asmMemberFieldType = MethodWriter.getType((Class)irStoreFieldMemberNode.getDecorationValue(IRDecorations.IRDStoreType.class));
        if (isStatic) {
            methodWriter.putStatic(WriterConstants.CLASS_TYPE, memberFieldName, asmMemberFieldType);
        } else {
            methodWriter.loadThis();
            methodWriter.putField(WriterConstants.CLASS_TYPE, memberFieldName, asmMemberFieldType);
        }
    }

    @Override
    public void visitStoreBraceDef(StoreBraceDefNode irStoreBraceDefNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irStoreBraceDefNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irStoreBraceDefNode.getLocation());
        Type methodType = Type.getMethodType(MethodWriter.getType(Void.TYPE), MethodWriter.getType(def.class), MethodWriter.getType((Class)irStoreBraceDefNode.getDecorationValue(IRDecorations.IRDIndexType.class)), MethodWriter.getType((Class)irStoreBraceDefNode.getDecorationValue(IRDecorations.IRDStoreType.class)));
        methodWriter.invokeDefCall("arrayStore", methodType, 4, new Object[0]);
    }

    @Override
    public void visitStoreBrace(StoreBraceNode irStoreBraceNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irStoreBraceNode.getChildNode(), writeScope);
        methodWriter.writeDebugInfo(irStoreBraceNode.getLocation());
        methodWriter.arrayStore(MethodWriter.getType((Class)irStoreBraceNode.getDecorationValue(IRDecorations.IRDStoreType.class)));
    }

    @Override
    public void visitInvokeCallDef(InvokeCallDefNode irInvokeCallDefNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irInvokeCallDefNode.getLocation());
        StringBuilder defCallRecipe = new StringBuilder();
        ArrayList<String> boostrapArguments = new ArrayList<String>();
        ArrayList typeParameters = new ArrayList();
        int capturedCount = 0;
        typeParameters.add(Object.class);
        for (int i = 0; i < irInvokeCallDefNode.getArgumentNodes().size(); ++i) {
            ExpressionNode irArgumentNode = irInvokeCallDefNode.getArgumentNodes().get(i);
            this.visit(irArgumentNode, writeScope);
            typeParameters.add((Class)irArgumentNode.getDecorationValue(IRDecorations.IRDExpressionType.class));
            if (!(irArgumentNode instanceof DefInterfaceReferenceNode)) continue;
            DefInterfaceReferenceNode defInterfaceReferenceNode = (DefInterfaceReferenceNode)irArgumentNode;
            List captureNames = defInterfaceReferenceNode.getDecorationValueOrDefault(IRDecorations.IRDCaptureNames.class, Collections.emptyList());
            boostrapArguments.add(((Def.Encoding)defInterfaceReferenceNode.getDecorationValue(IRDecorations.IRDDefReferenceEncoding.class)).toString());
            if (defInterfaceReferenceNode.hasCondition(IRDecorations.IRCInstanceCapture.class)) {
                ++capturedCount;
                typeParameters.add(ScriptThis.class);
            }
            char encoding = (char)(i + capturedCount);
            defCallRecipe.append(encoding);
            capturedCount += captureNames.size();
            for (String captureName : captureNames) {
                WriteScope.Variable captureVariable = writeScope.getVariable(captureName);
                typeParameters.add(captureVariable.getType());
            }
        }
        Type[] asmParameterTypes = new Type[typeParameters.size()];
        for (int index = 0; index < asmParameterTypes.length; ++index) {
            Class typeParameter = (Class)typeParameters.get(index);
            asmParameterTypes[index] = typeParameter.equals(ScriptThis.class) ? WriterConstants.CLASS_TYPE : MethodWriter.getType((Class)typeParameters.get(index));
        }
        String methodName = (String)irInvokeCallDefNode.getDecorationValue(IRDecorations.IRDName.class);
        Type methodType = Type.getMethodType(MethodWriter.getType((Class)irInvokeCallDefNode.getDecorationValue(IRDecorations.IRDExpressionType.class)), asmParameterTypes);
        boostrapArguments.add(0, defCallRecipe.toString());
        methodWriter.invokeDefCall(methodName, methodType, 0, boostrapArguments.toArray());
    }

    @Override
    public void visitInvokeCall(InvokeCallNode irInvokeCallNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irInvokeCallNode.getLocation());
        if (irInvokeCallNode.getBox().isPrimitive()) {
            methodWriter.box(MethodWriter.getType(irInvokeCallNode.getBox()));
        }
        for (ExpressionNode irArgumentNode : irInvokeCallNode.getArgumentNodes()) {
            this.visit(irArgumentNode, writeScope);
        }
        methodWriter.invokeMethodCall(irInvokeCallNode.getMethod());
    }

    @Override
    public void visitInvokeCallMember(InvokeCallMemberNode irInvokeCallMemberNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.writeDebugInfo(irInvokeCallMemberNode.getLocation());
        FunctionTable.LocalFunction localFunction = (FunctionTable.LocalFunction)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDFunction.class);
        PainlessMethod thisMethod = (PainlessMethod)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDThisMethod.class);
        PainlessMethod importedMethod = (PainlessMethod)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDMethod.class);
        PainlessClassBinding classBinding = (PainlessClassBinding)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDClassBinding.class);
        PainlessInstanceBinding instanceBinding = (PainlessInstanceBinding)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDInstanceBinding.class);
        List<ExpressionNode> irArgumentNodes = irInvokeCallMemberNode.getArgumentNodes();
        if (localFunction != null) {
            if (!localFunction.isStatic()) {
                methodWriter.loadThis();
            }
            for (ExpressionNode irArgumentNode : irArgumentNodes) {
                this.visit(irArgumentNode, writeScope);
            }
            if (localFunction.isStatic()) {
                methodWriter.invokeStatic(WriterConstants.CLASS_TYPE, localFunction.getAsmMethod());
            } else {
                methodWriter.invokeVirtual(WriterConstants.CLASS_TYPE, localFunction.getAsmMethod());
            }
        } else if (thisMethod != null) {
            methodWriter.loadThis();
            for (ExpressionNode irArgumentNode : irArgumentNodes) {
                this.visit(irArgumentNode, writeScope);
            }
            Method asmMethod = new Method(thisMethod.javaMethod().getName(), thisMethod.methodType().dropParameterTypes(0, 1).toMethodDescriptorString());
            methodWriter.invokeVirtual(WriterConstants.CLASS_TYPE, asmMethod);
        } else if (importedMethod != null) {
            for (ExpressionNode irArgumentNode : irArgumentNodes) {
                this.visit(irArgumentNode, writeScope);
            }
            Type asmType = Type.getType(importedMethod.targetClass());
            Method asmMethod = new Method(importedMethod.javaMethod().getName(), importedMethod.methodType().toMethodDescriptorString());
            methodWriter.invokeStatic(asmType, asmMethod);
        } else if (classBinding != null) {
            int argument;
            Type type = Type.getType(classBinding.javaConstructor().getDeclaringClass());
            int classBindingOffset = irInvokeCallMemberNode.hasCondition(IRDecorations.IRCStatic.class) ? 0 : 1;
            int javaConstructorParameterCount = classBinding.javaConstructor().getParameterCount() - classBindingOffset;
            String bindingName = (String)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDName.class);
            Label nonNull = new Label();
            methodWriter.loadThis();
            methodWriter.getField(WriterConstants.CLASS_TYPE, bindingName, type);
            methodWriter.ifNonNull(nonNull);
            methodWriter.loadThis();
            methodWriter.newInstance(type);
            methodWriter.dup();
            if (classBindingOffset == 1) {
                methodWriter.loadThis();
            }
            for (argument = 0; argument < javaConstructorParameterCount; ++argument) {
                this.visit(irArgumentNodes.get(argument), writeScope);
            }
            methodWriter.invokeConstructor(type, Method.getMethod(classBinding.javaConstructor()));
            methodWriter.putField(WriterConstants.CLASS_TYPE, bindingName, type);
            methodWriter.mark(nonNull);
            methodWriter.loadThis();
            methodWriter.getField(WriterConstants.CLASS_TYPE, bindingName, type);
            for (argument = 0; argument < classBinding.javaMethod().getParameterCount(); ++argument) {
                this.visit(irArgumentNodes.get(argument + javaConstructorParameterCount), writeScope);
            }
            methodWriter.invokeVirtual(type, Method.getMethod(classBinding.javaMethod()));
        } else if (instanceBinding != null) {
            Type type = Type.getType(instanceBinding.targetInstance().getClass());
            String bindingName = (String)irInvokeCallMemberNode.getDecorationValue(IRDecorations.IRDName.class);
            methodWriter.loadThis();
            methodWriter.getStatic(WriterConstants.CLASS_TYPE, bindingName, type);
            for (int argument = 0; argument < instanceBinding.javaMethod().getParameterCount(); ++argument) {
                this.visit(irArgumentNodes.get(argument), writeScope);
            }
            methodWriter.invokeVirtual(type, Method.getMethod(instanceBinding.javaMethod()));
        } else {
            throw new IllegalStateException("invalid unbound call");
        }
    }

    @Override
    public void visitFlipArrayIndex(FlipArrayIndexNode irFlipArrayIndexNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irFlipArrayIndexNode.getChildNode(), writeScope);
        Label noFlip = new Label();
        methodWriter.dup();
        methodWriter.ifZCmp(156, noFlip);
        methodWriter.swap();
        methodWriter.dupX1();
        methodWriter.arrayLength();
        methodWriter.visitInsn(96);
        methodWriter.mark(noFlip);
    }

    @Override
    public void visitFlipCollectionIndex(FlipCollectionIndexNode irFlipCollectionIndexNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irFlipCollectionIndexNode.getChildNode(), writeScope);
        Label noFlip = new Label();
        methodWriter.dup();
        methodWriter.ifZCmp(156, noFlip);
        methodWriter.swap();
        methodWriter.dupX1();
        methodWriter.invokeInterface(WriterConstants.COLLECTION_TYPE, WriterConstants.COLLECTION_SIZE);
        methodWriter.visitInsn(96);
        methodWriter.mark(noFlip);
    }

    @Override
    public void visitFlipDefIndex(FlipDefIndexNode irFlipDefIndexNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        methodWriter.dup();
        this.visit(irFlipDefIndexNode.getChildNode(), writeScope);
        Type asmExpressionType = MethodWriter.getType((Class)irFlipDefIndexNode.getChildNode().getDecorationValue(IRDecorations.IRDExpressionType.class));
        Type asmDefType = MethodWriter.getType(def.class);
        Type methodType = Type.getMethodType(asmExpressionType, asmDefType, asmExpressionType);
        methodWriter.invokeDefCall("normalizeIndex", methodType, 10, new Object[0]);
    }

    @Override
    public void visitDup(DupNode irDupNode, WriteScope writeScope) {
        MethodWriter methodWriter = writeScope.getMethodWriter();
        this.visit(irDupNode.getChildNode(), writeScope);
        int size = irDupNode.getDecorationValueOrDefault(IRDecorations.IRDSize.class, 0);
        int depth = irDupNode.getDecorationValueOrDefault(IRDecorations.IRDDepth.class, 0);
        methodWriter.writeDup(size, depth);
    }

    private static final class ScriptThis {
        private ScriptThis() {
        }
    }
}

