/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.DatabaseNodeService;
import org.elasticsearch.ingest.geoip.GeoIpCache;
import org.elasticsearch.ingest.geoip.GeoIpDownloader;
import org.elasticsearch.ingest.geoip.GeoIpDownloaderTaskExecutor;
import org.elasticsearch.ingest.geoip.GeoIpProcessor;
import org.elasticsearch.ingest.geoip.GeoIpTaskParams;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.ingest.geoip.HttpClient;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStats;
import org.elasticsearch.ingest.geoip.stats.GeoIpStatsAction;
import org.elasticsearch.ingest.geoip.stats.GeoIpStatsTransportAction;
import org.elasticsearch.ingest.geoip.stats.RestGeoIpStatsAction;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class IngestGeoIpPlugin
extends Plugin
implements IngestPlugin,
SystemIndexPlugin,
Closeable,
PersistentTaskPlugin,
ActionPlugin {
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting("ingest.geoip.cache_size", 1000L, 0L, Setting.Property.NodeScope);
    private static final int GEOIP_INDEX_MAPPINGS_VERSION = 1;
    private static final String LEGACY_VERSION_FIELD_VALUE = "8.12.0";
    private final SetOnce<IngestService> ingestService = new SetOnce();
    private final SetOnce<DatabaseNodeService> databaseRegistry = new SetOnce();
    private GeoIpDownloaderTaskExecutor geoIpDownloaderTaskExecutor;

    @Override
    public List<Setting<?>> getSettings() {
        return List.of(CACHE_SIZE, GeoIpDownloaderTaskExecutor.EAGER_DOWNLOAD_SETTING, GeoIpDownloaderTaskExecutor.ENABLED_SETTING, GeoIpDownloader.ENDPOINT_SETTING, GeoIpDownloaderTaskExecutor.POLL_INTERVAL_SETTING);
    }

    @Override
    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        this.ingestService.set(parameters.ingestService);
        long cacheSize = CACHE_SIZE.get(parameters.env.settings());
        GeoIpCache geoIpCache = new GeoIpCache(cacheSize);
        DatabaseNodeService registry = new DatabaseNodeService(parameters.env, parameters.client, geoIpCache, parameters.genericExecutor, parameters.ingestService.getClusterService());
        this.databaseRegistry.set(registry);
        return Map.of("geoip", new GeoIpProcessor.Factory(registry));
    }

    @Override
    public Collection<?> createComponents(Plugin.PluginServices services) {
        try {
            String nodeId = services.nodeEnvironment().nodeId();
            this.databaseRegistry.get().initialize(nodeId, services.resourceWatcherService(), this.ingestService.get());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.geoIpDownloaderTaskExecutor = new GeoIpDownloaderTaskExecutor(services.client(), new HttpClient(), services.clusterService(), services.threadPool());
        this.geoIpDownloaderTaskExecutor.init();
        return List.of(this.databaseRegistry.get(), this.geoIpDownloaderTaskExecutor);
    }

    @Override
    public void close() throws IOException {
        this.databaseRegistry.get().close();
    }

    @Override
    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        return List.of(this.geoIpDownloaderTaskExecutor);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler(GeoIpStatsAction.INSTANCE, GeoIpStatsTransportAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new RestGeoIpStatsAction());
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return List.of(new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("geoip-downloader", new String[0]), GeoIpTaskParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("geoip-downloader", new String[0]), GeoIpTaskState::fromXContent));
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "geoip-downloader", GeoIpTaskState::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "geoip-downloader", GeoIpTaskParams::new), new NamedWriteableRegistry.Entry(Task.Status.class, "geoip-downloader", GeoIpDownloaderStats::new));
    }

    @Override
    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        SystemIndexDescriptor geoipDatabasesIndex = SystemIndexDescriptor.builder().setIndexPattern(".geoip_databases*").setDescription("GeoIP databases").setMappings(IngestGeoIpPlugin.mappings()).setSettings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").build()).setOrigin("ingest").setVersionMetaKey("version").setPrimaryIndex(".geoip_databases").setNetNew().build();
        return List.of(geoipDatabasesIndex);
    }

    @Override
    public String getFeatureName() {
        return "geoip";
    }

    @Override
    public String getFeatureDescription() {
        return "Manages data related to GeoIP database downloader";
    }

    private static XContentBuilder mappings() {
        try {
            return XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("_meta").field("version", LEGACY_VERSION_FIELD_VALUE).field("managed_index_mappings_version", 1).endObject().field("dynamic", "strict").startObject("properties").startObject("name").field("type", "keyword").endObject().startObject("chunk").field("type", "integer").endObject().startObject("data").field("type", "binary").endObject().endObject().endObject().endObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build mappings for .geoip_databases", e);
        }
    }
}

