/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

class GeoIpTaskState
implements PersistentTaskState,
VersionedNamedWriteable {
    private static final ParseField DATABASES = new ParseField("databases", new String[0]);
    static final GeoIpTaskState EMPTY = new GeoIpTaskState(Map.of());
    private static final ConstructingObjectParser<GeoIpTaskState, Void> PARSER = new ConstructingObjectParser("geoip-downloader", true, args -> {
        List databases = (List)args[0];
        return new GeoIpTaskState(databases.stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
    });
    private final Map<String, Metadata> databases;

    public static GeoIpTaskState fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    GeoIpTaskState(Map<String, Metadata> databases) {
        this.databases = Map.copyOf(databases);
    }

    GeoIpTaskState(StreamInput input) throws IOException {
        this.databases = input.readImmutableMap(in -> new Metadata(in.readLong(), in.readVInt(), in.readVInt(), in.readString(), in.readLong()));
    }

    public GeoIpTaskState put(String name, Metadata metadata) {
        HashMap<String, Metadata> newDatabases = new HashMap<String, Metadata>(this.databases);
        newDatabases.put(name, metadata);
        return new GeoIpTaskState(newDatabases);
    }

    public Map<String, Metadata> getDatabases() {
        return this.databases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoIpTaskState that = (GeoIpTaskState)o;
        return this.databases.equals(that.databases);
    }

    public int hashCode() {
        return Objects.hash(this.databases);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("databases");
        for (Map.Entry<String, Metadata> e : this.databases.entrySet()) {
            builder.field(e.getKey(), e.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return "geoip-downloader";
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_13_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.databases, (o, v) -> {
            o.writeLong(v.lastUpdate);
            o.writeVInt(v.firstChunk);
            o.writeVInt(v.lastChunk);
            o.writeString(v.md5);
            o.writeLong(v.lastCheck);
        });
    }

    @Nullable
    static GeoIpTaskState getGeoIpTaskState(ClusterState state) {
        PersistentTasksCustomMetadata.PersistentTask task = PersistentTasksCustomMetadata.getTaskWithId(state, "geoip-downloader");
        return task == null ? null : (GeoIpTaskState)task.getState();
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, name) -> Tuple.tuple(name, Metadata.fromXContent(p)), DATABASES);
    }

    record Metadata(long lastUpdate, int firstChunk, int lastChunk, String md5, long lastCheck) implements ToXContentObject
    {
        static Metadata EMPTY = new Metadata(-1L, -1, -1, "", -1L);
        private static final String NAME = "geoip-downloader-metadata";
        private static final ParseField LAST_CHECK = new ParseField("last_check", new String[0]);
        private static final ParseField LAST_UPDATE = new ParseField("last_update", new String[0]);
        private static final ParseField FIRST_CHUNK = new ParseField("first_chunk", new String[0]);
        private static final ParseField LAST_CHUNK = new ParseField("last_chunk", new String[0]);
        private static final ParseField MD5 = new ParseField("md5", new String[0]);
        private static final ConstructingObjectParser<Metadata, Void> PARSER = new ConstructingObjectParser("geoip-downloader-metadata", true, args -> new Metadata((Long)args[0], (Integer)args[1], (Integer)args[2], (String)args[3], (Long)(args[4] == null ? args[0] : args[4])));

        Metadata {
            Objects.requireNonNull(md5);
        }

        public static Metadata fromXContent(XContentParser parser) {
            try {
                return PARSER.parse(parser, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isCloseToExpiration() {
            return Instant.ofEpochMilli(this.lastCheck).isBefore(Instant.now().minus(25L, ChronoUnit.DAYS));
        }

        public boolean isValid(Settings settings) {
            TimeValue valid = settings.getAsTime("ingest.geoip.database_validity", TimeValue.timeValueDays(30L));
            return Instant.ofEpochMilli(this.lastCheck).isAfter(Instant.now().minus(valid.getMillis(), ChronoUnit.MILLIS));
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(LAST_UPDATE.getPreferredName(), this.lastUpdate);
            builder.field(LAST_CHECK.getPreferredName(), this.lastCheck);
            builder.field(FIRST_CHUNK.getPreferredName(), this.firstChunk);
            builder.field(LAST_CHUNK.getPreferredName(), this.lastChunk);
            builder.field(MD5.getPreferredName(), this.md5);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_UPDATE);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), FIRST_CHUNK);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), LAST_CHUNK);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), MD5);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_CHECK);
        }
    }
}

