/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public final class PipelineConfiguration
implements SimpleDiffable<PipelineConfiguration>,
ToXContentObject {
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("pipeline_config", true, Builder::new);
    private final String id;
    private final BytesReference config;
    private final XContentType xContentType;

    public static ContextParser<Void, PipelineConfiguration> getParser() {
        return (parser, context) -> PARSER.apply(parser, null).build();
    }

    public PipelineConfiguration(String id, BytesReference config, XContentType xContentType) {
        this.id = Objects.requireNonNull(id);
        this.config = Objects.requireNonNull(config);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getConfigAsMap() {
        return XContentHelper.convertToMap(this.config, true, this.xContentType).v2();
    }

    XContentType getXContentType() {
        return this.xContentType;
    }

    BytesReference getConfig() {
        return this.config;
    }

    public Integer getVersion() {
        Map<String, Object> configMap = this.getConfigAsMap();
        if (configMap.containsKey("version")) {
            Object o = configMap.get("version");
            if (o == null) {
                return null;
            }
            if (o instanceof Number) {
                Number number = (Number)o;
                return number.intValue();
            }
            throw new IllegalStateException("unexpected version type [" + o.getClass().getName() + "]");
        }
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("config", this.getConfigAsMap());
        builder.endObject();
        return builder;
    }

    public static PipelineConfiguration readFrom(StreamInput in) throws IOException {
        return new PipelineConfiguration(in.readString(), in.readBytesReference(), in.readEnum(XContentType.class));
    }

    public static Diff<PipelineConfiguration> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(PipelineConfiguration::readFrom, in);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBytesReference(this.config);
        XContentHelper.writeTo(out, this.xContentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineConfiguration that = (PipelineConfiguration)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.getConfigAsMap().equals(that.getConfigAsMap());
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.getConfigAsMap().hashCode();
        return result;
    }

    static {
        PARSER.declareString(Builder::setId, new ParseField("id", new String[0]));
        PARSER.declareField((parser, builder, aVoid) -> {
            XContentBuilder contentBuilder = XContentBuilder.builder(parser.contentType().xContent());
            contentBuilder.generator().copyCurrentStructure(parser);
            builder.setConfig(BytesReference.bytes(contentBuilder), contentBuilder.contentType());
        }, new ParseField("config", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    private static class Builder {
        private String id;
        private BytesReference config;
        private XContentType xContentType;

        private Builder() {
        }

        void setId(String id) {
            this.id = id;
        }

        void setConfig(BytesReference config, XContentType xContentType) {
            this.config = config;
            this.xContentType = xContentType;
        }

        PipelineConfiguration build() {
            return new PipelineConfiguration(this.id, this.config, this.xContentType);
        }
    }
}

