/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.recovery.SnapshotFilesProvider;
import org.elasticsearch.threadpool.ThreadPool;

public class RecoveriesCollection {
    private final ConcurrentMap<Long, RecoveryTarget> onGoingRecoveries = ConcurrentCollections.newConcurrentMap();
    private final Logger logger;
    private final ThreadPool threadPool;

    public RecoveriesCollection(Logger logger, ThreadPool threadPool) {
        this.logger = logger;
        this.threadPool = threadPool;
    }

    public long startRecovery(IndexShard indexShard, DiscoveryNode sourceNode, long clusterStateVersion, SnapshotFilesProvider snapshotFilesProvider, PeerRecoveryTargetService.RecoveryListener listener, TimeValue activityTimeout, @Nullable Releasable snapshotFileDownloadsPermit) {
        RecoveryTarget recoveryTarget = new RecoveryTarget(indexShard, sourceNode, clusterStateVersion, snapshotFilesProvider, snapshotFileDownloadsPermit, listener);
        this.startRecoveryInternal(recoveryTarget, activityTimeout);
        return recoveryTarget.recoveryId();
    }

    private void startRecoveryInternal(RecoveryTarget recoveryTarget, TimeValue activityTimeout) {
        RecoveryTarget existingTarget = this.onGoingRecoveries.putIfAbsent(recoveryTarget.recoveryId(), recoveryTarget);
        assert (existingTarget == null) : "found two RecoveryStatus instances with the same id";
        this.logger.trace("{} started recovery from {}, id [{}]", (Object)recoveryTarget.shardId(), (Object)recoveryTarget.sourceNode(), (Object)recoveryTarget.recoveryId());
        this.threadPool.schedule(new RecoveryMonitor(recoveryTarget.recoveryId(), recoveryTarget.lastAccessTime(), activityTimeout), activityTimeout, this.threadPool.generic());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryTarget resetRecovery(long recoveryId, TimeValue activityTimeout) {
        RecoveryTarget oldRecoveryTarget = null;
        try {
            RecoveryTarget newRecoveryTarget;
            ConcurrentMap<Long, RecoveryTarget> concurrentMap = this.onGoingRecoveries;
            synchronized (concurrentMap) {
                oldRecoveryTarget = (RecoveryTarget)this.onGoingRecoveries.remove(recoveryId);
                if (oldRecoveryTarget == null) {
                    return null;
                }
                newRecoveryTarget = oldRecoveryTarget.retryCopy();
                this.startRecoveryInternal(newRecoveryTarget, activityTimeout);
            }
            boolean successfulReset = oldRecoveryTarget.resetRecovery(newRecoveryTarget.cancellableThreads());
            if (successfulReset) {
                this.logger.trace("{} restarted recovery from {}, id [{}], previous id [{}]", (Object)newRecoveryTarget.shardId(), (Object)newRecoveryTarget.sourceNode(), (Object)newRecoveryTarget.recoveryId(), (Object)oldRecoveryTarget.recoveryId());
                return newRecoveryTarget;
            }
            this.logger.trace("{} recovery could not be reset as it is already cancelled, recovery from {}, id [{}], previous id [{}]", (Object)newRecoveryTarget.shardId(), (Object)newRecoveryTarget.sourceNode(), (Object)newRecoveryTarget.recoveryId(), (Object)oldRecoveryTarget.recoveryId());
            this.cancelRecovery(newRecoveryTarget.recoveryId(), "recovery cancelled during reset");
            return null;
        }
        catch (Exception e) {
            oldRecoveryTarget.notifyListener(new RecoveryFailedException(oldRecoveryTarget.state(), "failed to retry recovery", (Throwable)e), true);
            return null;
        }
    }

    public RecoveryTarget getRecoveryTarget(long id) {
        return (RecoveryTarget)this.onGoingRecoveries.get(id);
    }

    public RecoveryRef getRecovery(long id) {
        RecoveryTarget status = (RecoveryTarget)this.onGoingRecoveries.get(id);
        if (status != null && status.tryIncRef()) {
            return new RecoveryRef(status);
        }
        return null;
    }

    public RecoveryRef getRecoverySafe(long id, ShardId shardId) {
        RecoveryRef recoveryRef = this.getRecovery(id);
        if (recoveryRef == null) {
            throw new IndexShardClosedException(shardId);
        }
        assert (recoveryRef.target().shardId().equals(shardId));
        assert (recoveryRef.target().indexShard().routingEntry().isPromotableToPrimary());
        return recoveryRef;
    }

    public boolean cancelRecovery(long id, String reason) {
        RecoveryTarget removed = (RecoveryTarget)this.onGoingRecoveries.remove(id);
        boolean cancelled = false;
        if (removed != null) {
            this.logger.trace("{} canceled recovery from {}, id [{}] (reason [{}])", (Object)removed.shardId(), (Object)removed.sourceNode(), (Object)removed.recoveryId(), (Object)reason);
            removed.cancel(reason);
            cancelled = true;
        }
        return cancelled;
    }

    public void failRecovery(long id, RecoveryFailedException e, boolean sendShardFailure) {
        RecoveryTarget removed = (RecoveryTarget)this.onGoingRecoveries.remove(id);
        if (removed != null) {
            this.logger.trace("{} failing recovery from {}, id [{}]. Send shard failure: [{}]", (Object)removed.shardId(), (Object)removed.sourceNode(), (Object)removed.recoveryId(), (Object)sendShardFailure);
            removed.fail(e, sendShardFailure);
        }
    }

    public void markRecoveryAsDone(long id) {
        RecoveryTarget removed = (RecoveryTarget)this.onGoingRecoveries.remove(id);
        if (removed != null) {
            this.logger.trace("{} marking recovery from {} as done, id [{}]", (Object)removed.shardId(), (Object)removed.sourceNode(), (Object)removed.recoveryId());
            removed.markAsDone();
        }
    }

    public int size() {
        return this.onGoingRecoveries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRecoveriesForShard(ShardId shardId, String reason) {
        boolean cancelled = false;
        ArrayList<RecoveryTarget> matchedRecoveries = new ArrayList<RecoveryTarget>();
        ConcurrentMap<Long, RecoveryTarget> concurrentMap = this.onGoingRecoveries;
        synchronized (concurrentMap) {
            Iterator it = this.onGoingRecoveries.values().iterator();
            while (it.hasNext()) {
                RecoveryTarget status = (RecoveryTarget)it.next();
                if (!status.shardId().equals(shardId)) continue;
                matchedRecoveries.add(status);
                it.remove();
            }
        }
        for (RecoveryTarget removed : matchedRecoveries) {
            this.logger.trace("{} canceled recovery from {}, id [{}] (reason [{}])", (Object)removed.shardId(), (Object)removed.sourceNode(), (Object)removed.recoveryId(), (Object)reason);
            removed.cancel(reason);
            cancelled = true;
        }
        return cancelled;
    }

    private class RecoveryMonitor
    extends AbstractRunnable {
        private final long recoveryId;
        private final TimeValue checkInterval;
        private volatile long lastSeenAccessTime;

        private RecoveryMonitor(long recoveryId, long lastSeenAccessTime, TimeValue checkInterval) {
            this.recoveryId = recoveryId;
            this.checkInterval = checkInterval;
            this.lastSeenAccessTime = lastSeenAccessTime;
        }

        @Override
        public void onFailure(Exception e) {
            RecoveriesCollection.this.logger.error(() -> "unexpected error while monitoring recovery [" + this.recoveryId + "]", (Throwable)e);
        }

        @Override
        protected void doRun() throws Exception {
            RecoveryTarget status = (RecoveryTarget)RecoveriesCollection.this.onGoingRecoveries.get(this.recoveryId);
            if (status == null) {
                RecoveriesCollection.this.logger.trace("[monitor] no status found for [{}], shutting down", (Object)this.recoveryId);
                return;
            }
            long accessTime = status.lastAccessTime();
            if (accessTime == this.lastSeenAccessTime) {
                String message = "no activity after [" + this.checkInterval + "]";
                RecoveriesCollection.this.failRecovery(this.recoveryId, new RecoveryFailedException(status.state(), message, (Throwable)new ElasticsearchTimeoutException(message, new Object[0])), true);
                return;
            }
            this.lastSeenAccessTime = accessTime;
            RecoveriesCollection.this.logger.trace("[monitor] rescheduling check for [{}]. last access time is [{}]", (Object)this.recoveryId, (Object)this.lastSeenAccessTime);
            RecoveriesCollection.this.threadPool.schedule(this, this.checkInterval, RecoveriesCollection.this.threadPool.generic());
        }
    }

    public static class RecoveryRef
    implements Releasable {
        private final RecoveryTarget status;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public RecoveryRef(RecoveryTarget status) {
            this.status = status;
            this.status.setLastAccessTime();
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.status.decRef();
            }
        }

        public RecoveryTarget target() {
            return this.status;
        }
    }
}

