/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.ChildMemoryCircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerMetrics;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;
import org.elasticsearch.monitor.jvm.GcNames;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.telemetry.metric.LongCounter;

public class HierarchyCircuitBreakerService
extends CircuitBreakerService {
    private static final Logger logger = LogManager.getLogger(HierarchyCircuitBreakerService.class);
    private static final String CHILD_LOGGER_PREFIX = "org.elasticsearch.indices.breaker.";
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private final Map<String, CircuitBreaker> breakers;
    public static final Setting<Boolean> USE_REAL_MEMORY_USAGE_SETTING = Setting.boolSetting("indices.breaker.total.use_real_memory", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING = new Setting<ByteSizeValue>("indices.breaker.total.limit", settings -> {
        if (USE_REAL_MEMORY_USAGE_SETTING.get((Settings)settings).booleanValue()) {
            return "95%";
        }
        return "70%";
    }, s -> MemorySizeValue.parseHeapRatioOrDeprecatedByteSizeValue(s, "indices.breaker.total.limit", 50.0), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.fielddata.limit", "40%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.fielddata.overhead", 1.03, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<CircuitBreaker.Type> FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.fielddata.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.request.limit", "60%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("indices.breaker.request.overhead", 1.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<CircuitBreaker.Type> REQUEST_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("indices.breaker.request.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("network.breaker.inflight_requests.limit", "100%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_OVERHEAD_SETTING = Setting.doubleSetting("network.breaker.inflight_requests.overhead", 2.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<CircuitBreaker.Type> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_TYPE_SETTING = new Setting<CircuitBreaker.Type>("network.breaker.inflight_requests.type", "memory", CircuitBreaker.Type::parseValue, Setting.Property.NodeScope);
    private volatile boolean trackRealMemoryUsage;
    private volatile BreakerSettings parentSettings;
    private final AtomicLong parentTripCount = new AtomicLong(0L);
    private final LongCounter parentTripCountTotalMetric;
    private final Function<Boolean, OverLimitStrategy> overLimitStrategyFactory;
    private volatile OverLimitStrategy overLimitStrategy;
    static boolean permitNegativeValues = false;

    public HierarchyCircuitBreakerService(CircuitBreakerMetrics metrics, Settings settings, List<BreakerSettings> customBreakers, ClusterSettings clusterSettings) {
        this(metrics, settings, customBreakers, clusterSettings, HierarchyCircuitBreakerService::createOverLimitStrategy);
    }

    HierarchyCircuitBreakerService(CircuitBreakerMetrics metrics, Settings settings, List<BreakerSettings> customBreakers, ClusterSettings clusterSettings, Function<Boolean, OverLimitStrategy> overLimitStrategyFactory) {
        HashMap<String, CircuitBreaker> childCircuitBreakers = new HashMap<String, CircuitBreaker>();
        childCircuitBreakers.put("fielddata", this.validateAndCreateBreaker(metrics.getTripCount(), new BreakerSettings("fielddata", FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING.get(settings), FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING.get(settings), CircuitBreaker.Durability.PERMANENT)));
        childCircuitBreakers.put("inflight_requests", this.validateAndCreateBreaker(metrics.getTripCount(), new BreakerSettings("inflight_requests", IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_OVERHEAD_SETTING.get(settings), IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_TYPE_SETTING.get(settings), CircuitBreaker.Durability.TRANSIENT)));
        childCircuitBreakers.put("request", this.validateAndCreateBreaker(metrics.getTripCount(), new BreakerSettings("request", REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING.get(settings), REQUEST_CIRCUIT_BREAKER_TYPE_SETTING.get(settings), CircuitBreaker.Durability.TRANSIENT)));
        for (BreakerSettings breakerSettings : customBreakers) {
            if (childCircuitBreakers.containsKey(breakerSettings.getName())) {
                throw new IllegalArgumentException("More than one circuit breaker with the name [" + breakerSettings.getName() + "] exists. Circuit breaker names must be unique");
            }
            childCircuitBreakers.put(breakerSettings.getName(), this.validateAndCreateBreaker(metrics.getTripCount(), breakerSettings));
        }
        this.breakers = Map.copyOf(childCircuitBreakers);
        this.parentSettings = new BreakerSettings("parent", TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes(), 1.0, CircuitBreaker.Type.PARENT, null);
        logger.trace(() -> Strings.format("parent circuit breaker with settings %s", this.parentSettings));
        this.trackRealMemoryUsage = USE_REAL_MEMORY_USAGE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, this::setTotalCircuitBreakerLimit, HierarchyCircuitBreakerService::validateTotalCircuitBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING, FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING, (limit, overhead) -> this.updateCircuitBreakerSettings("fielddata", (ByteSizeValue)limit, (Double)overhead));
        clusterSettings.addSettingsUpdateConsumer(IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING, IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_OVERHEAD_SETTING, (limit, overhead) -> this.updateCircuitBreakerSettings("inflight_requests", (ByteSizeValue)limit, (Double)overhead));
        clusterSettings.addSettingsUpdateConsumer(REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING, (limit, overhead) -> this.updateCircuitBreakerSettings("request", (ByteSizeValue)limit, (Double)overhead));
        clusterSettings.addAffixUpdateConsumer(BreakerSettings.CIRCUIT_BREAKER_LIMIT_SETTING, BreakerSettings.CIRCUIT_BREAKER_OVERHEAD_SETTING, (name, updatedValues) -> this.updateCircuitBreakerSettings((String)name, (ByteSizeValue)updatedValues.v1(), (Double)updatedValues.v2()), (s, t) -> {});
        clusterSettings.addSettingsUpdateConsumer(USE_REAL_MEMORY_USAGE_SETTING, this::updateUseRealMemorySetting);
        this.overLimitStrategyFactory = overLimitStrategyFactory;
        this.overLimitStrategy = overLimitStrategyFactory.apply(this.trackRealMemoryUsage);
        this.parentTripCountTotalMetric = metrics.getTripCount();
    }

    private void updateCircuitBreakerSettings(String name, ByteSizeValue newLimit, Double newOverhead) {
        CircuitBreaker childBreaker = this.breakers.get(name);
        if (childBreaker != null) {
            childBreaker.setLimitAndOverhead(newLimit.getBytes(), newOverhead);
            logger.info("Updated limit {} and overhead {} for {}", (Object)newLimit.getStringRep(), (Object)newOverhead, (Object)name);
        }
    }

    private static void validateTotalCircuitBreakerLimit(ByteSizeValue byteSizeValue) {
        BreakerSettings newParentSettings = new BreakerSettings("parent", byteSizeValue.getBytes(), 1.0, CircuitBreaker.Type.PARENT, null);
        HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{newParentSettings});
    }

    private void setTotalCircuitBreakerLimit(ByteSizeValue byteSizeValue) {
        this.parentSettings = new BreakerSettings("parent", byteSizeValue.getBytes(), 1.0, CircuitBreaker.Type.PARENT, null);
    }

    public void updateUseRealMemorySetting(boolean trackRealMemoryUsage) {
        this.trackRealMemoryUsage = trackRealMemoryUsage;
        this.overLimitStrategy = this.overLimitStrategyFactory.apply(this.trackRealMemoryUsage);
    }

    public boolean isTrackRealMemoryUsage() {
        return this.trackRealMemoryUsage;
    }

    public OverLimitStrategy getOverLimitStrategy() {
        return this.overLimitStrategy;
    }

    public static void validateSettings(BreakerSettings[] childrenSettings) throws IllegalStateException {
        for (BreakerSettings childSettings : childrenSettings) {
            if (childSettings.getLimit() == -1L || !(childSettings.getOverhead() < 0.0)) continue;
            throw new IllegalStateException("Child breaker overhead " + childSettings + " must be non-negative");
        }
    }

    @Override
    public CircuitBreaker getBreaker(String name) {
        return this.breakers.get(name);
    }

    @Override
    public AllCircuitBreakerStats stats() {
        ArrayList<CircuitBreakerStats> allStats = new ArrayList<CircuitBreakerStats>(this.breakers.size());
        for (CircuitBreaker breaker : this.breakers.values()) {
            allStats.add(this.stats(breaker.getName()));
        }
        allStats.add(new CircuitBreakerStats("parent", this.parentSettings.getLimit(), this.memoryUsed((long)0L).totalUsage, 1.0, this.parentTripCount.get()));
        return new AllCircuitBreakerStats((CircuitBreakerStats[])allStats.toArray(CircuitBreakerStats[]::new));
    }

    @Override
    public CircuitBreakerStats stats(String name) {
        CircuitBreaker breaker = this.breakers.get(name);
        return new CircuitBreakerStats(breaker.getName(), breaker.getLimit(), breaker.getUsed(), breaker.getOverhead(), breaker.getTrippedCount());
    }

    private MemoryUsage memoryUsed(long newBytesReserved) {
        long transientUsage = 0L;
        long permanentUsage = 0L;
        for (CircuitBreaker breaker : this.breakers.values()) {
            long breakerUsed = (long)((double)breaker.getUsed() * breaker.getOverhead());
            if (breaker.getDurability() == CircuitBreaker.Durability.TRANSIENT) {
                transientUsage += breakerUsed;
                continue;
            }
            if (breaker.getDurability() != CircuitBreaker.Durability.PERMANENT) continue;
            permanentUsage += breakerUsed;
        }
        if (this.trackRealMemoryUsage) {
            long current = this.currentMemoryUsage();
            return new MemoryUsage(current, current + newBytesReserved, transientUsage, permanentUsage);
        }
        long parentEstimated = transientUsage + permanentUsage;
        return new MemoryUsage(parentEstimated, parentEstimated, transientUsage, permanentUsage);
    }

    long currentMemoryUsage() {
        return HierarchyCircuitBreakerService.realMemoryUsage();
    }

    static long realMemoryUsage() {
        try {
            return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
        }
        catch (IllegalArgumentException ex) {
            assert (ex.getMessage().matches("committed = \\d+ should be < max = \\d+"));
            logger.info("Cannot determine current memory usage due to JDK-8207200.", (Throwable)ex);
            return 0L;
        }
    }

    public long getParentLimit() {
        return this.parentSettings.getLimit();
    }

    public void checkParentLimit(long newBytesReserved, String label) throws CircuitBreakingException {
        MemoryUsage memoryUsed = this.memoryUsed(newBytesReserved);
        long parentLimit = this.parentSettings.getLimit();
        if (memoryUsed.totalUsage > parentLimit && this.overLimitStrategy.overLimit((MemoryUsage)memoryUsed).totalUsage > parentLimit) {
            this.parentTripCount.incrementAndGet();
            this.parentTripCountTotalMetric.increment();
            String messageString = HierarchyCircuitBreakerService.buildParentTripMessage(newBytesReserved, label, memoryUsed, parentLimit, this.trackRealMemoryUsage, this.breakers);
            CircuitBreaker.Durability durability = memoryUsed.transientChildUsage >= memoryUsed.permanentChildUsage ? CircuitBreaker.Durability.TRANSIENT : CircuitBreaker.Durability.PERMANENT;
            logger.debug(() -> Strings.format("%s", messageString));
            throw new CircuitBreakingException(messageString, memoryUsed.totalUsage, parentLimit, durability);
        }
    }

    static String buildParentTripMessage(long newBytesReserved, String label, MemoryUsage memoryUsed, long parentLimit, boolean trackRealMemoryUsage, Map<String, CircuitBreaker> breakers) {
        final StringBuilder message = new StringBuilder();
        message.append("[parent] Data too large, data for [");
        message.append(label);
        message.append("] would be [");
        HierarchyCircuitBreakerService.appendBytesSafe(message, memoryUsed.totalUsage);
        message.append("], which is larger than the limit of [");
        HierarchyCircuitBreakerService.appendBytesSafe(message, parentLimit);
        message.append("]");
        if (trackRealMemoryUsage) {
            long realUsage = memoryUsed.baseUsage;
            message.append(", real usage: [");
            HierarchyCircuitBreakerService.appendBytesSafe(message, realUsage);
            message.append("], new bytes reserved: [");
            HierarchyCircuitBreakerService.appendBytesSafe(message, newBytesReserved);
            message.append("]");
        }
        message.append(", usages [");
        breakers.forEach(new BiConsumer<String, CircuitBreaker>(){
            private boolean first = true;

            @Override
            public void accept(String key, CircuitBreaker breaker) {
                if (this.first) {
                    this.first = false;
                } else {
                    message.append(", ");
                }
                message.append(key).append("=");
                HierarchyCircuitBreakerService.appendBytesSafe(message, (long)((double)breaker.getUsed() * breaker.getOverhead()));
            }
        });
        message.append("]");
        return message.toString();
    }

    static void appendBytesSafe(StringBuilder stringBuilder, long bytes) {
        stringBuilder.append(bytes);
        if (-1L <= bytes) {
            stringBuilder.append("/");
            stringBuilder.append(ByteSizeValue.ofBytes(bytes));
        } else {
            logger.error("negative value in circuit breaker: {}", (Object)stringBuilder);
            assert (permitNegativeValues) : stringBuilder.toString();
        }
    }

    private CircuitBreaker validateAndCreateBreaker(LongCounter trippedCountMeter, BreakerSettings breakerSettings) {
        HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{breakerSettings});
        return breakerSettings.getType() == CircuitBreaker.Type.NOOP ? new NoopCircuitBreaker(breakerSettings.getName()) : new ChildMemoryCircuitBreaker(trippedCountMeter, breakerSettings, LogManager.getLogger((String)(CHILD_LOGGER_PREFIX + breakerSettings.getName())), this, breakerSettings.getName());
    }

    static OverLimitStrategy createOverLimitStrategy(boolean trackRealMemoryUsage) {
        JvmInfo jvmInfo = JvmInfo.jvmInfo();
        if (trackRealMemoryUsage && jvmInfo.useG1GC().equals("true") && Booleans.parseBoolean(System.getProperty("es.real_memory_circuit_breaker.g1_over_limit_strategy.enabled"), true)) {
            long lockTimeoutInMillis = Integer.parseInt(System.getProperty("es.real_memory_circuit_breaker.g1_over_limit_strategy.lock_timeout_ms", "500"));
            TimeValue lockTimeout = TimeValue.timeValueMillis(lockTimeoutInMillis);
            TimeValue fullGCLockTimeout = TimeValue.timeValueMillis(lockTimeoutInMillis);
            return new G1OverLimitStrategy(jvmInfo, HierarchyCircuitBreakerService::realMemoryUsage, HierarchyCircuitBreakerService.createYoungGcCountSupplier(), System::currentTimeMillis, 500L, 2000L, lockTimeout, fullGCLockTimeout);
        }
        return memoryUsed -> memoryUsed;
    }

    static LongSupplier createYoungGcCountSupplier() {
        List<GarbageCollectorMXBean> youngBeans = ManagementFactory.getGarbageCollectorMXBeans().stream().filter(mxBean -> GcNames.getByGcName(mxBean.getName(), mxBean.getName()).equals("young")).toList();
        assert (youngBeans.size() == 1);
        assert (youngBeans.get(0).getCollectionCount() != -1L) : "G1 must support getting collection count";
        if (youngBeans.size() == 1) {
            return youngBeans.get(0)::getCollectionCount;
        }
        logger.warn("Unable to find young generation collector, G1 over limit strategy might be impacted [{}]", youngBeans);
        return () -> -1L;
    }

    static interface OverLimitStrategy {
        public MemoryUsage overLimit(MemoryUsage var1);
    }

    static class MemoryUsage {
        final long baseUsage;
        final long totalUsage;
        final long transientChildUsage;
        final long permanentChildUsage;

        MemoryUsage(long baseUsage, long totalUsage, long transientChildUsage, long permanentChildUsage) {
            this.baseUsage = baseUsage;
            this.totalUsage = totalUsage;
            this.transientChildUsage = transientChildUsage;
            this.permanentChildUsage = permanentChildUsage;
        }
    }

    static class G1OverLimitStrategy
    implements OverLimitStrategy {
        private final long g1RegionSize;
        private final LongSupplier currentMemoryUsageSupplier;
        private final LongSupplier gcCountSupplier;
        private final LongSupplier timeSupplier;
        private final TimeValue lockTimeout;
        private final TimeValue fullGCLockTimeout;
        private final long maxHeap;
        private long lastCheckTime = Long.MIN_VALUE;
        private long lastFullGCTime = Long.MIN_VALUE;
        private final long minimumInterval;
        private volatile boolean performingFullGC = false;
        private final long fullGCMinimumInterval;
        private long blackHole;
        private final ReleasableLock lock = new ReleasableLock(new ReentrantLock());
        private int attemptNo;

        G1OverLimitStrategy(JvmInfo jvmInfo, LongSupplier currentMemoryUsageSupplier, LongSupplier gcCountSupplier, LongSupplier timeSupplier, long minimumInterval, long fullGCMinimumInterval, TimeValue lockTimeout, TimeValue fullGCLockTimeout) {
            this.lockTimeout = lockTimeout;
            this.fullGCLockTimeout = fullGCLockTimeout;
            assert (minimumInterval > 0L);
            this.currentMemoryUsageSupplier = currentMemoryUsageSupplier;
            this.gcCountSupplier = gcCountSupplier;
            this.timeSupplier = timeSupplier;
            this.minimumInterval = minimumInterval;
            this.fullGCMinimumInterval = fullGCMinimumInterval;
            this.maxHeap = jvmInfo.getMem().getHeapMax().getBytes();
            long g1RegionSize = jvmInfo.getG1RegionSize();
            this.g1RegionSize = g1RegionSize <= 0L ? G1OverLimitStrategy.fallbackRegionSize(jvmInfo) : g1RegionSize;
        }

        static long fallbackRegionSize(JvmInfo jvmInfo) {
            long averageHeapSize = (jvmInfo.getMem().getHeapMax().getBytes() + JvmInfo.jvmInfo().getMem().getHeapMax().getBytes()) / 2L;
            long regionSize = Long.highestOneBit(averageHeapSize / 2048L);
            if (regionSize < ByteSizeUnit.MB.toBytes(1L)) {
                regionSize = ByteSizeUnit.MB.toBytes(1L);
            } else if (regionSize > ByteSizeUnit.MB.toBytes(32L)) {
                regionSize = ByteSizeUnit.MB.toBytes(32L);
            }
            return regionSize;
        }

        @SuppressForbidden(reason="Prefer full GC to OOM or CBE")
        private static void performFullGC() {
            System.gc();
        }

        @Override
        public MemoryUsage overLimit(MemoryUsage memoryUsed) {
            long current;
            ReleasableLock locked;
            TriggerGCResult result = TriggerGCResult.EMPTY;
            int attemptNoCopy = 0;
            try {
                locked = this.lock.tryAcquire(this.lockTimeout);
                try {
                    if (locked != null) {
                        attemptNoCopy = ++this.attemptNo;
                        result = this.tryTriggerGC(memoryUsed);
                    } else {
                        logger.info("could not acquire lock within {} when attempting to trigger G1GC due to high heap usage", (Object)this.lockTimeout);
                    }
                }
                finally {
                    if (locked != null) {
                        locked.close();
                    }
                }
            }
            catch (InterruptedException e) {
                logger.info("could not acquire lock when attempting to trigger G1GC due to high heap usage");
                Thread.currentThread().interrupt();
            }
            if (this.performingFullGC && attemptNoCopy == 0) {
                logger.info("could not acquire lock within {} while another thread was performing a full GC, waiting again for {}", (Object)this.lockTimeout, (Object)this.fullGCLockTimeout);
                try {
                    locked = this.lock.tryAcquire(this.fullGCLockTimeout);
                    try {
                        if (locked != null) {
                            attemptNoCopy = ++this.attemptNo;
                            result = this.tryTriggerGC(memoryUsed);
                        } else {
                            logger.info("could not acquire lock within {} when attempting to trigger G1GC due to high heap usage", (Object)this.fullGCLockTimeout);
                        }
                    }
                    finally {
                        if (locked != null) {
                            locked.close();
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.info("could not acquire lock when attempting to trigger G1GC due to high heap usage");
                    Thread.currentThread().interrupt();
                }
            }
            if ((current = this.currentMemoryUsageSupplier.getAsLong()) < memoryUsed.baseUsage) {
                if (result.gcAttempted()) {
                    logger.info("GC did bring memory usage down, before [{}], after [{}], allocations [{}], duration [{}]", (Object)memoryUsed.baseUsage, (Object)current, (Object)result.allocationIndex(), (Object)result.allocationDuration());
                } else if (attemptNoCopy < 10 || Long.bitCount(attemptNoCopy) == 1) {
                    logger.info("memory usage down after [{}], before [{}], after [{}]", (Object)result.timeSinceLastCheck(), (Object)memoryUsed.baseUsage, (Object)current);
                }
                return new MemoryUsage(current, memoryUsed.totalUsage - memoryUsed.baseUsage + current, memoryUsed.transientChildUsage, memoryUsed.permanentChildUsage);
            }
            if (result.gcAttempted()) {
                logger.info("GC did not bring memory usage down, before [{}], after [{}], allocations [{}], duration [{}]", (Object)memoryUsed.baseUsage, (Object)current, (Object)result.allocationIndex(), (Object)result.allocationDuration());
            } else if (attemptNoCopy < 10 || Long.bitCount(attemptNoCopy) == 1) {
                logger.info("memory usage not down after [{}], before [{}], after [{}]", (Object)result.timeSinceLastCheck(), (Object)memoryUsed.baseUsage, (Object)current);
            }
            return memoryUsed;
        }

        private TriggerGCResult tryTriggerGC(MemoryUsage memoryUsed) {
            long reclaimedMemory;
            int allocationIndex;
            long begin = this.timeSupplier.getAsLong();
            boolean canPerformGC = begin >= this.lastCheckTime + this.minimumInterval;
            this.overLimitTriggered(canPerformGC);
            if (canPerformGC) {
                long current;
                long initialCollectionCount = this.gcCountSupplier.getAsLong();
                logger.info("attempting to trigger G1GC due to high heap usage [{}]", (Object)memoryUsed.baseUsage);
                long localBlackHole = 0L;
                int allocationCount = Math.toIntExact((this.maxHeap - memoryUsed.baseUsage) / this.g1RegionSize + 1L);
                int allocationSize = (int)(this.g1RegionSize >> 1);
                long maxUsageObserved = memoryUsed.baseUsage;
                for (allocationIndex = 0; allocationIndex < allocationCount && (current = this.currentMemoryUsageSupplier.getAsLong()) >= maxUsageObserved; ++allocationIndex) {
                    maxUsageObserved = current;
                    if (initialCollectionCount != this.gcCountSupplier.getAsLong()) break;
                    localBlackHole += (long)new byte[allocationSize].hashCode();
                }
                this.blackHole += localBlackHole;
                logger.trace("black hole [{}]", (Object)this.blackHole);
                this.lastCheckTime = this.timeSupplier.getAsLong();
                this.attemptNo = 0;
            }
            if ((reclaimedMemory = memoryUsed.baseUsage - this.currentMemoryUsageSupplier.getAsLong()) <= 0L) {
                boolean canPerformFullGC;
                long now = this.timeSupplier.getAsLong();
                boolean bl = canPerformFullGC = now >= this.lastFullGCTime + this.fullGCMinimumInterval;
                if (canPerformFullGC) {
                    this.performingFullGC = true;
                    logger.info("attempt to trigger young GC failed to bring memory down, triggering full GC");
                    G1OverLimitStrategy.performFullGC();
                    this.performingFullGC = false;
                    this.lastFullGCTime = this.timeSupplier.getAsLong();
                }
            }
            long allocationDuration = this.timeSupplier.getAsLong() - begin;
            return new TriggerGCResult(canPerformGC, allocationIndex, allocationDuration, begin - this.lastCheckTime);
        }

        void overLimitTriggered(boolean leader) {
        }

        TimeValue getLockTimeout() {
            return this.lockTimeout;
        }

        private record TriggerGCResult(boolean gcAttempted, int allocationIndex, long allocationDuration, long timeSinceLastCheck) {
            private static final TriggerGCResult EMPTY = new TriggerGCResult(false, 0, 0L, 0L);
        }
    }
}

