/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.indices.ESCacheHelper;

public final class IndicesRequestCache
implements Closeable {
    public static final Setting<Boolean> INDEX_CACHE_REQUEST_ENABLED_SETTING = Setting.boolSetting("index.requests.cache.enable", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE = Setting.memorySizeSetting("indices.requests.cache.size", "1%", Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_CACHE_QUERY_EXPIRE = Setting.positiveTimeSetting("indices.requests.cache.expire", new TimeValue(0L), Setting.Property.NodeScope);
    private final ConcurrentMap<CleanupKey, Boolean> registeredClosedListeners = ConcurrentCollections.newConcurrentMap();
    private final Set<CleanupKey> keysToClean = ConcurrentCollections.newConcurrentSet();
    private final Cache<Key, BytesReference> cache;

    IndicesRequestCache(Settings settings) {
        TimeValue expire = INDICES_CACHE_QUERY_EXPIRE.exists(settings) ? INDICES_CACHE_QUERY_EXPIRE.get(settings) : null;
        CacheBuilder<Key, BytesReference> cacheBuilder = CacheBuilder.builder().setMaximumWeight(INDICES_CACHE_QUERY_SIZE.get(settings).getBytes()).weigher((k, v) -> k.ramBytesUsed() + v.ramBytesUsed()).removalListener(notification -> ((Key)notification.getKey()).entity.onRemoval(notification));
        if (expire != null) {
            cacheBuilder.setExpireAfterAccess(expire);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }

    void clear(CacheEntity entity) {
        this.keysToClean.add(new CleanupKey(entity, null));
        this.cleanCache();
    }

    BytesReference getOrCompute(CacheEntity cacheEntity, CheckedSupplier<BytesReference, IOException> loader, MappingLookup.CacheKey mappingCacheKey, DirectoryReader reader, BytesReference cacheKey) throws Exception {
        ESCacheHelper cacheHelper = ElasticsearchDirectoryReader.getESReaderCacheHelper(reader);
        assert (cacheHelper != null);
        Key key = new Key(cacheEntity, mappingCacheKey, cacheHelper.getKey(), cacheKey);
        Loader cacheLoader = new Loader(cacheEntity, loader);
        BytesReference value = this.cache.computeIfAbsent(key, cacheLoader);
        if (cacheLoader.isLoaded()) {
            Boolean previous;
            key.entity.onMiss();
            CleanupKey cleanupKey = new CleanupKey(cacheEntity, cacheHelper.getKey());
            if (!this.registeredClosedListeners.containsKey(cleanupKey) && (previous = this.registeredClosedListeners.putIfAbsent(cleanupKey, Boolean.TRUE)) == null) {
                cacheHelper.addClosedListener(cleanupKey);
            }
        } else {
            key.entity.onHit();
        }
        return value;
    }

    void invalidate(CacheEntity cacheEntity, MappingLookup.CacheKey mappingCacheKey, DirectoryReader reader, BytesReference cacheKey) {
        assert (reader.getReaderCacheHelper() != null);
        this.cache.invalidate(new Key(cacheEntity, mappingCacheKey, reader.getReaderCacheHelper().getKey(), cacheKey));
    }

    synchronized void cleanCache() {
        HashSet<CleanupKey> currentKeysToClean = new HashSet<CleanupKey>();
        HashSet<Object> currentFullClean = new HashSet<Object>();
        Iterator<Object> iterator = this.keysToClean.iterator();
        while (iterator.hasNext()) {
            CleanupKey cleanupKey = iterator.next();
            iterator.remove();
            if (cleanupKey.readerCacheKey == null || !cleanupKey.entity.isOpen()) {
                currentFullClean.add(cleanupKey.entity.getCacheIdentity());
                continue;
            }
            currentKeysToClean.add(cleanupKey);
        }
        if (!currentKeysToClean.isEmpty() || !currentFullClean.isEmpty()) {
            iterator = this.cache.keys().iterator();
            while (iterator.hasNext()) {
                Key key = (Key)iterator.next();
                if (currentFullClean.contains(key.entity.getCacheIdentity())) {
                    iterator.remove();
                    continue;
                }
                if (!currentKeysToClean.contains(new CleanupKey(key.entity, key.readerCacheKey))) continue;
                iterator.remove();
            }
        }
        this.cache.refresh();
    }

    int count() {
        return this.cache.count();
    }

    Iterable<Key> cachedKeys() {
        return this.cache.keys();
    }

    int numRegisteredCloseListeners() {
        return this.registeredClosedListeners.size();
    }

    private class CleanupKey
    implements ESCacheHelper.ClosedListener {
        final CacheEntity entity;
        final Object readerCacheKey;

        private CleanupKey(CacheEntity entity, Object readerCacheKey) {
            this.entity = entity;
            this.readerCacheKey = readerCacheKey;
        }

        @Override
        public void onClose(Object cacheKey) {
            Boolean remove = (Boolean)IndicesRequestCache.this.registeredClosedListeners.remove(this);
            if (remove != null) {
                IndicesRequestCache.this.keysToClean.add(this);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CleanupKey that = (CleanupKey)o;
            if (!Objects.equals(this.readerCacheKey, that.readerCacheKey)) {
                return false;
            }
            return this.entity.getCacheIdentity().equals(that.entity.getCacheIdentity());
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + Objects.hashCode(this.readerCacheKey);
            return result;
        }
    }

    static interface CacheEntity
    extends Accountable {
        public void onCached(Key var1, BytesReference var2);

        public boolean isOpen();

        public Object getCacheIdentity();

        public void onHit();

        public void onMiss();

        public void onRemoval(RemovalNotification<Key, BytesReference> var1);
    }

    static class Key
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Key.class);
        public final CacheEntity entity;
        public final MappingLookup.CacheKey mappingCacheKey;
        public final Object readerCacheKey;
        public final BytesReference value;

        Key(CacheEntity entity, MappingLookup.CacheKey mappingCacheKey, Object readerCacheKey, BytesReference value) {
            this.entity = entity;
            this.mappingCacheKey = Objects.requireNonNull(mappingCacheKey);
            this.readerCacheKey = Objects.requireNonNull(readerCacheKey);
            this.value = value;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + this.entity.ramBytesUsed() + (long)this.value.length();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.mappingCacheKey.equals(key.mappingCacheKey)) {
                return false;
            }
            if (!this.readerCacheKey.equals(key.readerCacheKey)) {
                return false;
            }
            if (!this.entity.getCacheIdentity().equals(key.entity.getCacheIdentity())) {
                return false;
            }
            return this.value.equals(key.value);
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + this.mappingCacheKey.hashCode();
            result = 31 * result + this.readerCacheKey.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "Key(mappingKey=[" + this.mappingCacheKey + "],readerKey=[" + this.readerCacheKey + "],entityKey=[" + this.entity.getCacheIdentity() + ",value=" + this.value.toBytesRef() + ")";
        }
    }

    private static class Loader
    implements CacheLoader<Key, BytesReference> {
        private final CacheEntity entity;
        private final CheckedSupplier<BytesReference, IOException> loader;
        private boolean loaded;

        Loader(CacheEntity entity, CheckedSupplier<BytesReference, IOException> loader) {
            this.entity = entity;
            this.loader = loader;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public BytesReference load(Key key) throws Exception {
            BytesReference value = this.loader.get();
            this.entity.onCached(key, value);
            this.loaded = true;
            return value;
        }
    }
}

