/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.Counter;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;

public final class TranslogDeletionPolicy {
    private final Map<Object, RuntimeException> openTranslogRef;
    private final Map<Long, Counter> translogRefCounts = new HashMap<Long, Counter>();
    private long localCheckpointOfSafeCommit = -1L;

    public void assertNoOpenTranslogRefs() {
        if (!this.openTranslogRef.isEmpty()) {
            AssertionError e = new AssertionError((Object)"not all translog generations have been released");
            this.openTranslogRef.values().forEach(arg_0 -> e.addSuppressed(arg_0));
            throw e;
        }
    }

    public TranslogDeletionPolicy() {
        this.openTranslogRef = Assertions.ENABLED ? new ConcurrentHashMap<Object, RuntimeException>() : null;
    }

    public synchronized void setLocalCheckpointOfSafeCommit(long newCheckpoint) {
        if (newCheckpoint < this.localCheckpointOfSafeCommit) {
            throw new IllegalArgumentException("local checkpoint of the safe commit can't go backwards: current [" + this.localCheckpointOfSafeCommit + "] new [" + newCheckpoint + "]");
        }
        this.localCheckpointOfSafeCommit = newCheckpoint;
    }

    synchronized Releasable acquireTranslogGen(long translogGen) {
        this.translogRefCounts.computeIfAbsent(translogGen, l -> Counter.newCounter(false)).addAndGet(1L);
        AtomicBoolean closed = new AtomicBoolean();
        assert (this.assertAddTranslogRef(closed));
        return () -> {
            if (closed.compareAndSet(false, true)) {
                this.releaseTranslogGen(translogGen);
                assert (this.assertRemoveTranslogRef(closed));
            }
        };
    }

    private boolean assertAddTranslogRef(Object reference) {
        RuntimeException existing = this.openTranslogRef.put(reference, new RuntimeException());
        if (existing != null) {
            throw new AssertionError("double adding of closing reference", existing);
        }
        return true;
    }

    private boolean assertRemoveTranslogRef(Object reference) {
        return this.openTranslogRef.remove(reference) != null;
    }

    synchronized int pendingTranslogRefCount() {
        return this.translogRefCounts.size();
    }

    private synchronized void releaseTranslogGen(long translogGen) {
        Counter current = this.translogRefCounts.get(translogGen);
        if (current == null || current.get() <= 0L) {
            throw new IllegalArgumentException("translog gen [" + translogGen + "] wasn't acquired");
        }
        if (current.addAndGet(-1L) == 0L) {
            this.translogRefCounts.remove(translogGen);
        }
    }

    synchronized long getMinTranslogGenRequiredByLocks() {
        return this.translogRefCounts.keySet().stream().reduce(Math::min).orElse(Long.MAX_VALUE);
    }

    public synchronized long getLocalCheckpointOfSafeCommit() {
        return this.localCheckpointOfSafeCommit;
    }

    synchronized long getTranslogRefCount(long gen) {
        Counter counter = this.translogRefCounts.get(gen);
        return counter == null ? 0L : counter.get();
    }
}

