/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.plugins.IndexStorePlugin;

public class FsDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    private static final FeatureFlag MADV_RANDOM_FEATURE_FLAG = new FeatureFlag("madv_random");
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s -> switch (s) {
        case "native" -> NativeFSLockFactory.INSTANCE;
        case "simple" -> SimpleFSLockFactory.INSTANCE;
        default -> throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s + "\": must be native or simple");
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        Path location = path.resolveIndex();
        LockFactory lockFactory = indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        return this.newFSDirectory(location, lockFactory, indexSettings);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory, IndexSettings indexSettings) throws IOException {
        String storeType = indexSettings.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.FS.getSettingsKey());
        IndexModule.Type type = IndexModule.Type.FS.match(storeType) ? IndexModule.defaultStoreType(IndexModule.NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings())) : IndexModule.Type.fromSettingsKey(storeType);
        HashSet<String> preLoadExtensions = new HashSet<String>((Collection)indexSettings.getValue(IndexModule.INDEX_STORE_PRE_LOAD_SETTING));
        switch (type) {
            case HYBRIDFS: {
                FSDirectory primaryDirectory = FSDirectory.open(location, lockFactory);
                if (primaryDirectory instanceof MMapDirectory) {
                    MMapDirectory mMapDirectory = (MMapDirectory)primaryDirectory;
                    Directory dir = new HybridDirectory(lockFactory, FsDirectoryFactory.setPreload(mMapDirectory, lockFactory, preLoadExtensions));
                    if (!MADV_RANDOM_FEATURE_FLAG.isEnabled()) {
                        dir = FsDirectoryFactory.disableRandomAdvice(dir);
                    }
                    return dir;
                }
                return primaryDirectory;
            }
            case MMAPFS: {
                Directory dir = FsDirectoryFactory.setPreload(new MMapDirectory(location, lockFactory), lockFactory, preLoadExtensions);
                if (!MADV_RANDOM_FEATURE_FLAG.isEnabled()) {
                    dir = FsDirectoryFactory.disableRandomAdvice(dir);
                }
                return dir;
            }
            case SIMPLEFS: 
            case NIOFS: {
                return new NIOFSDirectory(location, lockFactory);
            }
        }
        throw new AssertionError((Object)("unexpected built-in store type [" + type + "]"));
    }

    public static MMapDirectory setPreload(MMapDirectory mMapDirectory, LockFactory lockFactory, Set<String> preLoadExtensions) throws IOException {
        assert (!mMapDirectory.getPreload());
        if (!preLoadExtensions.isEmpty()) {
            if (preLoadExtensions.contains("*")) {
                mMapDirectory.setPreload(true);
            } else {
                return new PreLoadMMapDirectory(mMapDirectory, lockFactory, preLoadExtensions);
            }
        }
        return mMapDirectory;
    }

    static Directory disableRandomAdvice(Directory dir) {
        return new FilterDirectory(dir){

            @Override
            public IndexInput openInput(String name, IOContext context) throws IOException {
                if (context.randomAccess) {
                    context = IOContext.READ;
                }
                assert (!context.randomAccess);
                return super.openInput(name, context);
            }
        };
    }

    public static boolean isHybridFs(Directory directory) {
        Directory unwrap = FilterDirectory.unwrap(directory);
        return unwrap instanceof HybridDirectory;
    }

    static final class HybridDirectory
    extends NIOFSDirectory {
        private final MMapDirectory delegate;

        HybridDirectory(LockFactory lockFactory, MMapDirectory delegate) throws IOException {
            super(delegate.getDirectory(), lockFactory);
            this.delegate = delegate;
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (HybridDirectory.useDelegate(name, context)) {
                this.ensureOpen();
                this.ensureCanRead(name);
                return this.delegate.openInput(name, context);
            }
            return super.openInput(name, context);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(() -> super.close(), this.delegate);
        }

        private static String getExtension(String name) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return "";
            }
            return name.substring(lastDotIndex + 1);
        }

        static boolean useDelegate(String name, IOContext ioContext) {
            if (ioContext == Store.READONCE_CHECKSUM) {
                return false;
            }
            LuceneFilesExtensions extension = LuceneFilesExtensions.fromExtension(HybridDirectory.getExtension(name));
            return extension != null && extension.shouldMmap();
        }

        MMapDirectory getDelegate() {
            return this.delegate;
        }
    }

    static final class PreLoadMMapDirectory
    extends MMapDirectory {
        private final MMapDirectory delegate;
        private final Set<String> preloadExtensions;

        PreLoadMMapDirectory(MMapDirectory delegate, LockFactory lockFactory, Set<String> preload) throws IOException {
            super(delegate.getDirectory(), lockFactory);
            super.setPreload(false);
            this.delegate = delegate;
            this.delegate.setPreload(true);
            this.preloadExtensions = preload;
            assert (!this.getPreload());
        }

        @Override
        public void setPreload(boolean preload) {
            throw new IllegalArgumentException("can't set preload on a preload-wrapper");
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (this.useDelegate(name)) {
                this.ensureOpen();
                this.ensureCanRead(name);
                return this.delegate.openInput(name, context);
            }
            return super.openInput(name, context);
        }

        @Override
        public synchronized void close() throws IOException {
            IOUtils.close(() -> super.close(), this.delegate);
        }

        boolean useDelegate(String name) {
            String extension = FileSwitchDirectory.getExtension(name);
            return this.preloadExtensions.contains(extension);
        }

        MMapDirectory getDelegate() {
            return this.delegate;
        }
    }
}

