/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.ZeroTermsQueryOption;
import org.elasticsearch.index.search.MultiMatchQueryParser;
import org.elasticsearch.index.search.QueryParserHelper;

public class SimpleQueryStringQueryParser
extends SimpleQueryParser {
    private final Settings settings;
    private SearchExecutionContext context;
    private final MultiMatchQueryParser queryBuilder;
    private MultiMatchQueryBuilder.Type type = MultiMatchQueryBuilder.Type.MOST_FIELDS;

    public SimpleQueryStringQueryParser(Map<String, Float> weights, int flags, Settings settings, SearchExecutionContext context) {
        this(null, weights, flags, settings, context);
    }

    public SimpleQueryStringQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags, Settings settings, SearchExecutionContext context) {
        super(analyzer, weights, flags);
        this.settings = settings;
        this.context = context;
        this.queryBuilder = new MultiMatchQueryParser(context);
        this.queryBuilder.setAutoGenerateSynonymsPhraseQuery(settings.autoGenerateSynonymsPhraseQuery());
        this.queryBuilder.setLenient(settings.lenient());
        this.queryBuilder.setZeroTermsQuery(ZeroTermsQueryOption.NULL);
        if (analyzer != null) {
            this.queryBuilder.setAnalyzer(analyzer);
        }
    }

    private Analyzer getAnalyzer(MappedFieldType ft) {
        if (this.getAnalyzer() != null) {
            return this.analyzer;
        }
        return ft.getTextSearchInfo().searchAnalyzer();
    }

    private Query rethrowUnlessLenient(RuntimeException e) {
        if (this.settings.lenient()) {
            return Queries.newMatchNoDocsQuery("failed query, caused by " + e.getMessage());
        }
        throw e;
    }

    public void setDefaultOperator(BooleanClause.Occur operator) {
        super.setDefaultOperator(operator);
        this.queryBuilder.setOccur(operator);
    }

    protected Query newTermQuery(Term term, float boost) {
        MappedFieldType ft = this.context.getFieldType(term.field());
        if (ft == null) {
            return Queries.newUnmappedFieldQuery(term.field());
        }
        return ft.termQuery(term.bytes(), this.context);
    }

    public Query newDefaultQuery(String text) {
        try {
            return this.queryBuilder.parse(this.type, this.weights, text, null);
        }
        catch (IOException e) {
            return this.rethrowUnlessLenient(new IllegalStateException(e.getMessage()));
        }
    }

    public void setType(MultiMatchQueryBuilder.Type type) {
        this.type = type;
    }

    public Query newFuzzyQuery(String text, int fuzziness) {
        ArrayList<Query> disjuncts = new ArrayList<Query>();
        for (Map.Entry entry : this.weights.entrySet()) {
            String fieldName = (String)entry.getKey();
            MappedFieldType ft = this.context.getFieldType(fieldName);
            if (ft == null) {
                disjuncts.add(Queries.newUnmappedFieldQuery(fieldName));
                continue;
            }
            try {
                BytesRef term = this.getAnalyzer(ft).normalize(fieldName, text);
                Query query = ft.fuzzyQuery(term, Fuzziness.fromEdits(fuzziness), this.settings.fuzzyPrefixLength, this.settings.fuzzyMaxExpansions, this.settings.fuzzyTranspositions, this.context);
                disjuncts.add(SimpleQueryStringQueryParser.wrapWithBoost(query, ((Float)entry.getValue()).floatValue()));
            }
            catch (RuntimeException e) {
                disjuncts.add(this.rethrowUnlessLenient(e));
            }
        }
        if (disjuncts.size() == 1) {
            return (Query)disjuncts.get(0);
        }
        return new DisjunctionMaxQuery(disjuncts, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query newPhraseQuery(String text, int slop) {
        try {
            this.queryBuilder.setPhraseSlop(slop);
            Map<String, Float> phraseWeights = this.settings.quoteFieldSuffix() != null ? QueryParserHelper.resolveMappingFields(this.context, this.weights, this.settings.quoteFieldSuffix()) : this.weights;
            Query query = this.queryBuilder.parse(MultiMatchQueryBuilder.Type.PHRASE, phraseWeights, text, null);
            return query;
        }
        catch (IOException e) {
            Query query = this.rethrowUnlessLenient(new IllegalStateException(e.getMessage()));
            return query;
        }
        finally {
            this.queryBuilder.setPhraseSlop(0);
        }
    }

    public Query newPrefixQuery(String text) {
        ArrayList<Query> disjuncts = new ArrayList<Query>();
        for (Map.Entry entry : this.weights.entrySet()) {
            String fieldName = (String)entry.getKey();
            MappedFieldType ft = this.context.getFieldType(fieldName);
            if (ft == null) {
                disjuncts.add(Queries.newUnmappedFieldQuery(fieldName));
                continue;
            }
            try {
                if (this.settings.analyzeWildcard()) {
                    Query analyzedQuery = this.newPossiblyAnalyzedQuery(fieldName, text, this.getAnalyzer(ft));
                    if (analyzedQuery == null) continue;
                    disjuncts.add(SimpleQueryStringQueryParser.wrapWithBoost(analyzedQuery, ((Float)entry.getValue()).floatValue()));
                    continue;
                }
                BytesRef term = this.getAnalyzer(ft).normalize(fieldName, text);
                Query query = ft.prefixQuery(term.utf8ToString(), null, this.context);
                disjuncts.add(SimpleQueryStringQueryParser.wrapWithBoost(query, ((Float)entry.getValue()).floatValue()));
            }
            catch (RuntimeException e) {
                disjuncts.add(this.rethrowUnlessLenient(e));
            }
        }
        if (disjuncts.size() == 1) {
            return (Query)disjuncts.get(0);
        }
        return new DisjunctionMaxQuery(disjuncts, 1.0f);
    }

    private static Query wrapWithBoost(Query query, float boost) {
        if (query instanceof MatchNoDocsQuery) {
            return query;
        }
        if (boost != 1.0f) {
            return new BoostQuery(query, boost);
        }
        return query;
    }

    private Query newPossiblyAnalyzedQuery(String field, String termStr, Analyzer analyzer) {
        ArrayList tlist = new ArrayList();
        try (TokenStream source = analyzer.tokenStream(field, termStr);){
            source.reset();
            ArrayList<BytesRef> currentPos = new ArrayList<BytesRef>();
            CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posAtt = source.addAttribute(PositionIncrementAttribute.class);
            try {
                boolean hasMoreTokens = source.incrementToken();
                while (hasMoreTokens) {
                    if (!currentPos.isEmpty() && posAtt.getPositionIncrement() > 0) {
                        tlist.add(currentPos);
                        currentPos = new ArrayList();
                    }
                    BytesRef term = analyzer.normalize(field, termAtt.toString());
                    currentPos.add(term);
                    hasMoreTokens = source.incrementToken();
                }
                if (!currentPos.isEmpty()) {
                    tlist.add(currentPos);
                }
            }
            catch (IOException hasMoreTokens) {
                // empty catch block
            }
        }
        catch (IOException e) {
            return new PrefixQuery(new Term(field, termStr));
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1 && ((List)tlist.get(0)).size() == 1) {
            return new PrefixQuery(new Term(field, (BytesRef)((List)tlist.get(0)).get(0)));
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (int pos = 0; pos < tlist.size(); ++pos) {
            Query posQuery;
            boolean isLastPos;
            List plist = (List)tlist.get(pos);
            boolean bl = isLastPos = pos == tlist.size() - 1;
            if (plist.size() == 1) {
                posQuery = isLastPos ? new PrefixQuery(new Term(field, (BytesRef)plist.get(0))) : this.newTermQuery(new Term(field, (BytesRef)plist.get(0)), 1.0f);
            } else if (!isLastPos) {
                SynonymQuery.Builder sb = new SynonymQuery.Builder(field);
                for (BytesRef bytesRef : plist) {
                    sb.addTerm(new Term(field, bytesRef));
                }
                posQuery = sb.build();
            } else {
                BooleanQuery.Builder innerBuilder = new BooleanQuery.Builder();
                for (BytesRef token : plist) {
                    innerBuilder.add(new BooleanClause(new PrefixQuery(new Term(field, token)), BooleanClause.Occur.SHOULD));
                }
                posQuery = innerBuilder.build();
            }
            builder.add(new BooleanClause(posQuery, this.getDefaultOperator()));
        }
        return builder.build();
    }

    public static class Settings {
        private boolean lenient = false;
        private boolean analyzeWildcard = false;
        private String quoteFieldSuffix = null;
        private boolean autoGenerateSynonymsPhraseQuery = true;
        private int fuzzyPrefixLength = 0;
        private int fuzzyMaxExpansions = 50;
        private boolean fuzzyTranspositions = true;

        public Settings() {
        }

        public Settings(Settings other) {
            this.lenient = other.lenient;
            this.analyzeWildcard = other.analyzeWildcard;
            this.quoteFieldSuffix = other.quoteFieldSuffix;
            this.autoGenerateSynonymsPhraseQuery = other.autoGenerateSynonymsPhraseQuery;
            this.fuzzyPrefixLength = other.fuzzyPrefixLength;
            this.fuzzyMaxExpansions = other.fuzzyMaxExpansions;
            this.fuzzyTranspositions = other.fuzzyTranspositions;
        }

        public void lenient(boolean lenient) {
            this.lenient = lenient;
        }

        public boolean lenient() {
            return this.lenient;
        }

        public void analyzeWildcard(boolean analyzeWildcard) {
            this.analyzeWildcard = analyzeWildcard;
        }

        public boolean analyzeWildcard() {
            return this.analyzeWildcard;
        }

        public void quoteFieldSuffix(String suffix) {
            this.quoteFieldSuffix = suffix;
        }

        public String quoteFieldSuffix() {
            return this.quoteFieldSuffix;
        }

        public void autoGenerateSynonymsPhraseQuery(boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
        }

        public boolean autoGenerateSynonymsPhraseQuery() {
            return this.autoGenerateSynonymsPhraseQuery;
        }

        public int fuzzyPrefixLength() {
            return this.fuzzyPrefixLength;
        }

        public void fuzzyPrefixLength(int fuzzyPrefixLength) {
            this.fuzzyPrefixLength = fuzzyPrefixLength;
        }

        public int fuzzyMaxExpansions() {
            return this.fuzzyMaxExpansions;
        }

        public void fuzzyMaxExpansions(int fuzzyMaxExpansions) {
            this.fuzzyMaxExpansions = fuzzyMaxExpansions;
        }

        public boolean fuzzyTranspositions() {
            return this.fuzzyTranspositions;
        }

        public void fuzzyTranspositions(boolean fuzzyTranspositions) {
            this.fuzzyTranspositions = fuzzyTranspositions;
        }

        public int hashCode() {
            return Objects.hash(this.lenient, this.analyzeWildcard, this.quoteFieldSuffix, this.autoGenerateSynonymsPhraseQuery, this.fuzzyPrefixLength, this.fuzzyMaxExpansions, this.fuzzyTranspositions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Settings other = (Settings)obj;
            return Objects.equals(this.lenient, other.lenient) && Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.quoteFieldSuffix, other.quoteFieldSuffix) && Objects.equals(this.autoGenerateSynonymsPhraseQuery, other.autoGenerateSynonymsPhraseQuery) && Objects.equals(this.fuzzyPrefixLength, other.fuzzyPrefixLength) && Objects.equals(this.fuzzyMaxExpansions, other.fuzzyMaxExpansions) && Objects.equals(this.fuzzyTranspositions, other.fuzzyTranspositions);
        }
    }
}

