/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.VersionDocValuesField;

public class VersionFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_version";
    public static final String CONTENT_TYPE = "_version";
    public static final VersionFieldMapper INSTANCE = new VersionFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> INSTANCE);

    private VersionFieldMapper() {
        super(VersionFieldType.INSTANCE);
    }

    @Override
    public void preParse(DocumentParserContext context) {
        Field version = VersionFieldMapper.versionField();
        context.version(version);
        context.doc().add(version);
    }

    public static Field versionField() {
        return new NumericDocValuesField("_version", -1L);
    }

    @Override
    public void postParse(DocumentParserContext context) {
        Field version = context.version();
        assert (version != null);
        for (LuceneDocument doc : context.nonRootDocuments()) {
            doc.add(version);
        }
    }

    @Override
    protected String contentType() {
        return "_version";
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    static final class VersionFieldType
    extends MappedFieldType {
        public static final VersionFieldType INSTANCE = new VersionFieldType();

        private VersionFieldType() {
            super("_version", false, false, true, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_version";
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "The _version field is not searchable", new Object[0]);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this, MappedFieldType.FielddataOperation.SEARCH));
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            return new BlockDocValuesReader.LongsBlockLoader(this.name());
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG, VersionDocValuesField::new, this.isIndexed());
        }
    }
}

