/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class NestedPathFieldMapper
extends MetadataFieldMapper {
    public static final String NAME_PRE_V8 = "_type";
    public static final String NAME = "_nested_path";
    private static final NestedPathFieldMapper INSTANCE = new NestedPathFieldMapper("_nested_path");
    private static final NestedPathFieldMapper INSTANCE_PRE_V8 = new NestedPathFieldMapper("_type");
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> c.indexVersionCreated().before(IndexVersions.V_8_0_0) ? INSTANCE_PRE_V8 : INSTANCE);

    public static String name(IndexVersion version) {
        if (version.before(IndexVersions.V_8_0_0)) {
            return NAME_PRE_V8;
        }
        return NAME;
    }

    public static Query filter(IndexVersion version, String path) {
        return new TermQuery(new Term(NestedPathFieldMapper.name(version), new BytesRef(path)));
    }

    public static Field field(IndexVersion version, String path) {
        return new StringField(NestedPathFieldMapper.name(version), path, Field.Store.NO);
    }

    private NestedPathFieldMapper(String name) {
        super(new NestedPathFieldType(name));
    }

    @Override
    protected String contentType() {
        return NAME;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    public static final class NestedPathFieldType
    extends StringFieldType {
        private NestedPathFieldType(String name) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return NestedPathFieldMapper.NAME;
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new UnsupportedOperationException("Cannot run exists() query against the nested field path");
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return false;
        }
    }
}

