/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class MetadataFieldMapper
extends FieldMapper {
    public static FieldMapper.Parameter<Explicit<Boolean>> updateableBoolParam(String name, Function<FieldMapper, Explicit<Boolean>> initializer, boolean defaultValue) {
        return new FieldMapper.Parameter<Explicit<Boolean>>(name, true, defaultValue ? () -> Explicit.IMPLICIT_TRUE : () -> Explicit.IMPLICIT_FALSE, (n, c, o) -> Explicit.explicitBoolean(XContentMapValues.nodeBooleanValue(o)), initializer, (b, n, v) -> b.field(n, (Boolean)v.value()), v -> Boolean.toString((Boolean)v.value()));
    }

    protected MetadataFieldMapper(MappedFieldType mappedFieldType) {
        super(mappedFieldType.name(), mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty(), false, null);
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return null;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder mergeBuilder = (Builder)this.getMergeBuilder();
        if (mergeBuilder == null || !mergeBuilder.isConfigured()) {
            return builder;
        }
        builder.startObject(this.leafName());
        this.getMergeBuilder().toXContent(builder, params);
        return builder.endObject();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        throw new DocumentParsingException(context.parser().getTokenLocation(), "Field [" + this.fullPath() + "] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
    }

    public void preParse(DocumentParserContext context) throws IOException {
    }

    public void postParse(DocumentParserContext context) throws IOException {
    }

    @Override
    protected FieldMapper.SyntheticSourceMode syntheticSourceMode() {
        return FieldMapper.SyntheticSourceMode.NATIVE;
    }

    @Override
    public abstract SourceLoader.SyntheticFieldLoader syntheticFieldLoader();

    public static abstract class Builder
    extends FieldMapper.Builder {
        private static final Set<String> UNSUPPORTED_PARAMETERS_8_6_0 = Set.of("type", "fields", "copy_to", "boost");

        protected Builder(String name) {
            super(name);
        }

        boolean isConfigured() {
            for (FieldMapper.Parameter<?> param : this.getParameters()) {
                if (!param.isConfigured()) continue;
                return true;
            }
            return false;
        }

        @Override
        public final MetadataFieldMapper build(MapperBuilderContext context) {
            return this.build();
        }

        public final void parseMetadataField(String name, MappingParserContext parserContext, Map<String, Object> fieldNode) {
            FieldMapper.Parameter<?>[] params = this.getParameters();
            Map<String, FieldMapper.Parameter<?>> paramsMap = Maps.newHashMapWithExpectedSize(params.length);
            for (FieldMapper.Parameter<?> param : params) {
                paramsMap.put(param.name, param);
            }
            Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                FieldMapper.Parameter parameter = (FieldMapper.Parameter)paramsMap.get(propName);
                if (parameter == null) {
                    if (UNSUPPORTED_PARAMETERS_8_6_0.contains(propName)) {
                        if (parserContext.indexVersionCreated().onOrAfter(IndexVersions.V_8_6_0)) {
                            FieldMapper.deprecationLogger.warn(DeprecationCategory.API, propName, "Parameter [{}] has no effect on metadata field [{}] and will be removed in future", propName, name);
                        }
                        iterator.remove();
                        continue;
                    }
                    throw new MapperParsingException("unknown parameter [" + propName + "] on metadata field [" + name + "]");
                }
                parameter.parse(name, parserContext, propNode);
                iterator.remove();
            }
            this.validate();
        }

        public abstract MetadataFieldMapper build();
    }

    public static class ConfigurableTypeParser
    implements TypeParser {
        final Function<MappingParserContext, MetadataFieldMapper> defaultMapperParser;
        final Function<MappingParserContext, Builder> builderFunction;

        public ConfigurableTypeParser(Function<MappingParserContext, MetadataFieldMapper> defaultMapperParser, Function<MappingParserContext, Builder> builderFunction) {
            this.defaultMapperParser = defaultMapperParser;
            this.builderFunction = builderFunction;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(parserContext);
            builder.parseMetadataField(name, parserContext, node);
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappingParserContext parserContext) {
            return this.defaultMapperParser.apply(parserContext);
        }
    }

    public static class FixedTypeParser
    implements TypeParser {
        final Function<MappingParserContext, MetadataFieldMapper> mapperParser;

        public FixedTypeParser(Function<MappingParserContext, MetadataFieldMapper> mapperParser) {
            this.mapperParser = mapperParser;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException(name + " is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappingParserContext parserContext) {
            return this.mapperParser.apply(parserContext);
        }
    }

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, MappingParserContext var3) throws MapperParsingException;

        public MetadataFieldMapper getDefault(MappingParserContext var1);
    }
}

