/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class BinaryDocValuesSyntheticFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private final String name;
    private BinaryDocValues values;
    private boolean hasValue;

    protected BinaryDocValuesSyntheticFieldLoader(String name) {
        this.name = name;
    }

    protected abstract void writeValue(XContentBuilder var1, BytesRef var2) throws IOException;

    @Override
    public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        return Stream.of(new Map.Entry[0]);
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        this.values = leafReader.getBinaryDocValues(this.name);
        if (this.values == null) {
            return null;
        }
        return docId -> {
            this.hasValue = this.values.advanceExact(docId);
            return this.hasValue;
        };
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        if (!this.hasValue) {
            return;
        }
        this.writeValue(b, this.values.binaryValue());
    }

    @Override
    public String fieldName() {
        return this.name;
    }
}

