/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.script.field.ToScriptFieldFactory;

public class PagedBytesLeafFieldData
extends AbstractLeafOrdinalsFieldData {
    private final PagedBytes.Reader bytes;
    private final PackedLongValues termOrdToBytesOffset;
    protected final Ordinals ordinals;

    public PagedBytesLeafFieldData(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset, Ordinals ordinals, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) {
        super(toScriptFieldFactory);
        this.bytes = bytes;
        this.termOrdToBytesOffset = termOrdToBytesOffset;
        this.ordinals = ordinals;
    }

    @Override
    public void close() {
    }

    @Override
    public long ramBytesUsed() {
        long size = this.ordinals.ramBytesUsed();
        size += this.bytes.ramBytesUsed();
        return size += this.termOrdToBytesOffset.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return List.of(Accountables.namedAccountable("ordinals", this.ordinals), Accountables.namedAccountable("term bytes", this.bytes), Accountables.namedAccountable("term offsets", this.termOrdToBytesOffset));
    }

    @Override
    public SortedSetDocValues getOrdinalsValues() {
        return this.ordinals.ordinals(new ValuesHolder(this.bytes, this.termOrdToBytesOffset));
    }

    private static class ValuesHolder
    implements Ordinals.ValuesHolder {
        private final BytesRef scratch = new BytesRef();
        private final PagedBytes.Reader bytes;
        private final PackedLongValues termOrdToBytesOffset;

        ValuesHolder(PagedBytes.Reader bytes, PackedLongValues termOrdToBytesOffset) {
            this.bytes = bytes;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            assert (ord >= 0L);
            this.bytes.fill(this.scratch, this.termOrdToBytesOffset.get(ord));
            return this.scratch;
        }
    }
}

