/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

public class SourceValueFetcherSortedBooleanIndexFieldData
extends SourceValueFetcherIndexFieldData<SortedNumericDocValues> {
    protected SourceValueFetcherSortedBooleanIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
    }

    @Override
    public SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedNumericDocValues> loadDirect(LeafReaderContext context) throws Exception {
        return new SourceValueFetcherSortedBooleanLeafFieldData(this.toScriptFieldFactory, context, this.valueFetcher, this.sourceProvider);
    }

    private static class SourceValueFetcherSortedBooleanLeafFieldData
    extends SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedNumericDocValues> {
        private SourceValueFetcherSortedBooleanLeafFieldData(ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory, LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            super(toScriptFieldFactory, leafReaderContext, valueFetcher, sourceProvider);
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(new SourceValueFetcherSortedBooleanDocValues(this.leafReaderContext, this.valueFetcher, this.sourceProvider), name);
        }
    }

    static class SourceValueFetcherSortedBooleanDocValues
    extends SortedNumericDocValues
    implements SourceValueFetcherIndexFieldData.ValueFetcherDocValues {
        private final LeafReaderContext leafReaderContext;
        private final ValueFetcher valueFetcher;
        private final SourceProvider sourceProvider;
        private int trueCount;
        private int falseCount;
        private int iteratorIndex;

        SourceValueFetcherSortedBooleanDocValues(LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            this.leafReaderContext = leafReaderContext;
            this.valueFetcher = valueFetcher;
            this.sourceProvider = sourceProvider;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            this.trueCount = 0;
            this.falseCount = 0;
            Source source = this.sourceProvider.getSource(this.leafReaderContext, doc);
            for (Object value : this.valueFetcher.fetchValues(source, doc, Collections.emptyList())) {
                assert (value instanceof Boolean);
                if (((Boolean)value).booleanValue()) {
                    ++this.trueCount;
                    continue;
                }
                ++this.falseCount;
            }
            this.iteratorIndex = 0;
            return this.trueCount + this.falseCount > 0;
        }

        @Override
        public int docValueCount() {
            return this.trueCount + this.falseCount;
        }

        @Override
        public long nextValue() throws IOException {
            assert (this.iteratorIndex < this.trueCount + this.falseCount);
            return this.iteratorIndex++ < this.falseCount ? 0L : 1L;
        }

        @Override
        public int docID() {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        @Override
        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException("not supported for source fallback");
        }
    }

    public static class Builder
    extends SourceValueFetcherIndexFieldData.Builder<SortedNumericDocValues> {
        public Builder(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
        }

        public SourceValueFetcherSortedBooleanIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SourceValueFetcherSortedBooleanIndexFieldData(this.fieldName, this.valuesSourceType, this.valueFetcher, this.sourceProvider, this.toScriptFieldFactory);
        }
    }
}

