/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.engine.CompletionStatsCache;
import org.elasticsearch.index.engine.ElasticsearchReaderManager;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.LazySoftDeletesDirectoryReaderWrapper;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.ESCacheHelper;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.transport.Transports;

public class ReadOnlyEngine
extends Engine {
    public static final String FIELD_RANGE_SEARCH_SOURCE = "field_range";
    private final SegmentInfos lastCommittedSegmentInfos;
    private final SeqNoStats seqNoStats;
    private final ElasticsearchReaderManager readerManager;
    private final IndexCommit indexCommit;
    private final Lock indexWriterLock;
    private final SafeCommitInfo safeCommitInfo;
    private final CompletionStatsCache completionStatsCache;
    private final boolean requireCompleteHistory;
    final boolean lazilyLoadSoftDeletes;
    protected volatile TranslogStats translogStats;
    private final String commitId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadOnlyEngine(EngineConfig config, SeqNoStats seqNoStats, TranslogStats translogStats, boolean obtainLock, Function<DirectoryReader, DirectoryReader> readerWrapperFunction, boolean requireCompleteHistory, boolean lazilyLoadSoftDeletes) {
        super(config);
        this.requireCompleteHistory = requireCompleteHistory;
        try {
            Store store = config.getStore();
            store.incRef();
            ElasticsearchDirectoryReader reader = null;
            Directory directory = store.directory();
            Lock indexWriterLock = null;
            boolean success = false;
            try {
                indexWriterLock = obtainLock ? directory.obtainLock("write.lock") : null;
                this.lastCommittedSegmentInfos = Lucene.readSegmentInfos(directory);
                this.commitId = ReadOnlyEngine.generateSearcherId(this.lastCommittedSegmentInfos);
                if (seqNoStats == null) {
                    seqNoStats = ReadOnlyEngine.buildSeqNoStats(config, this.lastCommittedSegmentInfos);
                    this.ensureMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats);
                }
                this.seqNoStats = seqNoStats;
                this.indexCommit = Lucene.getIndexCommit(this.lastCommittedSegmentInfos, directory);
                this.lazilyLoadSoftDeletes = lazilyLoadSoftDeletes;
                reader = this.wrapReader(this.open(this.indexCommit), readerWrapperFunction, null);
                this.readerManager = new ElasticsearchReaderManager(reader);
                assert (translogStats != null || obtainLock) : "mutiple translogs instances should not be opened at the same time";
                this.translogStats = translogStats != null ? translogStats : ReadOnlyEngine.translogStats(config, this.lastCommittedSegmentInfos);
                this.indexWriterLock = indexWriterLock;
                this.safeCommitInfo = new SafeCommitInfo(seqNoStats.getLocalCheckpoint(), this.lastCommittedSegmentInfos.totalMaxDoc());
                this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = reader;
                closeableArray[1] = indexWriterLock;
                closeableArray[2] = store::decRef;
                IOUtils.close(closeableArray);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static String generateSearcherId(SegmentInfos sis) {
        MessageDigest md = MessageDigests.sha256();
        for (SegmentCommitInfo si : sis) {
            byte[] segmentId = si.getId();
            if (segmentId != null) {
                md.update(segmentId);
                continue;
            }
            return null;
        }
        return MessageDigests.toHexString(md.digest());
    }

    protected void ensureMaxSeqNoEqualsToGlobalCheckpoint(SeqNoStats seqNoStats) {
        if (!this.requireCompleteHistory) {
            return;
        }
        IndexVersion indexVersionCreated = this.engineConfig.getIndexSettings().getIndexVersionCreated();
        if (indexVersionCreated.onOrAfter(IndexVersions.V_7_2_0) || seqNoStats.getGlobalCheckpoint() != -2L) {
            assert (this.assertMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats.getMaxSeqNo(), seqNoStats.getGlobalCheckpoint()));
            if (seqNoStats.getMaxSeqNo() != seqNoStats.getGlobalCheckpoint()) {
                throw new IllegalStateException("Maximum sequence number [" + seqNoStats.getMaxSeqNo() + "] from last commit does not match global checkpoint [" + seqNoStats.getGlobalCheckpoint() + "]");
            }
        }
    }

    protected boolean assertMaxSeqNoEqualsToGlobalCheckpoint(long maxSeqNo, long globalCheckpoint) {
        assert (maxSeqNo == globalCheckpoint) : "max seq. no. [" + maxSeqNo + "] does not match [" + globalCheckpoint + "]";
        return true;
    }

    @Override
    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
    }

    protected final ElasticsearchDirectoryReader wrapReader(DirectoryReader reader, Function<DirectoryReader, DirectoryReader> readerWrapperFunction, @Nullable ESCacheHelper esCacheHelper) throws IOException {
        reader = readerWrapperFunction.apply(reader);
        return ElasticsearchDirectoryReader.wrap(reader, this.engineConfig.getShardId(), esCacheHelper);
    }

    protected DirectoryReader open(IndexCommit commit) throws IOException {
        assert (Transports.assertNotTransportThread("opening index commit of a read-only engine"));
        DirectoryReader directoryReader = DirectoryReader.open(commit, Version.MIN_SUPPORTED_MAJOR, this.engineConfig.getLeafSorter());
        if (this.lazilyLoadSoftDeletes) {
            return new LazySoftDeletesDirectoryReaderWrapper(directoryReader, "__soft_deletes");
        }
        return new SoftDeletesDirectoryReaderWrapper(directoryReader, "__soft_deletes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = this.readerManager;
                closeableArray[1] = this.indexWriterLock;
                closeableArray[2] = this.store::decRef;
                IOUtils.close(closeableArray);
            }
            catch (Exception ex) {
                this.logger.warn("failed to close reader", (Throwable)ex);
            }
            finally {
                closedLatch.countDown();
            }
        }
    }

    private static SeqNoStats buildSeqNoStats(EngineConfig config, SegmentInfos infos) {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(infos.userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        return new SeqNoStats(maxSeqNo, localCheckpoint, config.getGlobalCheckpointSupplier().getAsLong());
    }

    private static TranslogStats translogStats(EngineConfig config, SegmentInfos infos) throws IOException {
        String translogUuid = infos.getUserData().get("translog_uuid");
        if (translogUuid == null) {
            throw new IllegalStateException("commit doesn't contain translog unique id");
        }
        TranslogConfig translogConfig = config.getTranslogConfig();
        TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy();
        long localCheckpoint = Long.parseLong(infos.getUserData().get("local_checkpoint"));
        translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpoint);
        try (Translog translog = new Translog(translogConfig, translogUuid, translogDeletionPolicy, config.getGlobalCheckpointSupplier(), config.getPrimaryTermSupplier(), seqNo -> {});){
            TranslogStats translogStats = translog.stats();
            return translogStats;
        }
    }

    @Override
    public Engine.GetResult get(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) {
        return this.getFromSearcher(get, this.acquireSearcher("get", Engine.SearcherScope.EXTERNAL, searcherWrapper), false);
    }

    @Override
    protected ReferenceManager<ElasticsearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return this.readerManager;
    }

    @Override
    public SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    public String getHistoryUUID() {
        return this.lastCommittedSegmentInfos.userData.get("history_uuid");
    }

    @Override
    public long getWritingBytes() {
        return 0L;
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    @Override
    public boolean isThrottled() {
        return false;
    }

    @Override
    public Engine.IndexResult index(Engine.Index index) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("indexing is not supported on a read-only engine");
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("deletes are not supported on a read-only engine");
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("no-ops are not supported on a read-only engine");
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return false;
    }

    @Override
    public void asyncEnsureTranslogSynced(Translog.Location location, Consumer<Exception> listener) {
        listener.accept(null);
    }

    @Override
    public void asyncEnsureGlobalCheckpointSynced(long globalCheckpoint, Consumer<Exception> listener) {
        listener.accept(null);
    }

    @Override
    public void syncTranslog() {
    }

    @Override
    public Closeable acquireHistoryRetentionLock() {
        return () -> {};
    }

    @Override
    public int countChanges(String source, long fromSeqNo, long toSeqNo) throws IOException {
        try (Translog.Snapshot snapshot = this.newChangesSnapshot(source, fromSeqNo, toSeqNo, false, true, true);){
            int n = snapshot.totalOperations();
            return n;
        }
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean singleConsumer, boolean accessStats) {
        return Translog.Snapshot.EMPTY;
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, long startingSeqNo) {
        return startingSeqNo > this.seqNoStats.getMaxSeqNo();
    }

    @Override
    public long getMinRetainedSeqNo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.translogStats;
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return new Translog.Location(0L, 0L, 0);
    }

    @Override
    public long getMaxSeqNo() {
        return this.seqNoStats.getMaxSeqNo();
    }

    @Override
    public long getProcessedLocalCheckpoint() {
        return this.seqNoStats.getLocalCheckpoint();
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.seqNoStats.getLocalCheckpoint();
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return new SeqNoStats(this.seqNoStats.getMaxSeqNo(), this.seqNoStats.getLocalCheckpoint(), globalCheckpoint);
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.seqNoStats.getGlobalCheckpoint();
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    @Override
    public List<Segment> segments() {
        return Arrays.asList(this.getSegmentInfo(this.lastCommittedSegmentInfos));
    }

    @Override
    public List<Segment> segments(boolean includeVectorFormatsInfo) {
        return Arrays.asList(this.getSegmentInfo(this.lastCommittedSegmentInfos, includeVectorFormatsInfo));
    }

    @Override
    public Engine.RefreshResult refresh(String source) {
        return Engine.RefreshResult.NO_REFRESH;
    }

    @Override
    public void maybeRefresh(String source, ActionListener<Engine.RefreshResult> listener) throws EngineException {
        listener.onResponse(Engine.RefreshResult.NO_REFRESH);
    }

    @Override
    public void writeIndexingBuffer() {
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    @Override
    protected void flushHoldingLock(boolean force, boolean waitIfOngoing, ActionListener<Engine.FlushResult> listener) throws EngineException {
        listener.onResponse(new Engine.FlushResult(true, this.lastCommittedSegmentInfos.getGeneration()));
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, String forceMergeUUID) {
        if (maxNumSegments != -1) {
            if (maxNumSegments < this.lastCommittedSegmentInfos.size()) {
                throw new UnsupportedOperationException("force merge is not supported on a read-only engine, target max number of segments[" + maxNumSegments + "], current number of segments[" + this.lastCommittedSegmentInfos.size() + "].");
            }
            this.logger.debug("current number of segments[{}] is not greater than target max number of segments[{}].", (Object)this.lastCommittedSegmentInfos.size(), (Object)maxNumSegments);
        }
    }

    @Override
    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) {
        this.store.incRef();
        return new Engine.IndexCommitRef(this.indexCommit, this.store::decRef);
    }

    @Override
    public Engine.IndexCommitRef acquireSafeIndexCommit() {
        return this.acquireLastIndexCommit(false);
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return this.safeCommitInfo;
    }

    @Override
    public void activateThrottling() {
    }

    @Override
    public void deactivateThrottling() {
    }

    @Override
    public void trimUnreferencedTranslogFiles() {
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return false;
    }

    @Override
    public void rollTranslogGeneration() {
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) {
        return 0;
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) {
        return 0;
    }

    @Override
    public void recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo, ActionListener<Void> listener) {
        ActionListener.runWithResource(listener, this::acquireEnsureOpenRef, (l, ignoredRef) -> {
            try {
                translogRecoveryRunner.run(this, Translog.Snapshot.EMPTY);
            }
            catch (Exception e) {
                throw new EngineException(this.shardId, "failed to recover from empty translog snapshot", e, new Object[0]);
            }
            l.onResponse(null);
        });
    }

    @Override
    public void skipTranslogRecovery() {
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) {
    }

    @Override
    public void maybePruneDeletes() {
    }

    @Override
    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    @Override
    public boolean refreshNeeded() {
        return false;
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.seqNoStats.getMaxSeqNo();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
        assert (maxSeqNoOfUpdatesOnPrimary <= this.getMaxSeqNoOfUpdatesOrDeletes()) : maxSeqNoOfUpdatesOnPrimary + ">" + this.getMaxSeqNoOfUpdatesOrDeletes();
    }

    protected DirectoryReader openDirectory(Directory directory) throws IOException {
        assert (Transports.assertNotTransportThread("opening directory reader of a read-only engine"));
        DirectoryReader reader = DirectoryReader.open(directory);
        if (this.lazilyLoadSoftDeletes) {
            return new LazySoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
        }
        return new SoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }

    @Override
    public ShardLongFieldRange getRawFieldRange(String field) throws IOException {
        try (Engine.Searcher searcher = this.acquireSearcher(FIELD_RANGE_SEARCH_SOURCE);){
            DirectoryReader directoryReader = searcher.getDirectoryReader();
            byte[] minPackedValue = PointValues.getMinPackedValue(directoryReader, field);
            byte[] maxPackedValue = PointValues.getMaxPackedValue(directoryReader, field);
            if (minPackedValue == null || maxPackedValue == null) {
                assert (minPackedValue == null && maxPackedValue == null) : Arrays.toString(minPackedValue) + "-" + Arrays.toString(maxPackedValue);
                ShardLongFieldRange shardLongFieldRange = ShardLongFieldRange.EMPTY;
                return shardLongFieldRange;
            }
            ShardLongFieldRange shardLongFieldRange = ShardLongFieldRange.of(LongPoint.decodeDimension(minPackedValue, 0), LongPoint.decodeDimension(maxPackedValue, 0));
            return shardLongFieldRange;
        }
    }

    @Override
    public Engine.SearcherSupplier acquireSearcherSupplier(Function<Engine.Searcher, Engine.Searcher> wrapper, Engine.SearcherScope scope) throws EngineException {
        final Engine.SearcherSupplier delegate = super.acquireSearcherSupplier(wrapper, scope);
        return new Engine.SearcherSupplier(wrapper){

            @Override
            protected void doClose() {
                delegate.close();
            }

            @Override
            protected Engine.Searcher acquireSearcherInternal(String source) {
                return delegate.acquireSearcherInternal(source);
            }

            @Override
            public String getSearcherId() {
                return ReadOnlyEngine.this.commitId;
            }
        };
    }

    public final String getCommitId() {
        return this.commitId;
    }
}

