/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.RandomAccessQuantizedByteVectorValues;
import org.elasticsearch.script.field.vectors.ESVectorUtil;

class ES815BitFlatVectorsFormat
extends FlatVectorsFormat {
    private final FlatVectorsFormat delegate = new Lucene99FlatVectorsFormat(FlatBitVectorScorer.INSTANCE);

    ES815BitFlatVectorsFormat() {
    }

    @Override
    public FlatVectorsWriter fieldsWriter(SegmentWriteState segmentWriteState) throws IOException {
        return this.delegate.fieldsWriter(segmentWriteState);
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState segmentReadState) throws IOException {
        return this.delegate.fieldsReader(segmentReadState);
    }

    static float hammingScore(byte[] a, byte[] b) {
        return (float)(a.length * 8 - ESVectorUtil.xorBitCount(a, b)) / (float)(a.length * 8);
    }

    static class FlatBitVectorScorer
    implements FlatVectorsScorer {
        static final FlatBitVectorScorer INSTANCE = new FlatBitVectorScorer();

        FlatBitVectorScorer() {
        }

        static void checkDimensions(int queryLen, int fieldLen) {
            if (queryLen != fieldLen) {
                throw new IllegalArgumentException("vector query dimension: " + queryLen + " differs from field dimension: " + fieldLen);
            }
        }

        public String toString() {
            return super.toString();
        }

        @Override
        public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction vectorSimilarityFunction, RandomAccessVectorValues randomAccessVectorValues) throws IOException {
            assert (randomAccessVectorValues instanceof RandomAccessVectorValues.Bytes);
            assert (vectorSimilarityFunction == VectorSimilarityFunction.EUCLIDEAN);
            if (randomAccessVectorValues instanceof RandomAccessVectorValues.Bytes) {
                RandomAccessVectorValues.Bytes randomAccessVectorValuesBytes = (RandomAccessVectorValues.Bytes)randomAccessVectorValues;
                assert (!(randomAccessVectorValues instanceof RandomAccessQuantizedByteVectorValues));
                switch (vectorSimilarityFunction) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOT_PRODUCT: 
                    case MAXIMUM_INNER_PRODUCT: 
                    case COSINE: 
                    case EUCLIDEAN: 
                }
                return new HammingScorerSupplier(randomAccessVectorValuesBytes);
            }
            throw new IllegalArgumentException("Unsupported vector type or similarity function");
        }

        @Override
        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, RandomAccessVectorValues randomAccessVectorValues, byte[] bytes) {
            assert (randomAccessVectorValues instanceof RandomAccessVectorValues.Bytes);
            assert (vectorSimilarityFunction == VectorSimilarityFunction.EUCLIDEAN);
            if (randomAccessVectorValues instanceof RandomAccessVectorValues.Bytes) {
                RandomAccessVectorValues.Bytes randomAccessVectorValuesBytes = (RandomAccessVectorValues.Bytes)randomAccessVectorValues;
                FlatBitVectorScorer.checkDimensions(bytes.length, randomAccessVectorValuesBytes.dimension());
                switch (vectorSimilarityFunction) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOT_PRODUCT: 
                    case MAXIMUM_INNER_PRODUCT: 
                    case COSINE: 
                    case EUCLIDEAN: 
                }
                return new HammingVectorScorer(randomAccessVectorValuesBytes, bytes);
            }
            throw new IllegalArgumentException("Unsupported vector type or similarity function");
        }

        @Override
        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, RandomAccessVectorValues randomAccessVectorValues, float[] floats) {
            throw new IllegalArgumentException("Unsupported vector type");
        }
    }

    static class HammingScorerSupplier
    implements RandomVectorScorerSupplier {
        private final RandomAccessVectorValues.Bytes byteValues;
        private final RandomAccessVectorValues.Bytes byteValues1;
        private final RandomAccessVectorValues.Bytes byteValues2;

        HammingScorerSupplier(RandomAccessVectorValues.Bytes byteValues) throws IOException {
            this.byteValues = byteValues;
            this.byteValues1 = byteValues.copy();
            this.byteValues2 = byteValues.copy();
        }

        @Override
        public RandomVectorScorer scorer(int i) throws IOException {
            byte[] query = this.byteValues1.vectorValue(i);
            return new HammingVectorScorer(this.byteValues2, query);
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new HammingScorerSupplier(this.byteValues);
        }
    }

    static class HammingVectorScorer
    extends RandomVectorScorer.AbstractRandomVectorScorer {
        private final byte[] query;
        private final RandomAccessVectorValues.Bytes byteValues;

        HammingVectorScorer(RandomAccessVectorValues.Bytes byteValues, byte[] query) {
            super(byteValues);
            this.query = query;
            this.byteValues = byteValues;
        }

        @Override
        public float score(int i) throws IOException {
            return ES815BitFlatVectorsFormat.hammingScore(this.byteValues.vectorValue(i), this.query);
        }
    }
}

