/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.bloomfilter;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.core.IOUtils;

public class ES87BloomFilterPostingsFormat
extends PostingsFormat {
    static final String BLOOM_CODEC_NAME = "ES87BloomFilter";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final String BLOOM_FILTER_META_FILE = "bfm";
    static final String BLOOM_FILTER_INDEX_FILE = "bfi";
    private static final int BITS_PER_ENTRY = 10;
    private static final int NUM_HASH_FUNCTIONS = 7;
    private Function<String, PostingsFormat> postingsFormats;
    private BigArrays bigArrays;

    public ES87BloomFilterPostingsFormat(BigArrays bigArrays, Function<String, PostingsFormat> postingsFormats) {
        this();
        this.bigArrays = Objects.requireNonNull(bigArrays);
        this.postingsFormats = Objects.requireNonNull(postingsFormats);
    }

    public ES87BloomFilterPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.postingsFormats == null || this.bigArrays == null) {
            assert (false) : "ES87BloomFilter was initialized with a wrong constructor";
            throw new UnsupportedOperationException("ES87BloomFilter was initialized with a wrong constructor");
        }
        return new FieldsWriter(state);
    }

    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    @Override
    public String toString() {
        return BLOOM_CODEC_NAME;
    }

    private static String metaFile(SegmentInfo si, String segmentSuffix) {
        return IndexFileNames.segmentFileName(si.name, segmentSuffix, BLOOM_FILTER_META_FILE);
    }

    private static String indexFile(SegmentInfo si, String segmentSuffix) {
        return IndexFileNames.segmentFileName(si.name, segmentSuffix, BLOOM_FILTER_INDEX_FILE);
    }

    static int bloomFilterSize(int maxDocs) {
        if (maxDocs < 1) {
            throw new IllegalStateException("maxDocs must be greater than or equal to 1, got " + maxDocs);
        }
        long numBits = (long)maxDocs * 10L;
        if ((numBits = (numBits - 1L | 7L) + 1L) > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)numBits;
    }

    static int numBytesForBloomFilter(int bloomFilterSize) {
        return Math.toIntExact(((long)bloomFilterSize + 7L) / 8L);
    }

    static int[] hashTerm(BytesRef br, int[] outputs) {
        long hash64 = MurmurHash3.hash64(br.bytes, br.offset, br.length);
        int upperHalf = (int)(hash64 >> 32);
        int lowerHalf = (int)hash64;
        outputs[0] = lowerHalf + 2 * upperHalf & Integer.MAX_VALUE;
        outputs[1] = lowerHalf + 3 * upperHalf & Integer.MAX_VALUE;
        outputs[2] = lowerHalf + 5 * upperHalf & Integer.MAX_VALUE;
        outputs[3] = lowerHalf + 7 * upperHalf & Integer.MAX_VALUE;
        outputs[4] = lowerHalf + 11 * upperHalf & Integer.MAX_VALUE;
        outputs[5] = lowerHalf + 13 * upperHalf & Integer.MAX_VALUE;
        outputs[6] = lowerHalf + 17 * upperHalf & Integer.MAX_VALUE;
        return outputs;
    }

    final class FieldsWriter
    extends FieldsConsumer {
        private final SegmentWriteState state;
        private final IndexOutput indexOut;
        private final List<BloomFilter> bloomFilters = new ArrayList<BloomFilter>();
        private final List<FieldsGroup> fieldsGroups = new ArrayList<FieldsGroup>();
        private final List<Closeable> toCloses = new ArrayList<Closeable>();
        private boolean closed;
        private final int[] hashes = new int[7];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldsWriter(SegmentWriteState state) throws IOException {
            this.state = state;
            boolean success = false;
            try {
                this.indexOut = state.directory.createOutput(ES87BloomFilterPostingsFormat.indexFile(state.segmentInfo, state.segmentSuffix), state.context);
                this.toCloses.add(this.indexOut);
                CodecUtil.writeIndexHeader(this.indexOut, ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 0, state.segmentInfo.getId(), state.segmentSuffix);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toCloses);
                }
            }
        }

        @Override
        public void write(Fields fields, NormsProducer norms) throws IOException {
            this.writePostings(fields, norms);
            this.writeBloomFilters(fields);
        }

        private void writePostings(Fields fields, NormsProducer norms) throws IOException {
            HashMap<PostingsFormat, FieldsGroup> currentGroups = new HashMap<PostingsFormat, FieldsGroup>();
            for (String field : fields) {
                PostingsFormat postingsFormat = ES87BloomFilterPostingsFormat.this.postingsFormats.apply(field);
                if (postingsFormat == null) {
                    throw new IllegalStateException("PostingsFormat for field [" + field + "] wasn't specified");
                }
                FieldsGroup group = (FieldsGroup)currentGroups.get(postingsFormat);
                if (group == null) {
                    group = new FieldsGroup(postingsFormat, Integer.toString(this.fieldsGroups.size()), new ArrayList<String>());
                    currentGroups.put(postingsFormat, group);
                    this.fieldsGroups.add(group);
                }
                group.fields.add(field);
            }
            for (final FieldsGroup group : currentGroups.values()) {
                FieldsConsumer writer = group.postingsFormat.fieldsConsumer(new SegmentWriteState(this.state, group.suffix));
                this.toCloses.add(writer);
                FilterLeafReader.FilterFields maskedFields = new FilterLeafReader.FilterFields(fields){

                    @Override
                    public Iterator<String> iterator() {
                        return group.fields.iterator();
                    }
                };
                writer.write(maskedFields, norms);
            }
        }

        private void writeBloomFilters(Fields fields) throws IOException {
            for (String field : fields) {
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                int bloomFilterSize = ES87BloomFilterPostingsFormat.bloomFilterSize(this.state.segmentInfo.maxDoc());
                int numBytes = ES87BloomFilterPostingsFormat.numBytesForBloomFilter(bloomFilterSize);
                ByteArray buffer = ES87BloomFilterPostingsFormat.this.bigArrays.newByteArray(numBytes);
                try {
                    BytesRef term;
                    TermsEnum termsEnum = terms.iterator();
                    while ((term = termsEnum.next()) != null) {
                        ES87BloomFilterPostingsFormat.hashTerm(term, this.hashes);
                        for (int hash : this.hashes) {
                            int pos = (hash %= bloomFilterSize) >> 3;
                            int mask = 1 << (hash & 7);
                            byte val = (byte)(buffer.get(pos) | mask);
                            buffer.set(pos, val);
                        }
                    }
                    this.bloomFilters.add(new BloomFilter(field, this.indexOut.getFilePointer(), bloomFilterSize));
                    BytesReference bytes = BytesReference.fromByteArray(buffer, numBytes);
                    bytes.writeTo(new IndexOutputOutputStream(this.indexOut));
                }
                finally {
                    if (buffer == null) continue;
                    buffer.close();
                }
            }
        }

        @Override
        public void close() throws IOException {
            long indexFileLength;
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                CodecUtil.writeFooter(this.indexOut);
                indexFileLength = this.indexOut.getFilePointer();
            }
            finally {
                IOUtils.close(this.toCloses);
            }
            try (IndexOutput metaOut = this.state.directory.createOutput(ES87BloomFilterPostingsFormat.metaFile(this.state.segmentInfo, this.state.segmentSuffix), this.state.context);){
                CodecUtil.writeIndexHeader(metaOut, ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 0, this.state.segmentInfo.getId(), this.state.segmentSuffix);
                metaOut.writeVInt(this.fieldsGroups.size());
                for (FieldsGroup group : this.fieldsGroups) {
                    group.writeTo(metaOut, this.state.fieldInfos);
                }
                metaOut.writeVInt(this.bloomFilters.size());
                for (BloomFilter bloomFilter : this.bloomFilters) {
                    bloomFilter.writeTo(metaOut, this.state.fieldInfos);
                }
                metaOut.writeVLong(indexFileLength);
                CodecUtil.writeFooter(metaOut);
            }
        }
    }

    static final class FieldsReader
    extends FieldsProducer {
        private final Map<String, BloomFilter> bloomFilters;
        private final List<Closeable> toCloses = new ArrayList<Closeable>();
        private final Map<String, FieldsProducer> readerMap = new HashMap<String, FieldsProducer>();
        private final IndexInput indexIn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldsReader(SegmentReadState state) throws IOException {
            boolean success = false;
            try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(ES87BloomFilterPostingsFormat.metaFile(state.segmentInfo, state.segmentSuffix), IOContext.READONCE);){
                HashMap<String, BloomFilter> bloomFilters = null;
                Throwable priorE = null;
                long indexFileLength = 0L;
                try {
                    CodecUtil.checkIndexHeader(metaIn, ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    int numFieldsGroups = metaIn.readVInt();
                    for (int i = 0; i < numFieldsGroups; ++i) {
                        FieldsGroup group = FieldsGroup.readFrom(metaIn, state.fieldInfos);
                        FieldsProducer reader = group.postingsFormat.fieldsProducer(new SegmentReadState(state, group.suffix));
                        this.toCloses.add(reader);
                        for (String field : group.fields) {
                            this.readerMap.put(field, reader);
                        }
                    }
                    int numBloomFilters = metaIn.readVInt();
                    bloomFilters = new HashMap<String, BloomFilter>(numBloomFilters);
                    for (int i = 0; i < numBloomFilters; ++i) {
                        BloomFilter bloomFilter = BloomFilter.readFrom(metaIn, state.fieldInfos);
                        bloomFilters.put(bloomFilter.field, bloomFilter);
                    }
                    indexFileLength = metaIn.readVLong();
                }
                catch (Throwable t) {
                    priorE = t;
                }
                finally {
                    CodecUtil.checkFooter(metaIn, priorE);
                }
                this.bloomFilters = bloomFilters;
                this.indexIn = state.directory.openInput(ES87BloomFilterPostingsFormat.indexFile(state.segmentInfo, state.segmentSuffix), state.context);
                this.toCloses.add(this.indexIn);
                CodecUtil.checkIndexHeader(this.indexIn, ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                CodecUtil.retrieveChecksum(this.indexIn, indexFileLength);
                assert (this.assertBloomFilterSizes(state.segmentInfo));
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toCloses);
                }
            }
        }

        private boolean assertBloomFilterSizes(SegmentInfo segmentInfo) {
            for (BloomFilter bloomFilter : this.bloomFilters.values()) {
                assert (bloomFilter.bloomFilterSize == ES87BloomFilterPostingsFormat.bloomFilterSize(segmentInfo.maxDoc())) : "bloom_filter=" + bloomFilter + ", max_docs=" + segmentInfo.maxDoc();
            }
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return this.readerMap.keySet().iterator();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.toCloses);
        }

        @Override
        public Terms terms(String field) throws IOException {
            FieldsProducer reader = this.readerMap.get(field);
            if (reader == null) {
                return null;
            }
            Terms terms = reader.terms(field);
            if (terms == null) {
                return null;
            }
            BloomFilter bloomFilter = this.bloomFilters.get(field);
            if (bloomFilter != null) {
                RandomAccessInput data = this.indexIn.randomAccessSlice(bloomFilter.startFilePointer(), ES87BloomFilterPostingsFormat.numBytesForBloomFilter(bloomFilter.bloomFilterSize));
                return new BloomFilterTerms(terms, data, bloomFilter.bloomFilterSize);
            }
            return terms;
        }

        @Override
        public int size() {
            return this.readerMap.size();
        }

        @Override
        public void checkIntegrity() throws IOException {
            CodecUtil.checksumEntireFile(this.indexIn);
            HashSet<FieldsProducer> seenReaders = new HashSet<FieldsProducer>();
            for (FieldsProducer reader : this.readerMap.values()) {
                if (!seenReaders.add(reader)) continue;
                reader.checkIntegrity();
            }
        }
    }

    public static final class MurmurHash3 {
        public static final int DEFAULT_SEED = 104729;
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private static final int R1 = 31;
        private static final int R2 = 27;
        private static final int R3 = 33;
        private static final int M = 5;
        private static final int N1 = 1390208809;
        private static final int N2 = 944331445;

        private MurmurHash3() {
        }

        public static long hash64(byte[] data, int offset, int length) {
            long[] hash128 = new long[]{0L, 0L};
            MurmurHash3.hash128x64Internal(data, offset, length, 104729L, hash128);
            return hash128[0];
        }

        private static long[] hash128x64Internal(byte[] data, int offset, int length, long seed, long[] result) {
            long h1 = seed;
            long h2 = seed;
            int nblocks = length >> 4;
            for (int i = 0; i < nblocks; ++i) {
                int index = offset + (i << 4);
                long k1 = ByteUtils.readLongLE(data, index);
                long k2 = ByteUtils.readLongLE(data, index + 8);
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
                h1 = Long.rotateLeft(h1, 27);
                h1 += h2;
                h1 = h1 * 5L + 1390208809L;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
                h2 = Long.rotateLeft(h2, 31);
                h2 += h1;
                h2 = h2 * 5L + 944331445L;
            }
            long k1 = 0L;
            long k2 = 0L;
            int index = offset + (nblocks << 4);
            switch (offset + length - index) {
                case 15: {
                    k2 ^= ((long)data[index + 14] & 0xFFL) << 48;
                }
                case 14: {
                    k2 ^= ((long)data[index + 13] & 0xFFL) << 40;
                }
                case 13: {
                    k2 ^= ((long)data[index + 12] & 0xFFL) << 32;
                }
                case 12: {
                    k2 ^= ((long)data[index + 11] & 0xFFL) << 24;
                }
                case 11: {
                    k2 ^= ((long)data[index + 10] & 0xFFL) << 16;
                }
                case 10: {
                    k2 ^= ((long)data[index + 9] & 0xFFL) << 8;
                }
                case 9: {
                    k2 ^= (long)(data[index + 8] & 0xFF);
                    k2 *= 5545529020109919103L;
                    k2 = Long.rotateLeft(k2, 33);
                    h2 ^= (k2 *= -8663945395140668459L);
                }
                case 8: {
                    k1 ^= ((long)data[index + 7] & 0xFFL) << 56;
                }
                case 7: {
                    k1 ^= ((long)data[index + 6] & 0xFFL) << 48;
                }
                case 6: {
                    k1 ^= ((long)data[index + 5] & 0xFFL) << 40;
                }
                case 5: {
                    k1 ^= ((long)data[index + 4] & 0xFFL) << 32;
                }
                case 4: {
                    k1 ^= ((long)data[index + 3] & 0xFFL) << 24;
                }
                case 3: {
                    k1 ^= ((long)data[index + 2] & 0xFFL) << 16;
                }
                case 2: {
                    k1 ^= ((long)data[index + 1] & 0xFFL) << 8;
                }
                case 1: {
                    k1 ^= (long)(data[index] & 0xFF);
                    k1 *= -8663945395140668459L;
                    k1 = Long.rotateLeft(k1, 31);
                    h1 ^= (k1 *= 5545529020109919103L);
                }
            }
            h1 ^= (long)length;
            h1 += (h2 ^= (long)length);
            h2 += h1;
            h1 = MurmurHash3.fmix64(h1);
            h2 = MurmurHash3.fmix64(h2);
            h1 += h2;
            result[0] = h1;
            result[1] = h2 += h1;
            return result;
        }

        private static long fmix64(long hash) {
            hash ^= hash >>> 33;
            hash *= -49064778989728563L;
            hash ^= hash >>> 33;
            hash *= -4265267296055464877L;
            hash ^= hash >>> 33;
            return hash;
        }
    }

    private static abstract class LazyFilterTermsEnum
    extends BaseTermsEnum {
        private LazyFilterTermsEnum() {
        }

        abstract TermsEnum getDelegate() throws IOException;

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.getDelegate().seekCeil(text);
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.getDelegate().seekExact(ord);
        }

        @Override
        public BytesRef term() throws IOException {
            return this.getDelegate().term();
        }

        @Override
        public long ord() throws IOException {
            return this.getDelegate().ord();
        }

        @Override
        public int docFreq() throws IOException {
            return this.getDelegate().docFreq();
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.getDelegate().totalTermFreq();
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.getDelegate().postings(reuse, flags);
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            return this.getDelegate().impacts(flags);
        }

        @Override
        public BytesRef next() throws IOException {
            return this.getDelegate().next();
        }

        @Override
        public AttributeSource attributes() {
            try {
                return this.getDelegate().attributes();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class BloomFilterTerms
    extends FilterLeafReader.FilterTerms {
        private final RandomAccessInput data;
        private final int bloomFilterSize;
        private final int[] hashes = new int[7];

        BloomFilterTerms(Terms in, RandomAccessInput data, int bloomFilterSize) {
            super(in);
            this.data = data;
            this.bloomFilterSize = bloomFilterSize;
        }

        private boolean mayContainTerm(BytesRef term) throws IOException {
            ES87BloomFilterPostingsFormat.hashTerm(term, this.hashes);
            for (int hash : this.hashes) {
                int pos = (hash %= this.bloomFilterSize) >> 3;
                int mask = 1 << (hash & 7);
                byte bits = this.data.readByte(pos);
                if ((bits & mask) != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new LazyFilterTermsEnum(){
                private TermsEnum delegate;

                @Override
                TermsEnum getDelegate() throws IOException {
                    if (this.delegate == null) {
                        this.delegate = in.iterator();
                    }
                    return this.delegate;
                }

                @Override
                public boolean seekExact(BytesRef term) throws IOException {
                    if (this.mayContainTerm(term)) {
                        return this.getDelegate().seekExact(term);
                    }
                    return false;
                }

                @Override
                public void seekExact(BytesRef term, TermState state) throws IOException {
                    this.getDelegate().seekExact(term, state);
                }

                @Override
                public TermState termState() throws IOException {
                    return this.getDelegate().termState();
                }
            };
        }
    }

    private record FieldsGroup(PostingsFormat postingsFormat, String suffix, List<String> fields) {
        void writeTo(IndexOutput out, FieldInfos fieldInfos) throws IOException {
            out.writeString(this.postingsFormat.getName());
            out.writeString(this.suffix);
            out.writeVInt(this.fields.size());
            for (String field : this.fields) {
                out.writeVInt(fieldInfos.fieldInfo((String)field).number);
            }
        }

        static FieldsGroup readFrom(IndexInput in, FieldInfos fieldInfos) throws IOException {
            PostingsFormat postingsFormat = PostingsFormat.forName(in.readString());
            String suffix = in.readString();
            int numFields = in.readVInt();
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < numFields; ++i) {
                fields.add(fieldInfos.fieldInfo((int)in.readVInt()).name);
            }
            return new FieldsGroup(postingsFormat, suffix, fields);
        }
    }

    private record BloomFilter(String field, long startFilePointer, int bloomFilterSize) {
        void writeTo(IndexOutput out, FieldInfos fieldInfos) throws IOException {
            out.writeVInt(fieldInfos.fieldInfo((String)this.field).number);
            out.writeVLong(this.startFilePointer);
            out.writeVInt(this.bloomFilterSize);
        }

        static BloomFilter readFrom(IndexInput in, FieldInfos fieldInfos) throws IOException {
            String fieldName = fieldInfos.fieldInfo((int)in.readVInt()).name;
            long startFilePointer = in.readVLong();
            int bloomFilterSize = in.readVInt();
            return new BloomFilter(fieldName, startFilePointer, bloomFilterSize);
        }
    }
}

