/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.OutputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.http.HttpBodyTracer;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.transport.TransportService;

class HttpTracer {
    private static final Logger logger = LogManager.getLogger(HttpTracer.class);
    private volatile String[] tracerLogInclude;
    private volatile String[] tracerLogExclude;

    HttpTracer() {
        this.tracerLogExclude = new String[0];
        this.tracerLogInclude = this.tracerLogExclude;
    }

    HttpTracer(Settings settings, ClusterSettings clusterSettings) {
        this.setTracerLogInclude(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE.get(settings));
        this.setTracerLogExclude(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE.get(settings));
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE, this::setTracerLogInclude);
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE, this::setTracerLogExclude);
    }

    @Nullable
    HttpTracer maybeLogRequest(RestRequest restRequest, @Nullable Exception e) {
        if (logger.isTraceEnabled() && TransportService.shouldTraceAction(restRequest.uri(), this.tracerLogInclude, this.tracerLogExclude)) {
            block10: {
                logger.trace(() -> Strings.format("[%s][%s][%s][%s] received request from [%s]%s", new Object[]{restRequest.getRequestId(), restRequest.header("X-Opaque-Id"), restRequest.method(), restRequest.uri(), restRequest.getHttpChannel(), RestUtils.extractTraceId(restRequest.header("traceparent")).map(t -> " trace.id: " + t).orElse("")}), (Throwable)e);
                if (this.isBodyTracerEnabled()) {
                    try (OutputStream stream = HttpBodyTracer.getBodyOutputStream(restRequest.getRequestId(), HttpBodyTracer.Type.REQUEST);){
                        restRequest.content().writeTo(stream);
                    }
                    catch (Exception e2) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError((Object)e2);
                    }
                }
            }
            return this;
        }
        return null;
    }

    boolean isBodyTracerEnabled() {
        return HttpBodyTracer.isEnabled();
    }

    void logResponse(RestResponse restResponse, HttpChannel httpChannel, String contentLength, String opaqueHeader, long requestId, boolean success) {
        logger.trace(() -> Strings.format("[%s][%s][%s][%s][%s] sent response to [%s] success [%s]", new Object[]{requestId, opaqueHeader, restResponse.status(), restResponse.contentType(), contentLength, httpChannel, success}));
    }

    private void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
    }

    private void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
    }

    OutputStream openResponseBodyLoggingStream(long requestId) {
        return HttpBodyTracer.getBodyOutputStream(requestId, HttpBodyTracer.Type.RESPONSE);
    }
}

