/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.BaseGatewayShardAllocator;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetadata;

public abstract class ReplicaShardAllocator
extends BaseGatewayShardAllocator {
    public void processExistingRecoveries(RoutingAllocation allocation, Predicate<ShardRouting> isRelevantShardPredicate) {
        RoutingNodes routingNodes = allocation.routingNodes();
        ArrayList<Runnable> shardCancellationActions = new ArrayList<Runnable>();
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shard : routingNode) {
                DiscoveryNode nodeWithHighestMatch;
                DiscoveryNode currentNode;
                if (shard.primary() || !shard.initializing() || shard.relocatingNodeId() != null || !isRelevantShardPredicate.test(shard) || shard.unassignedInfo() != null && shard.unassignedInfo().reason() == UnassignedInfo.Reason.INDEX_CREATED) continue;
                AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores = this.fetchData(shard, allocation);
                if (!shardStores.hasData()) {
                    this.logger.trace("{}: fetching new stores for initializing shard", (Object)shard);
                    continue;
                }
                ShardRouting primaryShard = allocation.routingNodes().activePrimary(shard.shardId());
                assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
                assert (primaryShard.currentNodeId() != null);
                DiscoveryNode primaryNode = allocation.nodes().get(primaryShard.currentNodeId());
                TransportNodesListShardStoreMetadata.StoreFilesMetadata primaryStore = ReplicaShardAllocator.findStore(primaryNode, shardStores);
                if (primaryStore == null) {
                    this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)shard);
                    continue;
                }
                MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, true, primaryNode, primaryStore, shardStores, false);
                if (matchingNodes.nodeWithHighestMatch() == null || (currentNode = allocation.nodes().get(shard.currentNodeId())).equals(nodeWithHighestMatch = matchingNodes.nodeWithHighestMatch()) || !matchingNodes.canPerformNoopRecovery(nodeWithHighestMatch) || ReplicaShardAllocator.canPerformOperationBasedRecovery(primaryStore, shardStores, currentNode)) continue;
                this.logger.debug("cancelling allocation of replica on [{}], can perform a noop recovery on node [{}]", (Object)currentNode, (Object)nodeWithHighestMatch);
                Set<String> failedNodeIds = shard.unassignedInfo() == null ? Collections.emptySet() : shard.unassignedInfo().failedNodeIds();
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.REALLOCATED_REPLICA, "existing allocation of replica to [" + currentNode + "] cancelled, can perform a noop recovery on [" + nodeWithHighestMatch + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT, failedNodeIds, null);
                shardCancellationActions.add(() -> routingNodes.failShard(shard, unassignedInfo, allocation.changes()));
            }
        }
        for (Runnable action : shardCancellationActions) {
            action.run();
        }
    }

    private static boolean isResponsibleFor(ShardRouting shard) {
        return !shard.primary() && shard.unassigned() && shard.unassignedInfo().reason() != UnassignedInfo.Reason.INDEX_CREATED;
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        if (!ReplicaShardAllocator.isResponsibleFor(unassignedShard)) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        boolean explain = allocation.debugDecision();
        PerNodeAllocationResult result = ReplicaShardAllocator.canBeAllocatedToAtLeastOneNode(unassignedShard, allocation);
        Decision allocateDecision = result.decision();
        if (!(allocateDecision.type() == Decision.Type.YES || explain && this.hasInitiatedFetching(unassignedShard))) {
            logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)unassignedShard);
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.type()), result.nodes());
        }
        AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores = this.fetchData(unassignedShard, allocation);
        if (!shardStores.hasData()) {
            logger.trace("{}: ignoring allocation, still fetching shard stores", (Object)unassignedShard);
            allocation.setHasPendingAsyncFetch();
            List<NodeAllocationResult> nodeDecisions = null;
            if (explain) {
                nodeDecisions = ReplicaShardAllocator.buildDecisionsForAllNodes(unassignedShard, allocation);
            }
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeDecisions);
        }
        ShardRouting primaryShard = routingNodes.activePrimary(unassignedShard.shardId());
        if (primaryShard == null) {
            assert (explain) : "primary should only be null here if we are in explain mode, so we didn't exit early when canBeAllocatedToAtLeastOneNode didn't return a YES decision";
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.type()), result.nodes());
        }
        assert (primaryShard.currentNodeId() != null);
        DiscoveryNode primaryNode = allocation.nodes().get(primaryShard.currentNodeId());
        TransportNodesListShardStoreMetadata.StoreFilesMetadata primaryStore = ReplicaShardAllocator.findStore(primaryNode, shardStores);
        if (primaryStore == null) {
            logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)unassignedShard);
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        MatchingNodes matchingNodes = this.findMatchingNodes(unassignedShard, allocation, false, primaryNode, primaryStore, shardStores, explain);
        assert (!explain || matchingNodes.nodeDecisions != null) : "in explain mode, we must have individual node decisions";
        List<NodeAllocationResult> nodeDecisions = ReplicaShardAllocator.augmentExplanationsWithStoreInfo(result.nodes(), matchingNodes.nodeDecisions);
        if (allocateDecision.type() != Decision.Type.YES) {
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.type()), nodeDecisions);
        }
        if (matchingNodes.nodeWithHighestMatch() != null) {
            RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.nodeWithHighestMatch().getId());
            Decision decision = allocation.deciders().canAllocateReplicaWhenThereIsRetentionLease(unassignedShard, nodeWithHighestMatch, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
                return AllocateUnassignedDecision.throttle(nodeDecisions);
            }
            logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
            return AllocateUnassignedDecision.yes(nodeWithHighestMatch.node(), null, nodeDecisions, true);
        }
        if (!matchingNodes.hasAnyData() && unassignedShard.unassignedInfo().delayed()) {
            return ReplicaShardAllocator.delayedDecision(unassignedShard, allocation, logger, nodeDecisions);
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    public static AllocateUnassignedDecision delayedDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger, List<NodeAllocationResult> nodeDecisions) {
        boolean explain = allocation.debugDecision();
        logger.debug("{}: allocation of [{}] is delayed", (Object)unassignedShard.shardId(), (Object)unassignedShard);
        long remainingDelayMillis = 0L;
        long totalDelayMillis = 0L;
        if (explain) {
            UnassignedInfo unassignedInfo = unassignedShard.unassignedInfo();
            Metadata metadata = allocation.metadata();
            IndexMetadata indexMetadata = metadata.index(unassignedShard.index());
            totalDelayMillis = UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexMetadata.getSettings()).getMillis();
            long remainingDelayNanos = unassignedInfo.remainingDelay(System.nanoTime(), indexMetadata.getSettings(), metadata.nodeShutdowns());
            remainingDelayMillis = TimeValue.timeValueNanos(remainingDelayNanos).millis();
        }
        return AllocateUnassignedDecision.delayed(remainingDelayMillis, totalDelayMillis, nodeDecisions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PerNodeAllocationResult canBeAllocatedToAtLeastOneNode(ShardRouting shard, RoutingAllocation allocation) {
        Decision madeDecision = Decision.NO;
        boolean explain = allocation.debugDecision();
        ArrayList<NodeAllocationResult> nodeDecisions = explain ? new ArrayList<NodeAllocationResult>() : null;
        for (DiscoveryNode discoveryNode : allocation.nodes().getDataNodes().values()) {
            RoutingNode node = allocation.routingNodes().node(discoveryNode.getId());
            if (node == null) continue;
            Decision decision = allocation.deciders().canAllocateReplicaWhenThereIsRetentionLease(shard, node, allocation);
            if (decision.type() == Decision.Type.YES && madeDecision.type() != Decision.Type.YES) {
                if (!explain) return new PerNodeAllocationResult(decision, null);
                madeDecision = decision;
            } else if (madeDecision.type() == Decision.Type.NO && decision.type() == Decision.Type.THROTTLE) {
                madeDecision = decision;
            }
            if (!explain) continue;
            nodeDecisions.add(new NodeAllocationResult(node.node(), null, decision));
        }
        return new PerNodeAllocationResult(madeDecision, nodeDecisions);
    }

    public static List<NodeAllocationResult> augmentExplanationsWithStoreInfo(List<NodeAllocationResult> nodeDecisions, Map<String, NodeAllocationResult> withShardStores) {
        if (nodeDecisions == null || withShardStores == null) {
            return null;
        }
        ArrayList<NodeAllocationResult> augmented = new ArrayList<NodeAllocationResult>(nodeDecisions.size());
        for (NodeAllocationResult nodeAllocationResult : nodeDecisions) {
            augmented.add(withShardStores.getOrDefault(nodeAllocationResult.getNode().getId(), nodeAllocationResult));
        }
        return augmented;
    }

    private static TransportNodesListShardStoreMetadata.StoreFilesMetadata findStore(DiscoveryNode node, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> data) {
        TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata nodeFilesStore = data.getData().get(node);
        if (nodeFilesStore == null) {
            return null;
        }
        return nodeFilesStore.storeFilesMetadata();
    }

    private MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, boolean noMatchFailedNodes, DiscoveryNode primaryNode, TransportNodesListShardStoreMetadata.StoreFilesMetadata primaryStore, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> data, boolean explain) {
        HashMap<DiscoveryNode, MatchingNode> matchingNodes = new HashMap<DiscoveryNode, MatchingNode>();
        HashMap<String, NodeAllocationResult> nodeDecisions = explain ? new HashMap<String, NodeAllocationResult>() : null;
        for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> nodeStoreEntry : data.getData().entrySet()) {
            RoutingNode node;
            TransportNodesListShardStoreMetadata.StoreFilesMetadata storeFilesMetadata;
            DiscoveryNode discoNode = nodeStoreEntry.getKey();
            if (noMatchFailedNodes && shard.unassignedInfo() != null && shard.unassignedInfo().failedNodeIds().contains(discoNode.getId()) || (storeFilesMetadata = nodeStoreEntry.getValue().storeFilesMetadata()).isEmpty() || (node = allocation.routingNodes().node(discoNode.getId())) == null) continue;
            long retainingSeqNoForReplica = primaryStore.getPeerRecoveryRetentionLeaseRetainingSeqNo(discoNode);
            Decision decision = retainingSeqNoForReplica == -1L ? allocation.deciders().canAllocate(shard, node, allocation) : allocation.deciders().canAllocateReplicaWhenThereIsRetentionLease(shard, node, allocation);
            MatchingNode matchingNode = null;
            if (explain) {
                matchingNode = ReplicaShardAllocator.computeMatchingNode(primaryNode, primaryStore, discoNode, storeFilesMetadata);
                NodeAllocationResult.ShardStoreInfo shardStoreInfo = new NodeAllocationResult.ShardStoreInfo(matchingNode.matchingBytes);
                nodeDecisions.put(node.nodeId(), new NodeAllocationResult(discoNode, shardStoreInfo, decision));
            }
            if (decision.type() == Decision.Type.NO) continue;
            if (matchingNode == null) {
                matchingNode = ReplicaShardAllocator.computeMatchingNode(primaryNode, primaryStore, discoNode, storeFilesMetadata);
            }
            matchingNodes.put(discoNode, matchingNode);
            if (!this.logger.isTraceEnabled()) continue;
            if (matchingNode.isNoopRecovery) {
                this.logger.trace("{}: node [{}] can perform a noop recovery", (Object)shard, (Object)discoNode.getName());
                continue;
            }
            if (matchingNode.retainingSeqNo >= 0L) {
                this.logger.trace("{}: node [{}] can perform operation-based recovery with retaining sequence number [{}]", (Object)shard, (Object)discoNode.getName(), (Object)matchingNode.retainingSeqNo);
                continue;
            }
            this.logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable data", (Object)shard, (Object)discoNode.getName(), (Object)ByteSizeValue.ofBytes(matchingNode.matchingBytes), (Object)matchingNode.matchingBytes);
        }
        return MatchingNodes.create(matchingNodes, nodeDecisions);
    }

    private static long computeMatchingBytes(TransportNodesListShardStoreMetadata.StoreFilesMetadata primaryStore, TransportNodesListShardStoreMetadata.StoreFilesMetadata storeFilesMetadata) {
        long sizeMatched = 0L;
        for (StoreFileMetadata storeFileMetadata : storeFilesMetadata) {
            String metadataFileName = storeFileMetadata.name();
            if (!primaryStore.fileExists(metadataFileName) || !primaryStore.file(metadataFileName).isSame(storeFileMetadata)) continue;
            sizeMatched += storeFileMetadata.length();
        }
        return sizeMatched;
    }

    private static boolean hasMatchingSyncId(TransportNodesListShardStoreMetadata.StoreFilesMetadata primaryStore, TransportNodesListShardStoreMetadata.StoreFilesMetadata replicaStore) {
        String primarySyncId = primaryStore.syncId();
        return primarySyncId != null && primarySyncId.equals(replicaStore.syncId());
    }

    private static MatchingNode computeMatchingNode(DiscoveryNode primaryNode, TransportNodesListShardStoreMetadata.StoreFilesMetadata primaryStore, DiscoveryNode replicaNode, TransportNodesListShardStoreMetadata.StoreFilesMetadata replicaStore) {
        long retainingSeqNoForPrimary = primaryStore.getPeerRecoveryRetentionLeaseRetainingSeqNo(primaryNode);
        long retainingSeqNoForReplica = primaryStore.getPeerRecoveryRetentionLeaseRetainingSeqNo(replicaNode);
        boolean isNoopRecovery = retainingSeqNoForReplica >= retainingSeqNoForPrimary && retainingSeqNoForPrimary >= 0L || ReplicaShardAllocator.hasMatchingSyncId(primaryStore, replicaStore);
        long matchingBytes = ReplicaShardAllocator.computeMatchingBytes(primaryStore, replicaStore);
        return new MatchingNode(matchingBytes, retainingSeqNoForReplica, isNoopRecovery);
    }

    private static boolean canPerformOperationBasedRecovery(TransportNodesListShardStoreMetadata.StoreFilesMetadata primaryStore, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores, DiscoveryNode targetNode) {
        TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata targetNodeStore = shardStores.getData().get(targetNode);
        if (targetNodeStore == null || targetNodeStore.storeFilesMetadata().isEmpty()) {
            return false;
        }
        if (ReplicaShardAllocator.hasMatchingSyncId(primaryStore, targetNodeStore.storeFilesMetadata())) {
            return true;
        }
        return primaryStore.getPeerRecoveryRetentionLeaseRetainingSeqNo(targetNode) >= 0L;
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(ShardRouting var1, RoutingAllocation var2);

    protected abstract boolean hasInitiatedFetching(ShardRouting var1);

    private record MatchingNodes(Map<DiscoveryNode, MatchingNode> matchingNodes, @Nullable Map<String, NodeAllocationResult> nodeDecisions, @Nullable DiscoveryNode nodeWithHighestMatch) {
        boolean canPerformNoopRecovery(DiscoveryNode node) {
            return this.matchingNodes.get((Object)node).isNoopRecovery;
        }

        public boolean hasAnyData() {
            return !this.matchingNodes.isEmpty();
        }

        private static MatchingNodes create(Map<DiscoveryNode, MatchingNode> matchingNodes, @Nullable Map<String, NodeAllocationResult> nodeDecisions) {
            return new MatchingNodes(matchingNodes, nodeDecisions, MatchingNodes.getNodeWithHighestMatch(matchingNodes));
        }

        @Nullable
        private static DiscoveryNode getNodeWithHighestMatch(Map<DiscoveryNode, MatchingNode> matchingNodes) {
            return matchingNodes.entrySet().stream().filter(e -> ((MatchingNode)e.getValue()).anyMatch()).max(Map.Entry.comparingByValue(MatchingNode.COMPARATOR)).map(Map.Entry::getKey).orElse(null);
        }
    }

    public record PerNodeAllocationResult(Decision decision, List<NodeAllocationResult> nodes) {
    }

    private record MatchingNode(long matchingBytes, long retainingSeqNo, boolean isNoopRecovery) {
        static final Comparator<MatchingNode> COMPARATOR = Comparator.comparing(m -> m.isNoopRecovery).thenComparing(m -> m.retainingSeqNo).thenComparing(m -> m.matchingBytes);

        boolean anyMatch() {
            return this.isNoopRecovery || this.retainingSeqNo >= 0L || this.matchingBytes > 0L;
        }
    }
}

