/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class ThrottledIterator<T>
implements Releasable {
    private static final Logger logger = LogManager.getLogger(ThrottledIterator.class);
    private final RefCounted refs;
    private final Iterator<T> iterator;
    private final BiConsumer<Releasable, T> itemConsumer;
    private final Semaphore permits;
    private final Runnable onItemCompletion;

    public static <T> void run(Iterator<T> iterator, BiConsumer<Releasable, T> itemConsumer, int maxConcurrency, Runnable onItemCompletion, Runnable onCompletion) {
        try (ThrottledIterator<T> throttledIterator = new ThrottledIterator<T>(iterator, itemConsumer, maxConcurrency, onItemCompletion, onCompletion);){
            throttledIterator.run();
        }
    }

    private ThrottledIterator(Iterator<T> iterator, BiConsumer<Releasable, T> itemConsumer, int maxConcurrency, Runnable onItemCompletion, Runnable onCompletion) {
        this.iterator = Objects.requireNonNull(iterator);
        this.itemConsumer = Objects.requireNonNull(itemConsumer);
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency must be positive");
        }
        this.permits = new Semaphore(maxConcurrency);
        this.onItemCompletion = Objects.requireNonNull(onItemCompletion);
        this.refs = AbstractRefCounted.of(onCompletion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (this.permits.tryAcquire()) {
            T item;
            Iterator<T> iterator = this.iterator;
            synchronized (iterator) {
                if (!this.iterator.hasNext()) {
                    this.permits.release();
                    return;
                }
                item = this.iterator.next();
            }
            try (ItemRefCounted itemRefs = new ItemRefCounted();){
                itemRefs.mustIncRef();
                this.itemConsumer.accept(Releasables.releaseOnce(itemRefs::decRef), (Releasable)item);
            }
            catch (Exception e) {
                logger.error(Strings.format("exception when processing [%s] with [%s]", item, this.itemConsumer), (Throwable)e);
                assert (false) : e;
            }
        }
    }

    @Override
    public void close() {
        this.refs.decRef();
    }

    private class ItemRefCounted
    extends AbstractRefCounted
    implements Releasable {
        private boolean isRecursive = true;

        ItemRefCounted() {
            ThrottledIterator.this.refs.mustIncRef();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void closeInternal() {
            try {
                ThrottledIterator.this.onItemCompletion.run();
            }
            catch (Exception e) {
                logger.error("exception in onItemCompletion", (Throwable)e);
                assert (false) : e;
            }
            finally {
                ThrottledIterator.this.permits.release();
                try {
                    if (!this.isRecursive()) {
                        ThrottledIterator.this.run();
                    }
                }
                finally {
                    ThrottledIterator.this.refs.decRef();
                }
            }
        }

        private synchronized boolean isRecursive() {
            return this.isRecursive;
        }

        @Override
        public synchronized void close() {
            this.decRef();
            this.isRecursive = false;
        }
    }
}

