/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import org.elasticsearch.common.util.AbstractHash;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;

public final class LongHash
extends AbstractHash {
    private LongArray keys;

    public LongHash(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongHash(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        try {
            this.keys = bigArrays.newLongArray(capacity, false);
        }
        finally {
            if (this.keys == null) {
                this.close();
            }
        }
    }

    public long get(long id) {
        return this.keys.get(id);
    }

    public long find(long key) {
        long slot;
        long index = slot = LongHash.slot(LongHash.hash(key), this.mask);
        long id;
        while ((id = this.id(index)) != -1L && this.keys.get(id) != key) {
            index = LongHash.nextSlot(index, this.mask);
        }
        return id;
    }

    private long set(long key, long id) {
        long slot;
        assert (this.size < this.maxSize);
        long index = slot = LongHash.slot(LongHash.hash(key), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) {
                this.id(index, id);
                this.append(id, key);
                ++this.size;
                return id;
            }
            if (this.keys.get(curId) == key) {
                return -1L - curId;
            }
            index = LongHash.nextSlot(index, this.mask);
        }
    }

    private void append(long id, long key) {
        this.keys = this.bigArrays.grow(this.keys, id + 1L);
        this.keys.set(id, key);
    }

    private void reset(long key, long id) {
        long slot;
        long index = slot = LongHash.slot(LongHash.hash(key), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) break;
            index = LongHash.nextSlot(index, this.mask);
        }
        this.id(index, id);
        this.append(id, key);
    }

    public long add(long key) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key, this.size);
    }

    @Override
    protected void removeAndAdd(long index) {
        long id = this.id(index, -1L);
        assert (id >= 0L);
        long key = this.keys.getAndSet(id, 0L);
        this.reset(key, id);
    }

    @Override
    public void close() {
        try (LongArray releasable = this.keys;){
            super.close();
        }
    }
}

