/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.AbstractArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.Releasables;

abstract class AbstractBigArray
extends AbstractArray {
    protected final PageCacheRecycler recycler;
    private Recycler.V<?>[] cache;
    private final int pageShift;
    private final int pageMask;
    protected long size;

    protected AbstractBigArray(int pageSize, BigArrays bigArrays, boolean clearOnResize) {
        super(bigArrays, clearOnResize);
        this.recycler = bigArrays.recycler;
        if (pageSize < 128) {
            throw new IllegalArgumentException("pageSize must be >= 128");
        }
        if ((pageSize & pageSize - 1) != 0) {
            throw new IllegalArgumentException("pageSize must be a power of two");
        }
        this.pageShift = Integer.numberOfTrailingZeros(pageSize);
        this.pageMask = pageSize - 1;
        this.size = 0L;
        this.cache = this.recycler != null ? new Recycler.V[16] : null;
    }

    final int numPages(long capacity) {
        long numPages = capacity + (long)this.pageMask >>> this.pageShift;
        if (numPages > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("pageSize=" + (this.pageMask + 1) + " is too small for such as capacity: " + capacity);
        }
        return (int)numPages;
    }

    final int pageSize() {
        return this.pageMask + 1;
    }

    final int pageIndex(long index) {
        return (int)(index >>> this.pageShift);
    }

    final int indexInPage(long index) {
        return (int)(index & (long)this.pageMask);
    }

    @Override
    public final long size() {
        return this.size;
    }

    public abstract void resize(long var1);

    protected abstract int numBytesPerElement();

    @Override
    public final long ramBytesUsed() {
        return this.ramBytesEstimated(this.size);
    }

    public final long ramBytesEstimated(long size) {
        return ((long)this.pageIndex(size - 1L) + 1L) * (long)this.pageSize() * (long)this.numBytesPerElement();
    }

    private static <T> T[] grow(T[] array, int minSize) {
        if (array.length < minSize) {
            int newLen = ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            array = Arrays.copyOf(array, newLen);
        }
        return array;
    }

    protected <T> T registerNewPage(Recycler.V<T> v, int page, int expectedSize) {
        this.cache = AbstractBigArray.grow(this.cache, page + 1);
        assert (this.cache[page] == null);
        this.cache[page] = v;
        assert (Array.getLength(v.v()) == expectedSize);
        return v.v();
    }

    protected final void releasePage(int page) {
        if (this.recycler != null) {
            assert (this.cache[page] != null);
            this.cache[page].close();
            this.cache[page] = null;
        }
    }

    @Override
    protected final void doClose() {
        if (this.recycler != null) {
            Releasables.close(this.cache);
            this.cache = null;
        }
    }
}

