/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.threadpool.ThreadPool;

public class ThreadWatchdog {
    public static final Setting<TimeValue> NETWORK_THREAD_WATCHDOG_INTERVAL = Setting.timeSetting("network.thread.watchdog.interval", TimeValue.timeValueSeconds(5L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> NETWORK_THREAD_WATCHDOG_QUIET_TIME = Setting.timeSetting("network.thread.watchdog.quiet_time", TimeValue.timeValueMinutes(10L), Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(ThreadWatchdog.class);
    private final ThreadLocal<ActivityTracker> activityTrackerThreadLocal = new ThreadLocal();
    private final List<WeakReference<ActivityTracker>> knownTrackers = new ArrayList<WeakReference<ActivityTracker>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityTracker getActivityTrackerForCurrentThread() {
        ActivityTracker result = this.activityTrackerThreadLocal.get();
        if (result == null) {
            result = new ActivityTracker();
            List<WeakReference<ActivityTracker>> list = this.knownTrackers;
            synchronized (list) {
                this.knownTrackers.add(new WeakReference<ActivityTracker>(result));
            }
            this.activityTrackerThreadLocal.set(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getStuckThreadNames() {
        ArrayList<String> stuckThreadNames = null;
        List<WeakReference<ActivityTracker>> list = this.knownTrackers;
        synchronized (list) {
            Iterator<WeakReference<ActivityTracker>> iterator = this.knownTrackers.iterator();
            while (iterator.hasNext()) {
                ActivityTracker tracker = (ActivityTracker)iterator.next().get();
                if (tracker == null) {
                    iterator.remove();
                    continue;
                }
                if (tracker.isIdleOrMakingProgress()) continue;
                if (stuckThreadNames == null) {
                    stuckThreadNames = new ArrayList<String>();
                }
                stuckThreadNames.add(tracker.getTrackedThreadName());
            }
        }
        if (stuckThreadNames == null) {
            return List.of();
        }
        stuckThreadNames.sort(Comparator.naturalOrder());
        return stuckThreadNames;
    }

    public void run(Settings settings, ThreadPool threadPool, Lifecycle lifecycle) {
        new Checker(threadPool, NETWORK_THREAD_WATCHDOG_INTERVAL.get(settings), NETWORK_THREAD_WATCHDOG_QUIET_TIME.get(settings), lifecycle).run();
    }

    public static final class ActivityTracker
    extends AtomicLong {
        private final Thread trackedThread = Thread.currentThread();
        private long lastObservedValue;

        String getTrackedThreadName() {
            return this.trackedThread.getName();
        }

        public void startActivity() {
            assert (this.trackedThread == Thread.currentThread()) : this.trackedThread.getName() + " vs " + Thread.currentThread().getName();
            long prevValue = this.getAndIncrement();
            assert (ActivityTracker.isIdle(prevValue)) : "thread [" + this.trackedThread.getName() + "] was already active";
        }

        public void stopActivity() {
            assert (this.trackedThread == Thread.currentThread()) : this.trackedThread.getName() + " vs " + Thread.currentThread().getName();
            long prevValue = this.getAndIncrement();
            assert (!ActivityTracker.isIdle(prevValue)) : "thread [" + this.trackedThread.getName() + "] was already idle";
        }

        boolean isIdleOrMakingProgress() {
            long value = this.get();
            if (ActivityTracker.isIdle(value)) {
                return true;
            }
            if (value == this.lastObservedValue) {
                return false;
            }
            this.lastObservedValue = value;
            return true;
        }

        private static boolean isIdle(long value) {
            return (value & 1L) == 0L;
        }
    }

    private final class Checker
    extends AbstractRunnable {
        private final ThreadPool threadPool;
        private final TimeValue interval;
        private final TimeValue quietTime;
        private final Lifecycle lifecycle;
        private final AbstractRunnable threadDumper = new AbstractRunnable(){

            @Override
            protected void doRun() {
                assert (ThreadPool.assertCurrentThreadPool("generic"));
                if (Checker.this.isRunning()) {
                    HotThreads.logLocalHotThreads(logger, Level.WARN, "hot threads dump due to active threads not making progress", ReferenceDocs.NETWORK_THREADING_MODEL);
                }
            }

            @Override
            public boolean isForceExecution() {
                return true;
            }

            @Override
            public void onFailure(Exception e) {
                Checker.this.onFailure(e);
            }

            @Override
            public void onRejection(Exception e) {
                Checker.this.onRejection(e);
            }

            @Override
            public void onAfter() {
                Checker.this.scheduleNext(Checker.this.quietTime);
            }

            public String toString() {
                return "ThreadWatchDog$Checker#threadDumper";
            }
        };

        Checker(ThreadPool threadPool, TimeValue interval, TimeValue quietTime, Lifecycle lifecycle) {
            this.threadPool = threadPool;
            this.interval = interval;
            this.quietTime = quietTime.compareTo(interval) <= 0 ? interval : quietTime;
            this.lifecycle = lifecycle;
            assert (this.interval.millis() <= this.quietTime.millis());
        }

        @Override
        protected void doRun() {
            if (!this.isRunning()) {
                return;
            }
            boolean rescheduleImmediately = true;
            try {
                List<String> stuckThreadNames = ThreadWatchdog.this.getStuckThreadNames();
                if (!stuckThreadNames.isEmpty()) {
                    logger.warn("the following threads are active but did not make progress in the preceding [{}]: {}", (Object)this.interval, stuckThreadNames);
                    rescheduleImmediately = false;
                    this.threadPool.generic().execute(this.threadDumper);
                }
            }
            finally {
                if (rescheduleImmediately) {
                    this.scheduleNext(this.interval);
                }
            }
        }

        @Override
        public boolean isForceExecution() {
            return true;
        }

        private boolean isRunning() {
            return 0L < this.interval.millis() && !this.lifecycle.stoppedOrClosed();
        }

        private void scheduleNext(TimeValue delay) {
            if (this.isRunning()) {
                this.threadPool.scheduleUnlessShuttingDown(delay, EsExecutors.DIRECT_EXECUTOR_SERVICE, this);
            }
        }

        @Override
        public void onFailure(Exception e) {
            logger.error("exception in ThreadWatchDog$Checker", (Throwable)e);
            assert (false) : e;
        }

        @Override
        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            logger.debug("ThreadWatchDog$Checker execution rejected", (Throwable)e);
            assert (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) : e;
        }

        public String toString() {
            return "ThreadWatchDog$Checker";
        }
    }
}

