/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.util.BytesRef;

public class BytesRefs {
    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            return ((BytesRef)value).utf8ToString();
        }
        return value.toString();
    }

    public static BytesRef toBytesRef(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            return (BytesRef)value;
        }
        return new BytesRef(value.toString());
    }

    public static BytesRef checkIndexableLength(BytesRef input) {
        if (input.length > 32766) {
            throw new IllegalArgumentException("Term is longer than maximum indexable length, term starting with [" + BytesRefs.safeStringPrefix(input, 10));
        }
        return input;
    }

    private static String safeStringPrefix(BytesRef input, int prefixLength) {
        BytesRef prefix = new BytesRef(input.bytes, input.offset, prefixLength);
        try {
            return prefix.utf8ToString();
        }
        catch (Exception e) {
            return prefix.toString();
        }
    }
}

