/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.filesystem;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.OptionalLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.filesystem.FileSystemNatives;
import org.elasticsearch.core.Strings;

final class PosixFileSystemNatives
implements FileSystemNatives.Provider {
    private static final Logger logger = LogManager.getLogger(PosixFileSystemNatives.class);
    private static final PosixFileSystemNatives INSTANCE = new PosixFileSystemNatives();
    private static final long ST_BLOCKS_UNIT = 512L;
    private final Stat64Library lib;

    private static int loadStatVersion() {
        return "aarch64".equalsIgnoreCase(Constants.OS_ARCH) ? 0 : 1;
    }

    private PosixFileSystemNatives() {
        Stat64Library statFunction;
        assert (Constants.JRE_IS_64BIT) : Constants.OS_ARCH;
        try {
            NativeLibrary libc = NativeLibrary.getInstance((String)Platform.C_LIBRARY_NAME);
            libc.getFunction("stat64");
            statFunction = (Stat64Library)Native.load((String)Platform.C_LIBRARY_NAME, Stat64Library.class);
        }
        catch (UnsatisfiedLinkError e) {
            XStatLibrary xstat = (XStatLibrary)Native.load((String)Platform.C_LIBRARY_NAME, XStatLibrary.class);
            int version = PosixFileSystemNatives.loadStatVersion();
            statFunction = (path, stats) -> xstat.__xstat(version, path, stats);
        }
        this.lib = statFunction;
        logger.debug("C library loaded");
    }

    static PosixFileSystemNatives getInstance() {
        return INSTANCE;
    }

    @Override
    public OptionalLong allocatedSizeInBytes(Path path) {
        assert (Files.isRegularFile(path, new LinkOption[0])) : path;
        try {
            Stat stats = new Stat(Constants.LINUX ? 64 : 104);
            int rc = this.lib.stat64(path.toString(), (Pointer)stats.memory);
            if (logger.isTraceEnabled()) {
                logger.trace("executing native method __xstat() returned {} with error code [{}] for file [{}]", (Object)stats, (Object)rc, (Object)path);
            }
            return OptionalLong.of(stats.getBlocks() * 512L);
        }
        catch (LastErrorException e) {
            logger.warn(() -> Strings.format("error when executing native method __xstat(int vers, const char *name, struct stat *buf) for file [%s]", path), (Throwable)e);
            return OptionalLong.empty();
        }
    }

    public static interface Stat64Library
    extends Library {
        public int stat64(String var1, Pointer var2) throws LastErrorException;
    }

    public static interface XStatLibrary
    extends Library {
        public int __xstat(int var1, String var2, Pointer var3) throws LastErrorException;
    }

    public static class Stat {
        final Memory memory = new Memory(144L);
        final int blocksOffset;

        Stat(int blocksOffset) {
            this.blocksOffset = blocksOffset;
        }

        public long getBlocks() {
            return this.memory.getLong((long)this.blocksOffset);
        }

        public String toString() {
            return "Stat [blocks=" + this.getBlocks() + "]";
        }
    }
}

