/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreDefinition;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataMigrateToDataStreamService {
    private static final Logger logger = LogManager.getLogger(MetadataMigrateToDataStreamService.class);
    private static final CompressedXContent TIMESTAMP_MAPPING;
    private final ClusterService clusterService;
    private final IndicesService indexServices;
    private final ThreadContext threadContext;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final boolean isDslOnlyMode;

    public MetadataMigrateToDataStreamService(ThreadPool threadPool, ClusterService clusterService, IndicesService indexServices, MetadataCreateIndexService metadataCreateIndexService) {
        this.clusterService = clusterService;
        this.indexServices = indexServices;
        this.threadContext = threadPool.getThreadContext();
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.isDslOnlyMode = DataStreamLifecycle.isDataStreamsLifecycleOnlyMode(clusterService.getSettings());
    }

    public void migrateToDataStream(final MigrateToDataStreamClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        this.metadataCreateIndexService.getSystemIndices().validateDataStreamAccess(request.aliasName, this.threadContext);
        final AtomicReference writeIndexRef = new AtomicReference();
        ActionListener<AcknowledgedResponse> listener = finalListener.delegateFailureAndWrap((delegate, response) -> {
            if (response.isAcknowledged()) {
                String writeIndexName = (String)writeIndexRef.get();
                assert (writeIndexName != null);
                ActiveShardsObserver.waitForActiveShards(this.clusterService, new String[]{writeIndexName}, ActiveShardCount.DEFAULT, request.masterNodeTimeout(), delegate.map(shardsAcknowledged -> AcknowledgedResponse.TRUE));
            } else {
                delegate.onResponse(AcknowledgedResponse.FALSE);
            }
        });
        final AllocationActionListener<AcknowledgedResponse> delegate2 = new AllocationActionListener<AcknowledgedResponse>(listener, this.threadContext);
        this.submitUnbatchedTask("migrate-to-data-stream [" + request.aliasName + "]", new AckedClusterStateUpdateTask(Priority.HIGH, request, delegate2.clusterStateUpdate()){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState = MetadataMigrateToDataStreamService.migrateToDataStream(currentState, MetadataMigrateToDataStreamService.this.isDslOnlyMode, indexMetadata -> {
                    try {
                        return MetadataMigrateToDataStreamService.this.indexServices.createIndexMapperServiceForValidation((IndexMetadata)indexMetadata);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }, request, MetadataMigrateToDataStreamService.this.metadataCreateIndexService, MetadataMigrateToDataStreamService.this.clusterService.getSettings(), delegate2.reroute());
                writeIndexRef.set(clusterState.metadata().dataStreams().get(request.aliasName).getWriteIndex().getName());
                return clusterState;
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState migrateToDataStream(ClusterState currentState, boolean isDslOnlyMode, Function<IndexMetadata, MapperService> mapperSupplier, MigrateToDataStreamClusterStateUpdateRequest request, MetadataCreateIndexService metadataCreateIndexService, Settings settings, ActionListener<Void> listener) throws Exception {
        MetadataMigrateToDataStreamService.validateRequest(currentState, request);
        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)currentState.metadata().getIndicesLookup().get(request.aliasName);
        MetadataMigrateToDataStreamService.validateBackingIndices(currentState, request.aliasName);
        Metadata.Builder mb = Metadata.builder(currentState.metadata());
        for (Index index : alias.getIndices()) {
            IndexMetadata im = currentState.metadata().index(index);
            MetadataMigrateToDataStreamService.prepareBackingIndex(mb, im, request.aliasName, mapperSupplier, true);
        }
        currentState = ClusterState.builder(currentState).metadata(mb).build();
        Index writeIndex = alias.getWriteIndex();
        ClusterState finalCurrentState = currentState;
        List<IndexMetadata> backingIndices = alias.getIndices().stream().filter(x -> writeIndex == null || !x.equals(writeIndex)).map(x -> finalCurrentState.metadata().index((Index)x)).toList();
        logger.info("submitting request to migrate alias [{}] to a data stream", (Object)request.aliasName);
        MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest req = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(request.aliasName);
        return MetadataCreateDataStreamService.createDataStream(metadataCreateIndexService, settings, currentState, isDslOnlyMode, req, backingIndices, currentState.metadata().index(writeIndex), listener, false);
    }

    static void validateRequest(ClusterState currentState, MigrateToDataStreamClusterStateUpdateRequest request) {
        IndexAbstraction ia = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(request.aliasName);
        if (ia == null || ia.getType() != IndexAbstraction.Type.ALIAS) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] does not exist");
        }
        if (ia.getWriteIndex() == null) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] must specify a write index");
        }
        AliasMetadata aliasMetadata = AliasMetadata.getFirstAliasMetadata(currentState.metadata(), ia);
        assert (aliasMetadata != null) : "alias metadata may not be null";
        if (aliasMetadata.filteringRequired() || aliasMetadata.getIndexRouting() != null || aliasMetadata.getSearchRouting() != null) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] may not have custom filtering or routing");
        }
    }

    static void prepareBackingIndex(Metadata.Builder b, IndexMetadata im, String dataStreamName, Function<IndexMetadata, MapperService> mapperSupplier, boolean removeAlias) throws IOException {
        MetadataMigrateToDataStreamService.prepareBackingIndex(b, im, dataStreamName, mapperSupplier, removeAlias, false, Settings.EMPTY);
    }

    static void prepareBackingIndex(Metadata.Builder b, IndexMetadata im, String dataStreamName, Function<IndexMetadata, MapperService> mapperSupplier, boolean removeAlias, boolean failureStore, Settings nodeSettings) throws IOException {
        MappingMetadata mm = im.mapping();
        if (mm == null) {
            throw new IllegalArgumentException("backing index [" + im.getIndex().getName() + "] must have mappings for a timestamp field");
        }
        MapperService mapperService = mapperSupplier.apply(im);
        mapperService.merge(im, MapperService.MergeReason.MAPPING_RECOVERY);
        mapperService.merge("_doc", TIMESTAMP_MAPPING, MapperService.MergeReason.MAPPING_UPDATE);
        DocumentMapper mapper = mapperService.documentMapper();
        IndexMetadata.Builder imb = IndexMetadata.builder(im);
        if (removeAlias) {
            imb.removeAlias(dataStreamName);
        }
        Settings.Builder settingsUpdate = Settings.builder().put(im.getSettings()).put("index.hidden", true);
        if (failureStore) {
            DataStreamFailureStoreDefinition.applyFailureStoreSettings(nodeSettings, settingsUpdate);
        }
        imb.settings(settingsUpdate.build()).settingsVersion(im.getSettingsVersion() + 1L).mappingVersion(im.getMappingVersion() + 1L).mappingsUpdatedVersion(IndexVersion.current()).putMapping(new MappingMetadata(mapper));
        b.put(imb);
    }

    static void validateBackingIndices(ClusterState currentState, String dataStreamName) {
        IndexAbstraction ia = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(dataStreamName);
        if (ia == null || ia.getType() != IndexAbstraction.Type.ALIAS) {
            throw new IllegalArgumentException("alias [" + dataStreamName + "] does not exist");
        }
        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)ia;
        ArrayList<String> indicesWithOtherAliases = new ArrayList<String>();
        for (Index index : alias.getIndices()) {
            IndexMetadata im = currentState.metadata().index(index);
            if (im.getAliases().size() <= 1 && im.getAliases().containsKey(alias.getName())) continue;
            indicesWithOtherAliases.add(index.getName());
        }
        if (indicesWithOtherAliases.size() > 0) {
            throw new IllegalArgumentException("other aliases referencing indices [" + Strings.collectionToCommaDelimitedString(indicesWithOtherAliases) + "] must be removed before migrating to a data stream");
        }
    }

    static {
        try {
            TIMESTAMP_MAPPING = new CompressedXContent((builder, params) -> builder.startObject("_data_stream_timestamp").field("enabled", true).endObject());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class MigrateToDataStreamClusterStateUpdateRequest
    extends ClusterStateUpdateRequest {
        private final String aliasName;

        public MigrateToDataStreamClusterStateUpdateRequest(String aliasName, TimeValue masterNodeTimeout, TimeValue timeout) {
            this.aliasName = aliasName;
            this.masterNodeTimeout(masterNodeTimeout);
            this.ackTimeout(timeout);
        }
    }
}

