/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public class IndexTemplateMetadata
implements SimpleDiffable<IndexTemplateMetadata> {
    private final String name;
    private final int order;
    @Nullable
    private final Integer version;
    private final List<String> patterns;
    private final Settings settings;
    private final Map<String, CompressedXContent> mappings;
    private final Map<String, AliasMetadata> aliases;

    public IndexTemplateMetadata(String name, int order, Integer version, List<String> patterns, Settings settings, Map<String, CompressedXContent> mappings, Map<String, AliasMetadata> aliases) {
        if (patterns == null || patterns.isEmpty()) {
            throw new IllegalArgumentException("Index patterns must not be null or empty; got " + patterns);
        }
        this.name = name;
        this.order = order;
        this.version = version;
        this.patterns = patterns;
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    public int getOrder() {
        return this.order();
    }

    @Nullable
    public Integer getVersion() {
        return this.version();
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Settings settings() {
        return this.settings;
    }

    public CompressedXContent mappings() {
        if (this.mappings.isEmpty()) {
            return null;
        }
        return this.mappings.values().iterator().next();
    }

    public CompressedXContent getMappings() {
        return this.mappings();
    }

    public Map<String, AliasMetadata> aliases() {
        return this.aliases;
    }

    public Map<String, AliasMetadata> getAliases() {
        return this.aliases;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetadata that = (IndexTemplateMetadata)o;
        if (this.order != that.order) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (!this.patterns.equals(that.patterns)) {
            return false;
        }
        return Objects.equals(this.aliases, that.aliases) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.order;
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + this.patterns.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        result = 31 * result + this.aliases.hashCode();
        return result;
    }

    public static IndexTemplateMetadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.order(in.readInt());
        builder.patterns(in.readStringCollectionAsList());
        builder.settings(Settings.readSettingsFromStream(in));
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            builder.putMapping(in.readString(), CompressedXContent.readCompressedString(in));
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetadata aliasMd = new AliasMetadata(in);
            builder.putAlias(aliasMd);
        }
        builder.version(in.readOptionalVInt());
        return builder.build();
    }

    public static Diff<IndexTemplateMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(IndexTemplateMetadata::readFrom, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.order);
        out.writeStringCollection(this.patterns);
        this.settings.writeTo(out);
        out.writeMap(this.mappings, StreamOutput::writeWriteable);
        out.writeCollection(this.aliases.values());
        out.writeOptionalVInt(this.version);
    }

    public String toString() {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            Builder.toXContentWithTypes(this, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final class Builder {
        private static final Set<String> VALID_FIELDS = Set.of("order", "mappings", "settings", "index_patterns", "aliases", "version");
        private String name;
        private int order;
        private Integer version;
        private List<String> indexPatterns;
        private Settings settings = Settings.EMPTY;
        private final Map<String, CompressedXContent> mappings;
        private final Map<String, AliasMetadata> aliases;

        public Builder(String name) {
            this.name = name;
            this.mappings = new HashMap<String, CompressedXContent>();
            this.aliases = new HashMap<String, AliasMetadata>();
        }

        public Builder(IndexTemplateMetadata indexTemplateMetadata) {
            this.name = indexTemplateMetadata.name();
            this.order(indexTemplateMetadata.order());
            this.version(indexTemplateMetadata.version());
            this.patterns(indexTemplateMetadata.patterns());
            this.settings(indexTemplateMetadata.settings());
            this.mappings = new HashMap<String, CompressedXContent>(indexTemplateMetadata.mappings);
            this.aliases = new HashMap<String, AliasMetadata>(indexTemplateMetadata.aliases());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder putMapping(String mappingType, CompressedXContent mappingSource) {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            this.mappings.put(mappingType, new CompressedXContent(mappingSource));
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata.build());
            return this;
        }

        public IndexTemplateMetadata build() {
            return new IndexTemplateMetadata(this.name, this.order, this.version, this.indexPatterns, this.settings, Map.copyOf(this.mappings), Map.copyOf(this.aliases));
        }

        public static XContentBuilder toXContentWithTypes(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetadata.name());
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, true);
            return builder.endObject();
        }

        public static void removeType(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder) throws IOException {
            builder.startObject();
            Builder.toInnerXContent(indexTemplateMetadata, builder, new ToXContent.MapParams(Collections.singletonMap("reduce_mappings", "true")), false);
            builder.endObject();
        }

        public static void toXContent(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetadata.name());
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, false);
            builder.endObject();
        }

        static void toInnerXContentWithTypes(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            Builder.toInnerXContent(indexTemplateMetadata, builder, params, true);
        }

        private static void toInnerXContent(IndexTemplateMetadata indexTemplateMetadata, XContentBuilder builder, ToXContent.Params params, boolean includeTypeName) throws IOException {
            CompressedXContent m;
            builder.field("order", indexTemplateMetadata.order());
            if (indexTemplateMetadata.version() != null) {
                builder.field("version", indexTemplateMetadata.version());
            }
            builder.stringListField("index_patterns", indexTemplateMetadata.patterns());
            builder.startObject("settings");
            indexTemplateMetadata.settings().toXContent(builder, params);
            builder.endObject();
            if (builder.getRestApiVersion().matches(RestApiVersion.onOrAfter(RestApiVersion.V_8))) {
                includeTypeName &= !params.paramAsBoolean("reduce_mappings", false);
            }
            if ((m = indexTemplateMetadata.mappings()) != null) {
                Map<String, Object> documentMapping = XContentHelper.convertToMap(m.uncompressed(), true).v2();
                documentMapping = !includeTypeName ? Builder.reduceMapping(documentMapping) : Builder.reduceEmptyMapping(documentMapping);
                builder.field("mappings");
                builder.map(documentMapping);
            } else {
                builder.startObject("mappings").endObject();
            }
            builder.startObject("aliases");
            for (AliasMetadata aliasMetadata : indexTemplateMetadata.aliases().values()) {
                AliasMetadata.Builder.toXContent(aliasMetadata, builder, params);
            }
            builder.endObject();
        }

        private static Map<String, Object> reduceEmptyMapping(Map<String, Object> mapping) {
            if (mapping.keySet().size() == 1 && mapping.containsKey("_doc") && ((Map)mapping.get("_doc")).size() == 0) {
                return (Map)mapping.values().iterator().next();
            }
            return mapping;
        }

        private static Map<String, Object> reduceMapping(Map<String, Object> mapping) {
            assert (mapping.keySet().size() == 1) : mapping.keySet();
            return (Map)mapping.values().iterator().next();
        }

        public static IndexTemplateMetadata fromXContent(XContentParser parser, String templateName) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder(templateName);
            String currentFieldName = Builder.skipTemplateName(parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        Settings.Builder templateSettingsBuilder = Settings.builder();
                        templateSettingsBuilder.put(Settings.fromXContent(parser));
                        templateSettingsBuilder.normalizePrefix("index.");
                        builder.settings(templateSettingsBuilder.build());
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            builder.putMapping(currentFieldName, Strings.toString(XContentFactory.jsonBuilder().map(Map.of(currentFieldName, parser.mapOrdered()))));
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetadata.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("unknown key [{}] for index template", currentFieldName);
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            Map<String, Object> mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = mapping.keySet().iterator().next();
                            String mappingSource = Strings.toString(XContentFactory.jsonBuilder().map(mapping));
                            if (mappingSource == null) continue;
                            builder.putMapping(mappingType, mappingSource);
                        }
                        continue;
                    }
                    if (!"index_patterns".equals(currentFieldName)) continue;
                    ArrayList<String> index_patterns = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        index_patterns.add(parser.text());
                    }
                    builder.patterns(index_patterns);
                    continue;
                }
                if (!token.isValue()) continue;
                if ("order".equals(currentFieldName)) {
                    builder.order(parser.intValue());
                    continue;
                }
                if (!"version".equals(currentFieldName)) continue;
                builder.version(parser.intValue());
            }
            return builder.build();
        }

        private static String skipTemplateName(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (VALID_FIELDS.contains(currentFieldName)) {
                    return currentFieldName;
                }
                parser.nextToken();
            }
            return null;
        }
    }
}

