/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStreamFactoryRetention;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.core.Nullable;

public class DataStreamGlobalRetentionResolver {
    private final DataStreamFactoryRetention factoryRetention;

    public DataStreamGlobalRetentionResolver(DataStreamFactoryRetention factoryRetention) {
        this.factoryRetention = factoryRetention;
    }

    @Nullable
    public DataStreamGlobalRetention resolve(ClusterState clusterState) {
        DataStreamGlobalRetention globalRetentionFromClusterState = DataStreamGlobalRetention.getFromClusterState(clusterState);
        if (globalRetentionFromClusterState != null || !this.factoryRetention.isDefined()) {
            return globalRetentionFromClusterState;
        }
        return new DataStreamGlobalRetention(this.factoryRetention.getDefaultRetention(), this.factoryRetention.getMaxRetention());
    }
}

