/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.coordination.CoordinationDiagnosticsService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.node.HealthInfo;

public class StableMasterHealthIndicatorService
implements HealthIndicatorService {
    public static final String NAME = "master_is_stable";
    public static final Diagnosis TROUBLESHOOT_DISCOVERY = new Diagnosis(new Diagnosis.Definition("master_is_stable", "troubleshoot_discovery", "The Elasticsearch cluster does not have a stable master node.", "See discovery troubleshooting guidance at " + ReferenceDocs.DISCOVERY_TROUBLESHOOTING, ReferenceDocs.DISCOVERY_TROUBLESHOOTING.toString()), null);
    public static final Diagnosis TROUBLESHOOT_UNSTABLE_CLUSTER = new Diagnosis(new Diagnosis.Definition("master_is_stable", "troubleshoot_unstable_cluster", "The Elasticsearch cluster does not have a stable master node.", "See unstable cluster troubleshooting guidance at " + ReferenceDocs.UNSTABLE_CLUSTER_TROUBLESHOOTING, ReferenceDocs.UNSTABLE_CLUSTER_TROUBLESHOOTING.toString()), null);
    public static final Diagnosis CONTACT_SUPPORT = new Diagnosis(new Diagnosis.Definition("master_is_stable", "contact_support", "The Elasticsearch cluster does not have a stable master node.", "Get help at " + ReferenceDocs.CONTACT_SUPPORT, ReferenceDocs.CONTACT_SUPPORT.toString()), null);
    private final CoordinationDiagnosticsService coordinationDiagnosticsService;
    private final ClusterService clusterService;
    private static final String DETAILS_CURRENT_MASTER = "current_master";
    private static final String DETAILS_RECENT_MASTERS = "recent_masters";
    private static final String DETAILS_EXCEPTION_FETCHING_HISTORY = "exception_fetching_history";
    private static final String CLUSTER_FORMATION = "cluster_formation";
    private static final String CLUSTER_FORMATION_MESSAGE = "cluster_formation_message";
    public static final String INGEST_DISABLED_IMPACT_ID = "ingest_disabled";
    public static final String AUTOMATION_DISABLED_IMPACT_ID = "automation_disabled";
    public static final String BACKUP_DISABLED_IMPACT_ID = "backup_disabled";
    private static final String UNSTABLE_MASTER_INGEST_IMPACT = "The cluster cannot create, delete, or rebalance indices, and cannot insert or update documents.";
    private static final String UNSTABLE_MASTER_DEPLOYMENT_MANAGEMENT_IMPACT = "Scheduled tasks such as Watcher, Index Lifecycle Management, and Snapshot Lifecycle Management will not work. The _cat APIs will not work.";
    private static final String UNSTABLE_MASTER_BACKUP_IMPACT = "Snapshot and restore will not work. Your data will not be backed up, and searchable snapshots cannot be mounted.";
    private static final List<HealthIndicatorImpact> UNSTABLE_MASTER_IMPACTS = List.of(new HealthIndicatorImpact("master_is_stable", "ingest_disabled", 1, "The cluster cannot create, delete, or rebalance indices, and cannot insert or update documents.", List.of(ImpactArea.INGEST)), new HealthIndicatorImpact("master_is_stable", "automation_disabled", 1, "Scheduled tasks such as Watcher, Index Lifecycle Management, and Snapshot Lifecycle Management will not work. The _cat APIs will not work.", List.of(ImpactArea.DEPLOYMENT_MANAGEMENT)), new HealthIndicatorImpact("master_is_stable", "backup_disabled", 3, "Snapshot and restore will not work. Your data will not be backed up, and searchable snapshots cannot be mounted.", List.of(ImpactArea.BACKUP)));

    public StableMasterHealthIndicatorService(CoordinationDiagnosticsService coordinationDiagnosticsService, ClusterService clusterService) {
        this.coordinationDiagnosticsService = coordinationDiagnosticsService;
        this.clusterService = clusterService;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public boolean isPreflight() {
        return true;
    }

    @Override
    public HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
        CoordinationDiagnosticsService.CoordinationDiagnosticsResult coordinationDiagnosticsResult = this.coordinationDiagnosticsService.diagnoseMasterStability(verbose);
        return this.getHealthIndicatorResult(coordinationDiagnosticsResult, verbose);
    }

    HealthIndicatorResult getHealthIndicatorResult(CoordinationDiagnosticsService.CoordinationDiagnosticsResult coordinationDiagnosticsResult, boolean verbose) {
        HealthStatus status = HealthStatus.fromCoordinationDiagnosticsStatus(coordinationDiagnosticsResult.status());
        HealthIndicatorDetails details = this.getDetails(coordinationDiagnosticsResult.details(), verbose);
        List<HealthIndicatorImpact> impacts = status.indicatesHealthProblem() ? UNSTABLE_MASTER_IMPACTS : List.of();
        List<Diagnosis> diagnosis = status.indicatesHealthProblem() ? this.getUnstableMasterDiagnoses(verbose) : List.of();
        return this.createIndicator(status, coordinationDiagnosticsResult.summary(), details, impacts, diagnosis);
    }

    private HealthIndicatorDetails getDetails(CoordinationDiagnosticsService.CoordinationDiagnosticsDetails coordinationDiagnosticsDetails, boolean explain) {
        if (!explain) {
            return HealthIndicatorDetails.EMPTY;
        }
        return (builder, params) -> {
            String remoteHistoryExceptionMessage;
            builder.startObject();
            DiscoveryNode masterNode = coordinationDiagnosticsDetails.currentMaster();
            builder.object(DETAILS_CURRENT_MASTER, xContentBuilder -> {
                if (masterNode != null) {
                    builder.field("node_id", masterNode.getId());
                    builder.field("name", masterNode.getName());
                } else {
                    builder.nullField("node_id");
                    builder.nullField("name");
                }
            });
            List<DiscoveryNode> recentMasters = coordinationDiagnosticsDetails.recentMasters();
            if (recentMasters != null) {
                builder.array(DETAILS_RECENT_MASTERS, arrayXContentBuilder -> {
                    for (DiscoveryNode recentMaster : recentMasters) {
                        if (recentMaster == null) continue;
                        builder.startObject();
                        builder.field("node_id", recentMaster.getId());
                        builder.field("name", recentMaster.getName());
                        builder.endObject();
                    }
                });
            }
            if ((remoteHistoryExceptionMessage = coordinationDiagnosticsDetails.remoteExceptionMessage()) != null) {
                builder.object(DETAILS_EXCEPTION_FETCHING_HISTORY, xContentBuilder -> {
                    builder.field("message", remoteHistoryExceptionMessage);
                    builder.field("stack_trace", coordinationDiagnosticsDetails.remoteExceptionStackTrace());
                });
            }
            if (coordinationDiagnosticsDetails.nodeToClusterFormationDescriptionMap() != null) {
                builder.field(CLUSTER_FORMATION, (Iterable<?>)coordinationDiagnosticsDetails.nodeToClusterFormationDescriptionMap().entrySet().stream().map(entry -> {
                    String nodeName = this.getNameForNodeId((String)entry.getKey());
                    if (nodeName == null) {
                        return Map.of("node_id", (String)entry.getKey(), CLUSTER_FORMATION_MESSAGE, (String)entry.getValue());
                    }
                    return Map.of("node_id", (String)entry.getKey(), "name", nodeName, CLUSTER_FORMATION_MESSAGE, (String)entry.getValue());
                }).toList());
            }
            return builder.endObject();
        };
    }

    @Nullable
    private String getNameForNodeId(String nodeId) {
        DiscoveryNode node = this.clusterService.state().nodes().get(nodeId);
        if (node == null) {
            return null;
        }
        return node.getName();
    }

    private List<Diagnosis> getUnstableMasterDiagnoses(boolean verbose) {
        if (verbose) {
            return List.of(TROUBLESHOOT_DISCOVERY, TROUBLESHOOT_UNSTABLE_CLUSTER, CONTACT_SUPPORT);
        }
        return List.of();
    }
}

