/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record DiskUsage(String nodeId, String nodeName, String path, long totalBytes, long freeBytes) implements ToXContentFragment,
Writeable
{
    private static final Logger logger = LogManager.getLogger(DiskUsage.class);

    public DiskUsage(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readString(), in.readVLong(), in.readVLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeString(this.nodeName);
        out.writeString(this.path);
        out.writeVLong(this.totalBytes);
        out.writeVLong(this.freeBytes);
    }

    private static double truncatePercent(double pct) {
        return (double)Math.round(pct * 10.0) / 10.0;
    }

    XContentBuilder toShortXContent(XContentBuilder builder) throws IOException {
        builder.field("path", this.path);
        builder.humanReadableField("total_bytes", "total", ByteSizeValue.ofBytes(this.totalBytes));
        builder.humanReadableField("used_bytes", "used", ByteSizeValue.ofBytes(this.usedBytes()));
        builder.humanReadableField("free_bytes", "free", ByteSizeValue.ofBytes(this.freeBytes));
        builder.field("free_disk_percent", DiskUsage.truncatePercent(this.freeDiskAsPercentage()));
        builder.field("used_disk_percent", DiskUsage.truncatePercent(this.usedDiskAsPercentage()));
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("node_id", this.nodeId);
        builder.field("node_name", this.nodeName);
        this.toShortXContent(builder);
        return builder;
    }

    public double freeDiskAsPercentage() {
        if (this.totalBytes == 0L) {
            return 100.0;
        }
        return 100.0 * (double)this.freeBytes / (double)this.totalBytes;
    }

    public double usedDiskAsPercentage() {
        return 100.0 - this.freeDiskAsPercentage();
    }

    public long usedBytes() {
        return this.totalBytes - this.freeBytes;
    }

    @Override
    public String toString() {
        return "[" + this.nodeId + "][" + this.nodeName + "][" + this.path + "] free: " + ByteSizeValue.ofBytes(this.freeBytes()) + "[" + Strings.format1Decimals(this.freeDiskAsPercentage(), "%") + "]";
    }

    public DiskUsage copyWithFreeBytes(long freeBytes) {
        return new DiskUsage(this.nodeId, this.nodeName, this.path, this.totalBytes, freeBytes);
    }

    @Nullable
    public static DiskUsage findLeastAvailablePath(NodeStats nodeStats) {
        if (nodeStats.getFs() == null) {
            logger.warn("node [{}/{}] did not return any filesystem stats", (Object)nodeStats.getNode().getName(), (Object)nodeStats.getNode().getId());
            return null;
        }
        FsInfo.Path leastAvailablePath = null;
        for (FsInfo.Path info : nodeStats.getFs()) {
            if (leastAvailablePath == null) {
                leastAvailablePath = info;
                continue;
            }
            if (leastAvailablePath.getAvailable().getBytes() <= info.getAvailable().getBytes()) continue;
            leastAvailablePath = info;
        }
        if (leastAvailablePath == null) {
            logger.warn("node [{}/{}] did not return any filesystem stats", (Object)nodeStats.getNode().getName(), (Object)nodeStats.getNode().getId());
            return null;
        }
        String nodeId = nodeStats.getNode().getId();
        String nodeName = nodeStats.getNode().getName();
        if (logger.isTraceEnabled()) {
            logger.trace("node [{}]: least available: total: {}, available: {}", (Object)nodeId, (Object)leastAvailablePath.getTotal(), (Object)leastAvailablePath.getAvailable());
        }
        if (leastAvailablePath.getTotal().getBytes() < 0L) {
            if (logger.isTraceEnabled()) {
                logger.trace("node: [{}] least available path has less than 0 total bytes of disk [{}]", (Object)nodeId, (Object)leastAvailablePath.getTotal().getBytes());
            }
            return null;
        }
        return new DiskUsage(nodeId, nodeName, leastAvailablePath.getPath(), leastAvailablePath.getTotal().getBytes(), leastAvailablePath.getAvailable().getBytes());
    }

    @Nullable
    public static DiskUsage findMostAvailable(NodeStats nodeStats) {
        if (nodeStats.getFs() == null) {
            logger.warn("node [{}/{}] did not return any filesystem stats", (Object)nodeStats.getNode().getName(), (Object)nodeStats.getNode().getId());
            return null;
        }
        FsInfo.Path mostAvailablePath = null;
        for (FsInfo.Path info : nodeStats.getFs()) {
            if (mostAvailablePath == null) {
                mostAvailablePath = info;
                continue;
            }
            if (mostAvailablePath.getAvailable().getBytes() >= info.getAvailable().getBytes()) continue;
            mostAvailablePath = info;
        }
        if (mostAvailablePath == null) {
            logger.warn("node [{}/{}] did not return any filesystem stats", (Object)nodeStats.getNode().getName(), (Object)nodeStats.getNode().getId());
            return null;
        }
        String nodeId = nodeStats.getNode().getId();
        String nodeName = nodeStats.getNode().getName();
        if (logger.isTraceEnabled()) {
            logger.trace("node [{}]: most available: total: {}, available: {}", (Object)nodeId, (Object)mostAvailablePath.getTotal(), (Object)mostAvailablePath.getAvailable());
        }
        if (mostAvailablePath.getTotal().getBytes() < 0L) {
            if (logger.isTraceEnabled()) {
                logger.trace("node: [{}] most available path has less than 0 total bytes of disk [{}]", (Object)nodeId, (Object)mostAvailablePath.getTotal().getBytes());
            }
            return null;
        }
        return new DiskUsage(nodeId, nodeName, mostAvailablePath.getPath(), mostAvailablePath.getTotal().getBytes(), mostAvailablePath.getAvailable().getBytes());
    }
}

