/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.sun.jna.Native;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.bootstrap.JNANatives;
import org.elasticsearch.common.ReferenceDocs;

final class Natives {
    private static final Logger logger = LogManager.getLogger(Natives.class);
    static final boolean JNA_AVAILABLE;

    private Natives() {
    }

    static void tryInstallSystemCallFilter(Path tmpFile) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot install system call filter because JNA is not available");
            return;
        }
        JNANatives.tryInstallSystemCallFilter(tmpFile);
    }

    static boolean isSystemCallFilterInstalled() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_SYSTEM_CALL_FILTER;
    }

    static {
        boolean v = false;
        try {
            MethodHandles.publicLookup().ensureInitialized(Native.class);
            v = true;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn(String.format(Locale.ROOT, "unable to load JNA native support library, native methods will be disabled. See %s", new Object[]{ReferenceDocs.EXECUTABLE_JNA_TMPDIR}), (Throwable)e);
        }
        JNA_AVAILABLE = v;
    }
}

