/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.bootstrap.SystemCallFilter;

class JNANatives {
    private static final Logger logger = LogManager.getLogger(JNANatives.class);
    static boolean LOCAL_SYSTEM_CALL_FILTER = false;
    static boolean LOCAL_SYSTEM_CALL_FILTER_ALL = false;

    private JNANatives() {
    }

    static void tryInstallSystemCallFilter(Path tmpFile) {
        try {
            int ret = SystemCallFilter.init(tmpFile);
            LOCAL_SYSTEM_CALL_FILTER = true;
            if (ret == 1) {
                LOCAL_SYSTEM_CALL_FILTER_ALL = true;
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("unable to install syscall filter", (Throwable)e);
            }
            logger.warn("unable to install syscall filter: ", (Throwable)e);
        }
    }
}

