/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.synonyms.GetSynonymsSetsAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetSynonymsSetsAction
extends HandledTransportAction<GetSynonymsSetsAction.Request, GetSynonymsSetsAction.Response> {
    private final SynonymsManagementAPIService synonymsManagementAPIService;

    @Inject
    public TransportGetSynonymsSetsAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/synonyms_sets/get", transportService, actionFilters, GetSynonymsSetsAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.synonymsManagementAPIService = new SynonymsManagementAPIService(client);
    }

    @Override
    protected void doExecute(Task task, GetSynonymsSetsAction.Request request, ActionListener<GetSynonymsSetsAction.Response> listener) {
        this.synonymsManagementAPIService.getSynonymsSets(request.from(), request.size(), listener.map(GetSynonymsSetsAction.Response::new));
    }
}

