/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.TransportOpenPointInTimeAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestOpenPointInTimeAction
extends BaseRestHandler {
    private static final ObjectParser<OpenPointInTimeRequest, Void> PARSER = new ObjectParser("open_point_in_time_request");
    private static final ParseField INDEX_FILTER_FIELD = new ParseField("index_filter", new String[0]);

    @Override
    public String getName() {
        return "open_point_in_time";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_pit"), new RestHandler.Route(RestRequest.Method.POST, "/_pit"));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        OpenPointInTimeRequest openRequest = new OpenPointInTimeRequest(indices);
        openRequest.indicesOptions(IndicesOptions.fromRequest(request, OpenPointInTimeRequest.DEFAULT_INDICES_OPTIONS));
        openRequest.routing(request.param("routing"));
        openRequest.preference(request.param("preference"));
        openRequest.keepAlive(TimeValue.parseTimeValue(request.param("keep_alive"), null, "keep_alive"));
        if (request.hasParam("max_concurrent_shard_requests")) {
            int maxConcurrentShardRequests = request.paramAsInt("max_concurrent_shard_requests", openRequest.maxConcurrentShardRequests());
            openRequest.maxConcurrentShardRequests(maxConcurrentShardRequests);
        }
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                PARSER.parse((XContentParser)parser, openRequest, (Void)null);
            }
        });
        return channel -> client.execute(TransportOpenPointInTimeAction.TYPE, openRequest, new RestToXContentListener((RestChannel)channel));
    }

    static {
        PARSER.declareObject(OpenPointInTimeRequest::indexFilter, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery(p), INDEX_FILTER_FIELD);
    }
}

