/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.CountedCollector;
import org.elasticsearch.action.search.ExpandSearchPhase;
import org.elasticsearch.action.search.FetchLookupFieldsPhase;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.RankDocShardInfo;

final class FetchSearchPhase
extends SearchPhase {
    private final ArraySearchPhaseResults<FetchSearchResult> fetchResults;
    private final AtomicArray<SearchPhaseResult> searchPhaseShardResults;
    private final BiFunction<SearchResponseSections, AtomicArray<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final Logger logger;
    private final SearchProgressListener progressListener;
    private final AggregatedDfs aggregatedDfs;
    private final SearchPhaseController.ReducedQueryPhase reducedQueryPhase;

    FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, AggregatedDfs aggregatedDfs, SearchPhaseContext context, SearchPhaseController.ReducedQueryPhase reducedQueryPhase) {
        this(resultConsumer, aggregatedDfs, context, reducedQueryPhase, (response, queryPhaseResults) -> new ExpandSearchPhase(context, response.hits, () -> new FetchLookupFieldsPhase(context, (SearchResponseSections)response, (AtomicArray<SearchPhaseResult>)queryPhaseResults)));
    }

    FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, AggregatedDfs aggregatedDfs, SearchPhaseContext context, SearchPhaseController.ReducedQueryPhase reducedQueryPhase, BiFunction<SearchResponseSections, AtomicArray<SearchPhaseResult>, SearchPhase> nextPhaseFactory) {
        super("fetch");
        if (context.getNumShards() != resultConsumer.getNumShards()) {
            throw new IllegalStateException("number of shards must match the length of the query results but doesn't:" + context.getNumShards() + "!=" + resultConsumer.getNumShards());
        }
        this.fetchResults = new ArraySearchPhaseResults(resultConsumer.getNumShards());
        context.addReleasable(this.fetchResults);
        this.searchPhaseShardResults = resultConsumer.getAtomicArray();
        this.aggregatedDfs = aggregatedDfs;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.logger = context.getLogger();
        this.progressListener = context.getTask().getProgressListener();
        this.reducedQueryPhase = reducedQueryPhase;
    }

    @Override
    public void run() {
        this.context.execute(new AbstractRunnable(){

            @Override
            protected void doRun() {
                FetchSearchPhase.this.innerRun();
            }

            @Override
            public void onFailure(Exception e) {
                FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
            }
        });
    }

    private void innerRun() {
        boolean queryAndFetchOptimization;
        int numShards = this.context.getNumShards();
        boolean bl = queryAndFetchOptimization = this.searchPhaseShardResults.length() == 1 && !this.context.getRequest().hasKnnSearch() && this.reducedQueryPhase.queryPhaseRankCoordinatorContext() == null;
        if (queryAndFetchOptimization) {
            assert (this.assertConsistentWithQueryAndFetchOptimization());
            this.moveToNextPhase(this.searchPhaseShardResults);
        } else {
            ScoreDoc[] scoreDocs = this.reducedQueryPhase.sortedTopDocs().scoreDocs();
            if (scoreDocs.length == 0) {
                this.searchPhaseShardResults.asList().forEach(searchPhaseShardResult -> this.releaseIrrelevantSearchContext((SearchPhaseResult)searchPhaseShardResult, this.context));
                this.moveToNextPhase(this.fetchResults.getAtomicArray());
            } else {
                boolean shouldExplainRank = this.shouldExplainRankScores(this.context.getRequest());
                List<Map<Integer, RankDoc>> rankDocsPerShard = false == shouldExplainRank ? null : this.splitRankDocsPerShard(scoreDocs, numShards);
                ScoreDoc[] lastEmittedDocPerShard = this.context.getRequest().scroll() != null ? SearchPhaseController.getLastEmittedDocPerShard(this.reducedQueryPhase, numShards) : null;
                List<Integer>[] docIdsToLoad = SearchPhaseController.fillDocIdsToLoad(numShards, scoreDocs);
                CountedCollector<FetchSearchResult> counter = new CountedCollector<FetchSearchResult>(this.fetchResults, docIdsToLoad.length, () -> this.moveToNextPhase(this.fetchResults.getAtomicArray()), this.context);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    List<Integer> entry = docIdsToLoad[i];
                    RankDocShardInfo rankDocs = rankDocsPerShard == null || rankDocsPerShard.get(i).isEmpty() ? null : new RankDocShardInfo(rankDocsPerShard.get(i));
                    SearchPhaseResult shardPhaseResult = this.searchPhaseShardResults.get(i);
                    if (entry == null) {
                        if (shardPhaseResult != null) {
                            this.releaseIrrelevantSearchContext(shardPhaseResult, this.context);
                            this.progressListener.notifyFetchResult(i);
                        }
                        counter.countDown();
                        continue;
                    }
                    this.executeFetch(shardPhaseResult, counter, entry, rankDocs, lastEmittedDocPerShard != null ? lastEmittedDocPerShard[i] : null);
                }
            }
        }
    }

    private List<Map<Integer, RankDoc>> splitRankDocsPerShard(ScoreDoc[] scoreDocs, int numShards) {
        ArrayList<Map<Integer, RankDoc>> rankDocsPerShard = new ArrayList<Map<Integer, RankDoc>>(numShards);
        for (int i = 0; i < numShards; ++i) {
            rankDocsPerShard.add(new HashMap());
        }
        for (ScoreDoc scoreDoc : scoreDocs) {
            assert (scoreDoc instanceof RankDoc) : "ScoreDoc is not a RankDoc";
            assert (scoreDoc.shardIndex >= 0 && scoreDoc.shardIndex <= numShards);
            RankDoc rankDoc = (RankDoc)scoreDoc;
            Map shardScoreDocs = (Map)rankDocsPerShard.get(rankDoc.shardIndex);
            shardScoreDocs.put(rankDoc.doc, rankDoc);
        }
        return rankDocsPerShard;
    }

    private boolean assertConsistentWithQueryAndFetchOptimization() {
        List<SearchPhaseResult> phaseResults = this.searchPhaseShardResults.asList();
        assert (phaseResults.isEmpty() || phaseResults.get(0).fetchResult() != null) : "phaseResults empty [" + phaseResults.isEmpty() + "], single result: " + phaseResults.get(0).fetchResult();
        return true;
    }

    private void executeFetch(final SearchPhaseResult shardPhaseResult, final CountedCollector<FetchSearchResult> counter, List<Integer> entry, RankDocShardInfo rankDocs, ScoreDoc lastEmittedDocForShard) {
        final SearchShardTarget shardTarget = shardPhaseResult.getSearchShardTarget();
        final int shardIndex = shardPhaseResult.getShardIndex();
        final ShardSearchContextId contextId = shardPhaseResult.queryResult() != null ? shardPhaseResult.queryResult().getContextId() : shardPhaseResult.rankFeatureResult().getContextId();
        this.context.getSearchTransport().sendExecuteFetch(this.context.getConnection(shardTarget.getClusterAlias(), shardTarget.getNodeId()), new ShardFetchSearchRequest(this.context.getOriginalIndices(shardPhaseResult.getShardIndex()), contextId, shardPhaseResult.getShardSearchRequest(), entry, rankDocs, lastEmittedDocForShard, shardPhaseResult.getRescoreDocIds(), this.aggregatedDfs), this.context.getTask(), new SearchActionListener<FetchSearchResult>(shardTarget, shardIndex){

            @Override
            public void innerOnResponse(FetchSearchResult result) {
                try {
                    FetchSearchPhase.this.progressListener.notifyFetchResult(shardIndex);
                    counter.onResult(result);
                }
                catch (Exception e) {
                    FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    FetchSearchPhase.this.logger.debug(() -> "[" + contextId + "] Failed to execute fetch phase", (Throwable)e);
                    FetchSearchPhase.this.progressListener.notifyFetchFailure(shardIndex, shardTarget, e);
                    counter.onFailure(shardIndex, shardTarget, e);
                }
                finally {
                    FetchSearchPhase.this.releaseIrrelevantSearchContext(shardPhaseResult, FetchSearchPhase.this.context);
                }
            }
        });
    }

    private void moveToNextPhase(AtomicArray<? extends SearchPhaseResult> fetchResultsArr) {
        SearchResponseSections resp = SearchPhaseController.merge(this.context.getRequest().scroll() != null, this.reducedQueryPhase, fetchResultsArr);
        this.context.addReleasable(resp::decRef);
        this.fetchResults.close();
        this.context.executeNextPhase(this, this.nextPhaseFactory.apply(resp, this.searchPhaseShardResults));
    }

    private boolean shouldExplainRankScores(SearchRequest request) {
        return request.source() != null && request.source().explain() != null && request.source().explain() != false && request.source().rankBuilder() != null;
    }
}

